// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;

@Namespace("torch::jit") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class GraphExecutor extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public GraphExecutor(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public GraphExecutor(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public GraphExecutor position(long position) {
        return (GraphExecutor)super.position(position);
    }
    @Override public GraphExecutor getPointer(long i) {
        return new GraphExecutor((Pointer)this).offsetAddress(i);
    }

  public GraphExecutor() { super((Pointer)null); allocate(); }
  private native void allocate();
  public GraphExecutor(@Const @SharedPtr("torch::jit::Graph") @ByRef Graph graph, @StdString BytePointer function_name) { super((Pointer)null); allocate(graph, function_name); }
  private native void allocate(@Const @SharedPtr("torch::jit::Graph") @ByRef Graph graph, @StdString BytePointer function_name);
  public GraphExecutor(@Const @SharedPtr("torch::jit::Graph") @ByRef Graph graph, @StdString String function_name) { super((Pointer)null); allocate(graph, function_name); }
  private native void allocate(@Const @SharedPtr("torch::jit::Graph") @ByRef Graph graph, @StdString String function_name);

  public GraphExecutor(
        @Const @SharedPtr("torch::jit::Graph") @ByRef Graph graph,
        @StdString BytePointer function_name,
        ExecutorExecutionMode executor_mode) { super((Pointer)null); allocate(graph, function_name, executor_mode); }
  private native void allocate(
        @Const @SharedPtr("torch::jit::Graph") @ByRef Graph graph,
        @StdString BytePointer function_name,
        ExecutorExecutionMode executor_mode);
  public GraphExecutor(
        @Const @SharedPtr("torch::jit::Graph") @ByRef Graph graph,
        @StdString String function_name,
        @Cast("torch::jit::ExecutorExecutionMode") int executor_mode) { super((Pointer)null); allocate(graph, function_name, executor_mode); }
  private native void allocate(
        @Const @SharedPtr("torch::jit::Graph") @ByRef Graph graph,
        @StdString String function_name,
        @Cast("torch::jit::ExecutorExecutionMode") int executor_mode);

  public native void run(@ByRef IValueVector inputs);
  public native @ByVal FuturePtr runAsync(
        @ByRef IValueVector stack,
        @ByVal(nullValue = "torch::jit::TaskLauncher(at::launch)") @Cast("torch::jit::TaskLauncher*") Pointer taskLauncher);
  public native @ByVal FuturePtr runAsync(
        @ByRef IValueVector stack);

  // `remaining_bailout_depth` stands for the maximum number of profiled and
  // specialized recompilations allowed for the current `GraphExecutor`. if
  // remaining_bailout_depth is equal to 0, `GraphExecutor` won't perform any
  // profiling and specialization. This is also equivalent to the
  // SIMPLE_EXECUTOR mode. if remaining_bailout_depth is greater than 0,
  // `GraphExecutor` will profile and specialize its input graph based on the
  // profiled information whenever a bailout check is failed/triggered, a new
  // `GraphExecutor` will be created. This new `GraphExecutor`'s
  // remaining_bailout_depth will be reduced by 1.
  // If no bailout depth is passed, the depth will be initialized from the
  // current global fusion strategy settings.
  public native @Const @ByRef ExecutionPlan getPlanFor(
        @ByRef IValueVector inputs,
        @ByVal(nullValue = "c10::optional<size_t>(c10::nullopt)") SizeTOptional remaining_bailout_depth);
  public native @Const @ByRef ExecutionPlan getPlanFor(
        @ByRef IValueVector inputs);
  public native @ByVal GraphExecutorState getDebugState();

  public native void debugFlushCompilationCache();

  public native @Cast("bool") boolean isOptimized();
}
