// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


@Namespace("torch::jit") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class Graph extends Pointer {
    static { Loader.load(); }

  
  
  public Graph(@ByVal(nullValue = "torch::jit::ScopePtr(c10::make_intrusive<torch::jit::Scope>())") @Cast("torch::jit::ScopePtr*") Pointer scope_root) { super((Pointer)null); allocate(scope_root); }
  @SharedPtr @Name("std::make_shared<torch::jit::Graph>") private native void allocate(@ByVal(nullValue = "torch::jit::ScopePtr(c10::make_intrusive<torch::jit::Scope>())") @Cast("torch::jit::ScopePtr*") Pointer scope_root);
  public Graph() { super((Pointer)null); allocate(); }
  @SharedPtr @Name("std::make_shared<torch::jit::Graph>") private native void allocate();

  public native @ByVal ValueArrayRef inputs();
  public native @ByVal ValueArrayRef outputs();
  public native @ByVal graph_node_list nodes();
  public native JitNode param_node();
  public native JitNode return_node();
  public native @Const @ByRef StringValueMap debugNames();

  public native void push_scope(@StdString BytePointer scope_name);
  public native void push_scope(@StdString String scope_name);
  public native void pop_scope();

  public native @ByVal @Cast("torch::jit::ScopePtr*") Pointer current_scope();

  public native void set_op_version(@ByVal SizeTOptional version);

  public native @ByVal SizeTOptional get_op_version();

  public native void set_current_scope(@ByVal @Cast("torch::jit::ScopePtr*") Pointer scope);

  public native Value addInput(@StdString BytePointer name/*=""*/);
  public native Value addInput();
  public native Value addInput(@StdString String name/*=""*/);
  public native Value insertInput(@Cast("size_t") long i, @StdString BytePointer name/*=""*/);
  public native Value insertInput(@Cast("size_t") long i);
  public native Value insertInput(@Cast("size_t") long i, @StdString String name/*=""*/);
  public native void eraseInput(@Cast("size_t") long i);
  public native @Cast("size_t") long registerOutput(Value n);
  public native void eraseOutput(@Cast("size_t") long i);

  public native JitNode create(@ByVal @Cast("torch::jit::NodeKind*") Symbol kind, @Cast("size_t") long num_outputs/*=1*/);
  public native JitNode create(@ByVal @Cast("torch::jit::NodeKind*") Symbol kind);
  public native JitNode create(
        @ByVal @Cast("torch::jit::NodeKind*") Symbol kind,
        @ByVal ValueArrayRef inputs,
        @Cast("size_t") long num_outputs/*=1*/);
  public native JitNode create(
        @ByVal @Cast("torch::jit::NodeKind*") Symbol kind,
        @ByVal ValueArrayRef inputs);
  public native JitNode create(
        @ByVal @Cast("torch::jit::NodeKind*") Symbol kind,
        @ByVal ValueVector inputs,
        @Cast("size_t") long num_outputs/*=1*/);
  public native JitNode create(
        @ByVal @Cast("torch::jit::NodeKind*") Symbol kind,
        @ByVal ValueVector inputs);

  public native JitNode createNone();
  public native JitNode createAutogradZero();
  public native JitNode createUninitialized(@ByVal Type.TypePtr typ);
  public native JitNode createWithSubgraph(@ByVal Symbol kind);
  
  public native JitNode createTuple(
        @ByVal ValueArrayRef values,
        @SharedPtr TupleType optional_named_tuple/*=nullptr*/);
  public native JitNode createTuple(
        @ByVal ValueArrayRef values);
  public native JitNode createTuple(
        @ByVal ValueVector values,
        @SharedPtr TupleType optional_named_tuple/*=nullptr*/);
  public native JitNode createTuple(
        @ByVal ValueVector values);
  public native JitNode createTupleUnpack(Value v);
  public native JitNode createTupleIndex(
        Value tup,
        Value idx,
        @Const @ByRef Type.TypePtr output_type);
  public native JitNode createTupleSlice(
        Value tup,
        @Cast("int64_t") long beg,
        @Cast("int64_t") long step_size,
        @Cast("int64_t") long num_values);
  public native JitNode createEnumName(Value e);
  public native JitNode createEnumValue(Value e);
  public native JitNode createList(
        @Const @ByRef Type.TypePtr contained_type,
        @ByVal ValueArrayRef values);
  public native JitNode createList(
        @Const @ByRef Type.TypePtr contained_type,
        @ByVal ValueVector values);
  public native JitNode createListUnpack(Value v, @Cast("size_t") long size);
  public native JitNode createDict(
        @Const @ByRef Type.TypePtr key_type,
        @Const @ByRef Type.TypePtr value_type,
        @ByVal ValueArrayRef keys,
        @ByVal ValueArrayRef values);
  public native JitNode createDict(
        @Const @ByRef Type.TypePtr key_type,
        @Const @ByRef Type.TypePtr value_type,
        @ByVal ValueVector keys,
        @ByVal ValueVector values);
  public native JitNode createNumToTensor(Value value);
  public native JitNode createObject(@Const @SharedPtr("c10::ClassType") @ByRef ClassType type);
  public native JitNode createSetAttr(
        Value obj,
        @StdString BytePointer field,
        Value newValue);
  public native JitNode createSetAttr(
        Value obj,
        @StdString String field,
        Value newValue);
  public native JitNode createGetAttr(Value obj, @StdString BytePointer field);
  public native JitNode createGetAttr(Value obj, @StdString String field);
  public native Value insertGetAttr(Value obj, @StdString BytePointer field);
  public native Value insertGetAttr(Value obj, @StdString String field);
  public native JitNode createStore(@StdString BytePointer name, Value v);
  public native JitNode createStore(@StdString String name, Value v);
  public native JitNode createLoad(@StdString BytePointer name, @Const @ByRef Type.TypePtr type);
  public native JitNode createLoad(@StdString String name, @Const @ByRef Type.TypePtr type);
  public native JitNode createIsInstance(Value v, @ByVal TypeArrayRef types);
  public native JitNode createIsInstance(Value v, @ByVal TypeVector types);

  public native Value insertUncheckedCast(Value v, @ByVal Type.TypePtr type);

  // Insert a ToList operator with argument \p v and output type \p type.
  // \returns the output of the operation.
  public native Value insertToList(Value v, @ByVal Type.TypePtr type);

  public native Value insertFunctionCall(
        Function callee,
        @Const @ByRef MatchedSchema matched);
  public native Value insertMethodCall(
        @StdString BytePointer method_name,
        @Const @ByRef MatchedSchema matched);
  public native Value insertMethodCall(
        @StdString String method_name,
        @Const @ByRef MatchedSchema matched);

  // Note: defined in python_ir.cpp and can be used only in python extension
  
  // clone n, making a new node in _this_ graph.
  // use value_map to translate inputs of n to inputs of the cloned node
  // if copy_blocks is false, it will not recursively clone the nested blocks
  // this node contains.
  public native JitNode createClone(
        JitNode n,
        @Const @ByRef ValueMapper value_map,
        @Cast("bool") boolean copy_blocks/*=true*/);
  public native JitNode createClone(
        JitNode n,
        @Const @ByRef ValueMapper value_map);

  // Insert constant IValue into the graph.
  public native Value insertConstant(
        @Const @ByRef IValue val,
        @ByVal(nullValue = "c10::optional<torch::jit::SourceRange>(c10::nullopt)") SourceRangeOptional loc,
        @ByVal(nullValue = "c10::optional<torch::jit::ScopePtr>(c10::nullopt)") @Cast("c10::optional<torch::jit::ScopePtr>*") ScopeOptional scope);
  public native Value insertConstant(
        @Const @ByRef IValue val);

  // Schema-driven insert:
  // This inserts a node into the graph with inputs determined from args and
  // kwargs using Python argument matching rules, and checks that the op matches
  // a known schema.
  //
  // If this node successfully completes, it guarentees the node
  // is a correctly-formed invocation of opname
  public native Value insert(
        @ByVal Symbol opname,
        @ByVal NamedValueArrayRef args,
        @ByVal(nullValue = "at::ArrayRef<torch::jit::NamedValue>{}") NamedValueArrayRef kwargs,
        @Const @ByRef(nullValue = "c10::optional<torch::jit::SourceRange>{}") SourceRangeOptional range);
  public native Value insert(
        @ByVal Symbol opname,
        @ByVal NamedValueArrayRef args);

  public native JitNode appendNode(JitNode n);

  public native JitNode prependNode(JitNode n);

  // insert before insert_before_ node
  // initialized to insert at the end of the top level block
  // can be changed with setInsertPoint()
  public native JitNode insertNode(JitNode n);
  // set where nodes are inserted to append to the end of this block
  public native void setInsertPoint(Block b);
  // set where nodes are inserted to insert _before_ this node
  // for implementation simplicity we only support inserting before a node for
  // now
  public native void setInsertPoint(JitNode n);
  public native JitNode insertPoint();

  // the top level block
  public native Block block();

  // Checks well-formedness and invariants of graph
  public native void lint();
  // for use in debugger
  public native void dump();

  public native @StdString String toString();

  public native @Cast("std::ostream*") @ByRef Pointer print(
        @Cast("std::ostream*") @ByRef Pointer out,
        @Cast("bool") boolean print_source_locations/*=true*/);
  public native @Cast("std::ostream*") @ByRef Pointer print(
        @Cast("std::ostream*") @ByRef Pointer out);

  private static native @Namespace @Cast("std::ostream*") @ByRef @Name("operator <<") Pointer shiftLeft(@Cast("std::ostream*") @ByRef Pointer out, @Const @ByRef Graph g);
  public Pointer shiftLeft(Pointer out) { return shiftLeft(out, this); }

  public native @SharedPtr("torch::jit::Graph") @ByVal Graph copy();
  public native @UniquePtr @ByVal Graph copyUnique();
  public native void remapTypes(@Const @ByRef TypeMapper type_map);
}
