// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;

@Name("c10::List<c10::IValue>") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class GenericList extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public GenericList(Pointer p) { super(p); }


  /**
   * Constructs an empty list.
   */
  

  /**
   * Constructs a list with some initial values.
   * Example:
   *   List<int> a({2, 3, 4});
   */
  
  

  /**
   * Create a generic list with runtime type information.
   * This only works for c10::impl::GenericList and is not part of the public API
   * but only supposed to be used internally by PyTorch.
   */
  public GenericList(@ByVal Type.TypePtr elementType) { super((Pointer)null); allocate(elementType); }
  private native void allocate(@ByVal Type.TypePtr elementType);

  public GenericList(@Const @ByRef GenericList arg0) { super((Pointer)null); allocate(arg0); }
  private native void allocate(@Const @ByRef GenericList arg0);
  public native @ByRef @Name("operator =") GenericList put(@Const @ByRef GenericList arg0);

  /**
   * Create a new List pointing to a deep copy of the same data.
   * The List returned is a new list with separate storage.
   * Changes in it are not reflected in the original list or vice versa.
   */
  public native @ByVal GenericList copy();

  /**
   * Returns the element at specified location pos, with bounds checking.
   * If pos is not within the range of the container, an exception of type std::out_of_range is thrown.
   */
  public native @ByVal IValue get(long pos);

  /**
   * Moves out the element at the specified location pos and returns it, with bounds checking.
   * If pos is not within the range of the container, an exception of type std::out_of_range is thrown.
   * The list contains an invalid element at position pos afterwards. Any operations
   * on it before re-setting it are invalid.
   */
  public native @ByVal IValue extract(long pos);

  /**
   * Returns a reference to the element at specified location pos, with bounds checking.
   * If pos is not within the range of the container, an exception of type std::out_of_range is thrown.
   *
   * You cannot store the reference, but you can read it and assign new values to it:
   *
   *   List<int64_t> list = ...;
   *   list[2] = 5;
   *   int64_t v = list[1];
   */
  

  

  /**
   * Assigns a new value to the element at location pos.
   */
  public native void set(long pos, @ByVal IValue value);

  /**
   * Assigns a new value to the element at location pos.
   */

  /**
   * Returns an iterator to the first element of the container.
   * If the container is empty, the returned iterator will be equal to end().
   */
  public native @ByVal @Cast("c10::List<c10::IValue>::iterator*") GenericListIterator begin();

  /**
   * Returns an iterator to the element following the last element of the container.
   * This element acts as a placeholder; attempting to access it results in undefined behavior.
   */
  public native @ByVal @Cast("c10::List<c10::IValue>::iterator*") GenericListIterator end();

  /**
   * Checks if the container has no elements.
   */
  public native @Cast("bool") boolean empty();

  /**
   * Returns the number of elements in the container
   */
  public native long size();

  /**
   * Increase the capacity of the vector to a value that's greater or equal to new_cap.
   */
  public native void reserve(long new_cap);

  /**
   * Erases all elements from the container. After this call, size() returns zero.
   * Invalidates any references, pointers, or iterators referring to contained elements. Any past-the-end iterators are also invalidated.
   */
  public native void clear();

  /**
   * Inserts value before pos.
   * May invalidate any references, pointers, or iterators referring to contained elements. Any past-the-end iterators may also be invalidated.
   */
  public native @ByVal @Cast("c10::List<c10::IValue>::iterator*") GenericListIterator insert(@ByVal @Cast("c10::List<c10::IValue>::iterator*") GenericListIterator pos, @Const @ByRef IValue value);

  /**
   * Inserts value before pos.
   * May invalidate any references, pointers, or iterators referring to contained elements. Any past-the-end iterators may also be invalidated.
   */

  /**
   * Inserts a new element into the container directly before pos.
   * The new element is constructed with the given arguments.
   * May invalidate any references, pointers, or iterators referring to contained elements. Any past-the-end iterators may also be invalidated.
   */

  /**
   * Appends the given element value to the end of the container.
   * May invalidate any references, pointers, or iterators referring to contained elements. Any past-the-end iterators may also be invalidated.
   */
  public native void push_back(@Const @ByRef IValue value);

  /**
   * Appends the given element value to the end of the container.
   * May invalidate any references, pointers, or iterators referring to contained elements. Any past-the-end iterators may also be invalidated.
   */

  /**
   * Appends the given list to the end of the container. Uses at most one memory allocation.
   * May invalidate any references, pointers, or iterators referring to contained elements. Any past-the-end iterators may also be invalidated.
   */
  public native void append(@ByVal GenericList lst);

  /**
   * Appends the given element value to the end of the container.
   * The new element is constructed with the given arguments.
   * May invalidate any references, pointers, or iterators referring to contained elements. Any past-the-end iterators may also be invalidated.
   */

  /**
   * Removes the element at pos.
   * May invalidate any references, pointers, or iterators referring to contained elements. Any past-the-end iterators may also be invalidated.
   */
  public native @ByVal @Cast("c10::List<c10::IValue>::iterator*") GenericListIterator erase(@ByVal @Cast("c10::List<c10::IValue>::iterator*") GenericListIterator pos);

  /**
   * Removes the elements in the range [first, last).
   * May invalidate any references, pointers, or iterators referring to contained elements. Any past-the-end iterators may also be invalidated.
   */
  public native @ByVal @Cast("c10::List<c10::IValue>::iterator*") GenericListIterator erase(@ByVal @Cast("c10::List<c10::IValue>::iterator*") GenericListIterator first, @ByVal @Cast("c10::List<c10::IValue>::iterator*") GenericListIterator last);

  /**
   * Removes the last element of the container.
   * Calling pop_back on an empty container is undefined.
   * May invalidate any references, pointers, or iterators referring to contained elements. Any past-the-end iterators may also be invalidated.
   */
  public native void pop_back();

  /**
   * Resizes the container to contain count elements.
   * If the current size is less than count, additional default-inserted elements are appended.
   * May invalidate any references, pointers, or iterators referring to contained elements. Any past-the-end iterators may also be invalidated.
   */
  public native void resize(long count);

  /**
   * Resizes the container to contain count elements.
   * If the current size is less than count, additional copies of value are appended.
   * May invalidate any references, pointers, or iterators referring to contained elements. Any past-the-end iterators may also be invalidated.
   */
  public native void resize(long count, @Const @ByRef IValue value);

  /**
   * Value equality comparison. This function implements Python-like semantics for
   * equality: two lists with the same identity (e.g. same pointer) trivially
   * compare equal, otherwise each element is compared for equality.
   */
  

  

  /**
   * Identity comparison. Returns true if and only if {@code rhs} represents the same
   * List object as {@code this}.
   */
  public native @Cast("bool") boolean is(@Const @ByRef GenericList rhs);

  public native @ByVal IValueVector vec();

  /**
   * Returns the number of Lists currently pointing to this same list.
   * If this is the only instance pointing to this list, returns 1.
   */
  // TODO Test use_count
  public native @Cast("size_t") long use_count();

  public native @ByVal Type.TypePtr elementType();

  // See [unsafe set type] for why this exists.
  public native void unsafeSetElementType(@ByVal Type.TypePtr t);
  private static native @Namespace @Const @Name("c10::impl::ptr_to_first_element") IValue ptr_to_first_element(@Const @ByRef GenericList list);
  public IValue ptr_to_first_element() { return ptr_to_first_element(this); }
}
