// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


/** Represents a C++ function that implements an operator.  Most users won't
 *  interact directly with this class, except via error messages: the
 *  constructors this function define the set of permissible "function"-like
 *  things you can bind via the interface.
 * 
 *  This class erases the type of the passed in function, but durably records
 *  the type via an inferred schema for the function. */
@Namespace("torch") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class CppFunction extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CppFunction(Pointer p) { super(p); }

  /** This overload accepts function pointers, e.g., {@code CppFunction(&add_impl)} */

  /** This overload accepts compile time function pointers, e.g.,
   *  {@code CppFunction(TORCH_FN(add_impl))} */

  /** This overload accepts lambdas, e.g., {@code CppFunction([](const Tensor& self) {
   *  ... })} */

// #if defined C10_MOBILE
  /** This overload accepts function pointers, e.g., {@code CppFunction(&add_impl,
   *  NoInferSchemaTag())} */

  /** This overload accepts compile time function pointers, e.g.,
   *  {@code CppFunction(TORCH_FN(add_impl), NoInferSchemaTag())} */

  /** This overload accepts lambdas, e.g., {@code CppFunction([](const Tensor& self) {
   *  ... }. NoInferSchemaTag())} */
// #endif

  public CppFunction(@ByRef(true) CppFunction arg0) { super((Pointer)null); allocate(arg0); }
  @NoException(true) private native void allocate(@ByRef(true) CppFunction arg0);

  public native @ByRef @Name("operator =") CppFunction put(@ByRef(true) CppFunction arg0);

  /** \private
   *  Creates a function from a type-erased boxed kernel. */

  /** This creates a fallthrough function.  Fallthrough functions
   *  immediately redispatch to the next available dispatch key,
   *  but are implemented more efficiently than a hand written
   *  function done in the same way. */
  
  ///
  public static native @ByVal CppFunction makeFallthrough();

  /** \private
   * 
   *  Creates a function that raises an error saying that named tensors
   *  are not supported when called. */
  public static native @ByVal CppFunction makeNamedNotSupported();

  /** Create a function from a boxed kernel function with signature
   *  {@code void(const OperatorHandle&, Stack*)}; i.e., they receive a
   *  stack of arguments in a boxed calling convention, rather than
   *  in the native C++ calling convention.  Boxed functions are
   *  typically only used to register backend fallbacks via
   *  torch::Library::fallback(). */

  // Variant that takes in a boxed kernel function with a plumbed
  // DispatchKeySet. See Note [Plumbing Keys Through The Dispatcher] for
  // details.

  /** Create a function from a boxed kernel functor which defines
   *  {@code operator()(const OperatorHandle&, DispatchKeySet, Stack*)}
   *  (receiving arguments from boxed calling convention) and inherits
   *  from {@code c10::OperatorKernel}.  Unlike makeFromBoxedFunction, functions
   *  registered in this way can also carry additional state which
   *  is managed by the functor; this is useful if you're writing an
   *  adapter to some other implementation, e.g., a Python callable, which
   *  is dynamically associated with the registered kernel. */

  /** Create a function from an unboxed kernel function.
   *  This is typically used to register common operators. */

  /** Create a function from a compile time unboxed kernel function pointer.
   *  This is typically used to register common operators.
   *  Compile time function pointers can be used to allow the compiler
   *  to optimize (e.g. inline) calls to it. */

  
}
