// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


/** Returns the cosine similarity between :math:{@code x_1} and :math:{@code x_2}, computed
 *  along {@code dim}.
 *  See https://pytorch.org/docs/master/nn.html#torch.nn.CosineSimilarity to
 *  learn about the exact behavior of this module.
 * 
 *  See the documentation for {@code torch::nn::CosineSimilarityOptions} class to
 *  learn what constructor arguments are supported for this module.
 * 
 *  Example:
 *  <pre>{@code
 *  CosineSimilarity model(CosineSimilarityOptions().dim(0).eps(0.5));
 *  }</pre> */
@Namespace("torch::nn") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class CosineSimilarityImpl extends CosineSimilarityImplCloneable {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CosineSimilarityImpl(Pointer p) { super(p); }
    /** Downcast constructor. */
    public CosineSimilarityImpl(Module pointer) { super((Pointer)null); allocate(pointer); }
    @Namespace private native @SharedPtr @Name("SHARED_PTR_NAMESPACE::dynamic_pointer_cast<torch::nn::CosineSimilarityImpl, torch::nn::Module>") void allocate(@SharedPtr Module pointer);

  public CosineSimilarityImpl(@Const @ByRef(nullValue = "torch::nn::CosineSimilarityOptions{}") CosineSimilarityOptions options_) { super((Pointer)null); allocate(options_); }
  @SharedPtr @Name("std::make_shared<torch::nn::CosineSimilarityImpl>") private native void allocate(@Const @ByRef(nullValue = "torch::nn::CosineSimilarityOptions{}") CosineSimilarityOptions options_);
  public CosineSimilarityImpl() { super((Pointer)null); allocate(); }
  @SharedPtr @Name("std::make_shared<torch::nn::CosineSimilarityImpl>") private native void allocate();

  public native void reset();

  /** Pretty prints the {@code CosineSimilarity} module into the given {@code stream}. */
  public native void pretty_print(@Cast("std::ostream*") @ByRef Pointer stream);

  public native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2);

  /** The options with which this {@code Module} was constructed. */
  public native @ByRef CosineSimilarityOptions options(); public native CosineSimilarityImpl options(CosineSimilarityOptions setter);
}
