// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ CTCLoss ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

/** The Connectionist Temporal Classification loss.
 *  See https://pytorch.org/docs/master/nn.html#torch.nn.CTCLoss to learn
 *  about the exact behavior of this module.
 * 
 *  See the documentation for {@code torch::nn::CTCLossOptions} class to learn what
 *  constructor arguments are supported for this module.
 * 
 *  Example:
 *  <pre>{@code
 *  CTCLoss
 *  model(CTCLossOptions().blank(42).zero_infinity(false).reduction(torch::kSum));
 *  }</pre> */
@Namespace("torch::nn") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class CTCLossImpl extends CTCLossImplCloneable {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CTCLossImpl(Pointer p) { super(p); }
    /** Downcast constructor. */
    public CTCLossImpl(Module pointer) { super((Pointer)null); allocate(pointer); }
    @Namespace private native @SharedPtr @Name("SHARED_PTR_NAMESPACE::dynamic_pointer_cast<torch::nn::CTCLossImpl, torch::nn::Module>") void allocate(@SharedPtr Module pointer);

  public CTCLossImpl(@ByVal(nullValue = "torch::nn::CTCLossOptions{}") CTCLossOptions options_) { super((Pointer)null); allocate(options_); }
  @SharedPtr @Name("std::make_shared<torch::nn::CTCLossImpl>") private native void allocate(@ByVal(nullValue = "torch::nn::CTCLossOptions{}") CTCLossOptions options_);
  public CTCLossImpl() { super((Pointer)null); allocate(); }
  @SharedPtr @Name("std::make_shared<torch::nn::CTCLossImpl>") private native void allocate();

  public native void reset();

  /** Pretty prints the {@code CTCLoss} module into the given {@code stream}. */
  public native void pretty_print(@Cast("std::ostream*") @ByRef Pointer stream);

  public native @ByVal Tensor forward(
        @Const @ByRef Tensor log_probs,
        @Const @ByRef Tensor targets,
        @Const @ByRef Tensor input_lengths,
        @Const @ByRef Tensor target_lengths);

  /** The options with which this {@code Module} was constructed. */
  public native @ByRef CTCLossOptions options(); public native CTCLossImpl options(CTCLossOptions setter);
}
