// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;

@Name("c10::ArrayRef<jbyte>") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class ByteArrayRef extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ByteArrayRef(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ByteArrayRef(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ByteArrayRef position(long position) {
        return (ByteArrayRef)super.position(position);
    }
    @Override public ByteArrayRef getPointer(long i) {
        return new ByteArrayRef((Pointer)this).offsetAddress(i);
    }

  /** \name Constructors
   *  \{
   <p>
   *  Construct an empty ArrayRef. */
  /* implicit */ public ByteArrayRef() { super((Pointer)null); allocate(); }
private native void allocate();

  /** Construct an ArrayRef from a single element. */
  // TODO Make this explicit
  

  /** Construct an ArrayRef from a pointer and length. */
  public ByteArrayRef(@Const BytePointer data, @Cast("size_t") long length) { super((Pointer)null); allocate(data, length); }
  private native void allocate(@Const BytePointer data, @Cast("size_t") long length);
  public ByteArrayRef(@Const ByteBuffer data, @Cast("size_t") long length) { super((Pointer)null); allocate(data, length); }
  private native void allocate(@Const ByteBuffer data, @Cast("size_t") long length);
  public ByteArrayRef(@Const byte[] data, @Cast("size_t") long length) { super((Pointer)null); allocate(data, length); }
  private native void allocate(@Const byte[] data, @Cast("size_t") long length);

  /** Construct an ArrayRef from a range. */
  public ByteArrayRef(@Const BytePointer begin, @Const BytePointer end) { super((Pointer)null); allocate(begin, end); }
  private native void allocate(@Const BytePointer begin, @Const BytePointer end);
  public ByteArrayRef(@Const ByteBuffer begin, @Const ByteBuffer end) { super((Pointer)null); allocate(begin, end); }
  private native void allocate(@Const ByteBuffer begin, @Const ByteBuffer end);
  public ByteArrayRef(@Const byte[] begin, @Const byte[] end) { super((Pointer)null); allocate(begin, end); }
  private native void allocate(@Const byte[] begin, @Const byte[] end);

  /** Construct an ArrayRef from a SmallVector. This is templated in order to
   *  avoid instantiating SmallVectorTemplateCommon<T> whenever we
   *  copy-construct an ArrayRef. */

  /** Construct an ArrayRef from a std::vector. */
  // The enable_if stuff here makes sure that this isn't used for
  // std::vector<bool>, because ArrayRef can't work on a std::vector<bool>
  // bitfield.

  /** Construct an ArrayRef from a std::array */

  /** Construct an ArrayRef from a C array. */

  /** Construct an ArrayRef from a std::initializer_list. */
  /* implicit */

  /** \}
   *  \name Simple Operations
   *  \{ */

  public native @Const BytePointer begin();
  public native @Const BytePointer end();

  // These are actually the same as iterator, since ArrayRef only
  // gives you const iterators.
  public native @Const BytePointer cbegin();
  public native @Const BytePointer cend();

  /** empty - Check if the array is empty. */
  public native @Cast("const bool") boolean empty();

  public native @Const BytePointer data();

  /** size - Get the array size. */
  public native @Cast("const size_t") long size();

  /** front - Get the first element. */
  public native byte front();

  /** back - Get the last element. */
  public native byte back();

  /** equals - Check for element-wise equality. */
  public native @Cast("const bool") boolean equals(@ByVal ByteArrayRef RHS);
  public native @Cast("const bool") boolean equals(@ByVal @Cast({"jbyte*", "c10::ArrayRef<jbyte>", "std::vector<jbyte>&"}) @StdVector("jbyte") byte... RHS);

  /** slice(n, m) - Take M elements of the array starting at element N */
  public native @Const @ByVal ByteArrayRef slice(@Cast("size_t") long N, @Cast("size_t") long M);

  /** slice(n) - Chop off the first N elements of the array. */
  public native @Const @ByVal ByteArrayRef slice(@Cast("size_t") long N);

  /** \}
   *  \name Operator Overloads
   *  \{ */
  public native @Name("operator []") byte get(@Cast("size_t") long Index);

  /** Vector compatibility */
  
  ///
  public native byte at(@Cast("size_t") long Index);

  /** Disallow accidental assignment from a temporary.
   * 
   *  The declaration here is extra complicated so that "arrayRef = {}"
   *  continues to select the move assignment operator. */
  

  /** Disallow accidental assignment from a temporary.
   * 
   *  The declaration here is extra complicated so that "arrayRef = {}"
   *  continues to select the move assignment operator. */
  

  /** \}
   *  \name Expensive Operations
   *  \{ */
  public native @StdVector BytePointer vec();

  /** \} */
}
