// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


/** The templated inference code creates {@code ArgumentDef} instead of {@code Argument},
 *  because that can be constructed at compile time and has a much smaller
 *  binary size than having calls to {@code Argument} constructors in the template.
 *  Creating {@code Argument} objects from {@code ArgumentDef} can then be done at
 *  runtime in a non-templated way. */
@Namespace("c10::detail::infer_schema") @NoOffset @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class ArgumentDef extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ArgumentDef(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ArgumentDef(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ArgumentDef position(long position) {
        return (ArgumentDef)super.position(position);
    }
    @Override public ArgumentDef getPointer(long i) {
        return new ArgumentDef((Pointer)this).offsetAddress(i);
    }

  public native TypeSupplier getTypeFn(); public native ArgumentDef getTypeFn(TypeSupplier setter);
  public native TypeSupplier getFakeTypeFn(); public native ArgumentDef getFakeTypeFn(TypeSupplier setter);
  public ArgumentDef() { super((Pointer)null); allocate(); }
  private native void allocate();
  public ArgumentDef(TypeSupplier getTypeFn, TypeSupplier getFakeTypeFn) { super((Pointer)null); allocate(getTypeFn, getFakeTypeFn); }
  private native void allocate(TypeSupplier getTypeFn, TypeSupplier getFakeTypeFn);
}
