// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


/** Stores a type erased {@code Module}.
 * 
 *  The PyTorch C++ API does not impose an interface on the signature of
 *  {@code forward()} in {@code Module} subclasses. This gives you complete freedom to
 *  design your {@code forward()} methods to your liking. However, this also means
 *  there is no unified base type you could store in order to call {@code forward()}
 *  polymorphically for any module. This is where the {@code AnyModule} comes in.
 *  Instead of inheritance, it relies on type erasure for polymorphism.
 * 
 *  An {@code AnyModule} can store any {@code nn::Module} subclass that provides a
 *  {@code forward()} method. This {@code forward()} may accept any types and return any
 *  type. Once stored in an {@code AnyModule}, you can invoke the underlying module's
 *  {@code forward()} by calling {@code AnyModule::forward()} with the arguments you would
 *  supply to the stored module (though see one important limitation below).
 *  Example:
 * 
 *  \rst
 *  .. code-block:: cpp
 * 
 *    struct GenericTrainer {
 *      torch::nn::AnyModule module;
 * 
 *      void train(torch::Tensor input) {
 *        module.forward(input);
 *      }
 *    };
 * 
 *    GenericTrainer trainer1{torch::nn::Linear(3, 4)};
 *    GenericTrainer trainer2{torch::nn::Conv2d(3, 4, 2)};
 *  \endrst
 * 
 *  As {@code AnyModule} erases the static type of the stored module (and its
 *  {@code forward()} method) to achieve polymorphism, type checking of arguments is
 *  moved to runtime. That is, passing an argument with an incorrect type to an
 *  {@code AnyModule} will compile, but throw an exception at runtime:
 * 
 *  \rst
 *  .. code-block:: cpp
 * 
 *    torch::nn::AnyModule module(torch::nn::Linear(3, 4));
 *    // Linear takes a tensor as input, but we are passing an integer.
 *    // This will compile, but throw a {@code torch::Error} exception at runtime.
 *    module.forward(123);
 *  \endrst
 * 
 *  \rst
 *  .. attention::
 *    One noteworthy limitation of {@code AnyModule} is that its {@code forward()} method
 *    does not support implicit conversion of argument types. For example, if
 *    the stored module's {@code forward()} method accepts a {@code float} and you call
 *    {@code any_module.forward(3.4)} (where {@code 3.4} is a {@code double}), this will throw
 *    an exception.
 *  \endrst
 * 
 *  The return type of the {@code AnyModule}'s {@code forward()} method is controlled via
 *  the first template argument to {@code AnyModule::forward()}. It defaults to
 *  {@code torch::Tensor}. To change it, you can write {@code any_module.forward<int>()},
 *  for example.
 * 
 *  \rst
 *  .. code-block:: cpp
 * 
 *    torch::nn::AnyModule module(torch::nn::Linear(3, 4));
 *    auto output = module.forward(torch::ones({2, 3}));
 * 
 *    struct IntModule {
 *      int forward(int x) { return x; }
 *    };
 *    torch::nn::AnyModule module(IntModule{});
 *    int output = module.forward<int>(5);
 *  \endrst
 * 
 *  The only other method an {@code AnyModule} provides access to on the stored
 *  module is {@code clone()}. However, you may acquire a handle on the module via
 *  {@code .ptr()}, which returns a {@code shared_ptr<nn::Module>}. Further, if you know
 *  the concrete type of the stored module, you can get a concrete handle to it
 *  using {@code .get<T>()} where {@code T} is the concrete module type.
 * 
 *  \rst
 *  .. code-block:: cpp
 * 
 *    torch::nn::AnyModule module(torch::nn::Linear(3, 4));
 *    std::shared_ptr<nn::Module> ptr = module.ptr();
 *    torch::nn::Linear linear(module.get<torch::nn::Linear>());
 *  \endrst */
@Namespace("torch::nn") @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class AnyModule extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AnyModule(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AnyModule(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public AnyModule position(long position) {
        return (AnyModule)super.position(position);
    }
    @Override public AnyModule getPointer(long i) {
        return new AnyModule((Pointer)this).offsetAddress(i);
    }

  /** A default-constructed {@code AnyModule} is in an empty state. */
  public AnyModule() { super((Pointer)null); allocate(); }
  private native void allocate();

  /** Constructs an {@code AnyModule} from a {@code shared_ptr} to concrete module object. */
  public AnyModule(AdaptiveLogSoftmaxWithLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::AdaptiveLogSoftmaxWithLossImpl>"}) AdaptiveLogSoftmaxWithLossImpl module);
  public AnyModule(BatchNorm1dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::BatchNorm1dImpl>"}) BatchNorm1dImpl module);
  public AnyModule(InstanceNorm1dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::InstanceNorm1dImpl>"}) InstanceNorm1dImpl module);
  public AnyModule(Conv1dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::Conv1dImpl>"}) Conv1dImpl module);
  public AnyModule(ConvTranspose1dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ConvTranspose1dImpl>"}) ConvTranspose1dImpl module);
  public AnyModule(DropoutImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::DropoutImpl>"}) DropoutImpl module);
  public AnyModule(BatchNorm2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::BatchNorm2dImpl>"}) BatchNorm2dImpl module);
  public AnyModule(InstanceNorm2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::InstanceNorm2dImpl>"}) InstanceNorm2dImpl module);
  public AnyModule(Conv2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::Conv2dImpl>"}) Conv2dImpl module);
  public AnyModule(ConvTranspose2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ConvTranspose2dImpl>"}) ConvTranspose2dImpl module);
  public AnyModule(Dropout2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::Dropout2dImpl>"}) Dropout2dImpl module);
  public AnyModule(BatchNorm3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::BatchNorm3dImpl>"}) BatchNorm3dImpl module);
  public AnyModule(InstanceNorm3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::InstanceNorm3dImpl>"}) InstanceNorm3dImpl module);
  public AnyModule(Conv3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::Conv3dImpl>"}) Conv3dImpl module);
  public AnyModule(ConvTranspose3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ConvTranspose3dImpl>"}) ConvTranspose3dImpl module);
  public AnyModule(Dropout3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::Dropout3dImpl>"}) Dropout3dImpl module);
  public AnyModule(AlphaDropoutImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::AlphaDropoutImpl>"}) AlphaDropoutImpl module);
  public AnyModule(FeatureAlphaDropoutImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::FeatureAlphaDropoutImpl>"}) FeatureAlphaDropoutImpl module);
  public AnyModule(CosineSimilarityImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::CosineSimilarityImpl>"}) CosineSimilarityImpl module);
  public AnyModule(PairwiseDistanceImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::PairwiseDistanceImpl>"}) PairwiseDistanceImpl module);
  public AnyModule(EmbeddingImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::EmbeddingImpl>"}) EmbeddingImpl module);
  public AnyModule(EmbeddingBagImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::EmbeddingBagImpl>"}) EmbeddingBagImpl module);
  public AnyModule(FoldImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::FoldImpl>"}) FoldImpl module);
  public AnyModule(UnfoldImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::UnfoldImpl>"}) UnfoldImpl module);
  public AnyModule(IdentityImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::IdentityImpl>"}) IdentityImpl module);
  public AnyModule(LinearImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::LinearImpl>"}) LinearImpl module);
  public AnyModule(BilinearImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::BilinearImpl>"}) BilinearImpl module);
  public AnyModule(FlattenImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::FlattenImpl>"}) FlattenImpl module);
  public AnyModule(UnflattenImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::UnflattenImpl>"}) UnflattenImpl module);
  public AnyModule(L1LossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::L1LossImpl>"}) L1LossImpl module);
  public AnyModule(KLDivLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::KLDivLossImpl>"}) KLDivLossImpl module);
  public AnyModule(MSELossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::MSELossImpl>"}) MSELossImpl module);
  public AnyModule(BCELossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::BCELossImpl>"}) BCELossImpl module);
  public AnyModule(HingeEmbeddingLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::HingeEmbeddingLossImpl>"}) HingeEmbeddingLossImpl module);
  public AnyModule(MultiMarginLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::MultiMarginLossImpl>"}) MultiMarginLossImpl module);
  public AnyModule(CosineEmbeddingLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::CosineEmbeddingLossImpl>"}) CosineEmbeddingLossImpl module);
  public AnyModule(SmoothL1LossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::SmoothL1LossImpl>"}) SmoothL1LossImpl module);
  public AnyModule(HuberLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::HuberLossImpl>"}) HuberLossImpl module);
  public AnyModule(MultiLabelMarginLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::MultiLabelMarginLossImpl>"}) MultiLabelMarginLossImpl module);
  public AnyModule(SoftMarginLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::SoftMarginLossImpl>"}) SoftMarginLossImpl module);
  public AnyModule(MultiLabelSoftMarginLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::MultiLabelSoftMarginLossImpl>"}) MultiLabelSoftMarginLossImpl module);
  public AnyModule(TripletMarginLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::TripletMarginLossImpl>"}) TripletMarginLossImpl module);
  public AnyModule(TripletMarginWithDistanceLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::TripletMarginWithDistanceLossImpl>"}) TripletMarginWithDistanceLossImpl module);
  public AnyModule(CTCLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::CTCLossImpl>"}) CTCLossImpl module);
  public AnyModule(PoissonNLLLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::PoissonNLLLossImpl>"}) PoissonNLLLossImpl module);
  public AnyModule(MarginRankingLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::MarginRankingLossImpl>"}) MarginRankingLossImpl module);
  public AnyModule(NLLLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::NLLLossImpl>"}) NLLLossImpl module);
  public AnyModule(CrossEntropyLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::CrossEntropyLossImpl>"}) CrossEntropyLossImpl module);
  public AnyModule(BCEWithLogitsLossImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::BCEWithLogitsLossImpl>"}) BCEWithLogitsLossImpl module);
  public AnyModule(ReflectionPad1dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ReflectionPad1dImpl>"}) ReflectionPad1dImpl module);
  public AnyModule(ReplicationPad1dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ReplicationPad1dImpl>"}) ReplicationPad1dImpl module);
  public AnyModule(ConstantPad1dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ConstantPad1dImpl>"}) ConstantPad1dImpl module);
  public AnyModule(ZeroPad1dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ZeroPad1dImpl>"}) ZeroPad1dImpl module);
  public AnyModule(AvgPool1dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::AvgPool1dImpl>"}) AvgPool1dImpl module);
  public AnyModule(MaxPool1dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::MaxPool1dImpl>"}) MaxPool1dImpl module);
  public AnyModule(AdaptiveAvgPool1dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::AdaptiveAvgPool1dImpl>"}) AdaptiveAvgPool1dImpl module);
  public AnyModule(AdaptiveMaxPool1dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::AdaptiveMaxPool1dImpl>"}) AdaptiveMaxPool1dImpl module);
  public AnyModule(MaxUnpool1dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::MaxUnpool1dImpl>"}) MaxUnpool1dImpl module);
  public AnyModule(LPPool1dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::LPPool1dImpl>"}) LPPool1dImpl module);
  public AnyModule(ReflectionPad2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ReflectionPad2dImpl>"}) ReflectionPad2dImpl module);
  public AnyModule(ReplicationPad2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ReplicationPad2dImpl>"}) ReplicationPad2dImpl module);
  public AnyModule(ConstantPad2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ConstantPad2dImpl>"}) ConstantPad2dImpl module);
  public AnyModule(ZeroPad2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ZeroPad2dImpl>"}) ZeroPad2dImpl module);
  public AnyModule(AvgPool2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::AvgPool2dImpl>"}) AvgPool2dImpl module);
  public AnyModule(MaxPool2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::MaxPool2dImpl>"}) MaxPool2dImpl module);
  public AnyModule(AdaptiveAvgPool2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::AdaptiveAvgPool2dImpl>"}) AdaptiveAvgPool2dImpl module);
  public AnyModule(AdaptiveMaxPool2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::AdaptiveMaxPool2dImpl>"}) AdaptiveMaxPool2dImpl module);
  public AnyModule(MaxUnpool2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::MaxUnpool2dImpl>"}) MaxUnpool2dImpl module);
  public AnyModule(FractionalMaxPool2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::FractionalMaxPool2dImpl>"}) FractionalMaxPool2dImpl module);
  public AnyModule(LPPool2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::LPPool2dImpl>"}) LPPool2dImpl module);
  public AnyModule(ReflectionPad3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ReflectionPad3dImpl>"}) ReflectionPad3dImpl module);
  public AnyModule(ReplicationPad3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ReplicationPad3dImpl>"}) ReplicationPad3dImpl module);
  public AnyModule(ConstantPad3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ConstantPad3dImpl>"}) ConstantPad3dImpl module);
  public AnyModule(ZeroPad3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ZeroPad3dImpl>"}) ZeroPad3dImpl module);
  public AnyModule(AvgPool3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::AvgPool3dImpl>"}) AvgPool3dImpl module);
  public AnyModule(MaxPool3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::MaxPool3dImpl>"}) MaxPool3dImpl module);
  public AnyModule(AdaptiveAvgPool3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::AdaptiveAvgPool3dImpl>"}) AdaptiveAvgPool3dImpl module);
  public AnyModule(AdaptiveMaxPool3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::AdaptiveMaxPool3dImpl>"}) AdaptiveMaxPool3dImpl module);
  public AnyModule(MaxUnpool3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::MaxUnpool3dImpl>"}) MaxUnpool3dImpl module);
  public AnyModule(FractionalMaxPool3dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::FractionalMaxPool3dImpl>"}) FractionalMaxPool3dImpl module);
  public AnyModule(RNNImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::RNNImpl>"}) RNNImpl module);
  public AnyModule(LSTMImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::LSTMImpl>"}) LSTMImpl module);
  public AnyModule(GRUImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::GRUImpl>"}) GRUImpl module);
  public AnyModule(RNNCellImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::RNNCellImpl>"}) RNNCellImpl module);
  public AnyModule(LSTMCellImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::LSTMCellImpl>"}) LSTMCellImpl module);
  public AnyModule(GRUCellImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::GRUCellImpl>"}) GRUCellImpl module);
  public AnyModule(PixelShuffleImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::PixelShuffleImpl>"}) PixelShuffleImpl module);
  public AnyModule(PixelUnshuffleImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::PixelUnshuffleImpl>"}) PixelUnshuffleImpl module);
  public AnyModule(UpsampleImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::UpsampleImpl>"}) UpsampleImpl module);
  public AnyModule(ELUImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ELUImpl>"}) ELUImpl module);
  public AnyModule(SELUImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::SELUImpl>"}) SELUImpl module);
  public AnyModule(HardshrinkImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::HardshrinkImpl>"}) HardshrinkImpl module);
  public AnyModule(HardtanhImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::HardtanhImpl>"}) HardtanhImpl module);
  public AnyModule(LeakyReLUImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::LeakyReLUImpl>"}) LeakyReLUImpl module);
  public AnyModule(LogSigmoidImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::LogSigmoidImpl>"}) LogSigmoidImpl module);
  public AnyModule(SoftmaxImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::SoftmaxImpl>"}) SoftmaxImpl module);
  public AnyModule(SoftminImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::SoftminImpl>"}) SoftminImpl module);
  public AnyModule(LogSoftmaxImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::LogSoftmaxImpl>"}) LogSoftmaxImpl module);
  public AnyModule(Softmax2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::Softmax2dImpl>"}) Softmax2dImpl module);
  public AnyModule(PReLUImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::PReLUImpl>"}) PReLUImpl module);
  public AnyModule(ReLUImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ReLUImpl>"}) ReLUImpl module);
  public AnyModule(ReLU6Impl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ReLU6Impl>"}) ReLU6Impl module);
  public AnyModule(RReLUImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::RReLUImpl>"}) RReLUImpl module);
  public AnyModule(CELUImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::CELUImpl>"}) CELUImpl module);
  public AnyModule(GLUImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::GLUImpl>"}) GLUImpl module);
  public AnyModule(GELUImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::GELUImpl>"}) GELUImpl module);
  public AnyModule(SiLUImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::SiLUImpl>"}) SiLUImpl module);
  public AnyModule(MishImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::MishImpl>"}) MishImpl module);
  public AnyModule(SigmoidImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::SigmoidImpl>"}) SigmoidImpl module);
  public AnyModule(SoftplusImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::SoftplusImpl>"}) SoftplusImpl module);
  public AnyModule(SoftshrinkImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::SoftshrinkImpl>"}) SoftshrinkImpl module);
  public AnyModule(SoftsignImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::SoftsignImpl>"}) SoftsignImpl module);
  public AnyModule(TanhImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::TanhImpl>"}) TanhImpl module);
  public AnyModule(TanhshrinkImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::TanhshrinkImpl>"}) TanhshrinkImpl module);
  public AnyModule(ThresholdImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::ThresholdImpl>"}) ThresholdImpl module);
  public AnyModule(MultiheadAttentionImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::MultiheadAttentionImpl>"}) MultiheadAttentionImpl module);
  public AnyModule(LayerNormImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::LayerNormImpl>"}) LayerNormImpl module);
  public AnyModule(LocalResponseNormImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::LocalResponseNormImpl>"}) LocalResponseNormImpl module);
  public AnyModule(CrossMapLRN2dImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::CrossMapLRN2dImpl>"}) CrossMapLRN2dImpl module);
  public AnyModule(GroupNormImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::GroupNormImpl>"}) GroupNormImpl module);
  public AnyModule(TransformerEncoderLayerImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::TransformerEncoderLayerImpl>"}) TransformerEncoderLayerImpl module);
  public AnyModule(TransformerDecoderLayerImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::TransformerDecoderLayerImpl>"}) TransformerDecoderLayerImpl module);
  public AnyModule(TransformerEncoderImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::TransformerEncoderImpl>"}) TransformerEncoderImpl module);
  public AnyModule(TransformerDecoderImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::TransformerDecoderImpl>"}) TransformerDecoderImpl module);
  public AnyModule(TransformerImpl module) { super((Pointer)null); allocate(module); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<torch::nn::TransformerImpl>"}) TransformerImpl module);

  /** Constructs an {@code AnyModule} from a concrete module object. */

  /** Constructs an {@code AnyModule} from a module holder. */

  /** Move construction and assignment is allowed, and follows the default
   *  behavior of move for {@code std::unique_ptr}. */
  public AnyModule(@ByRef(true) AnyModule arg0) { super((Pointer)null); allocate(arg0); }
  private native void allocate(@ByRef(true) AnyModule arg0);
  public native @ByRef @Name("operator =") AnyModule put(@ByRef(true) AnyModule arg0);

  /** Creates a shallow copy of an {@code AnyModule}. */

  /** Creates a deep copy of an {@code AnyModule} if it contains a module, else an
   *  empty {@code AnyModule} if it is empty. */
  public native @ByVal AnyModule clone(@ByVal(nullValue = "c10::optional<torch::Device>(c10::nullopt)") DeviceOptional device);
  public native @ByVal AnyModule clone();

  /** Assigns a module to the {@code AnyModule} (to circumvent the explicit
   *  constructor). */

  /** Invokes {@code forward()} on the contained module with the given arguments, and
   *  returns the return value as an {@code AnyValue}. Use this method when chaining
   *  {@code AnyModule}s in a loop. */
  public native @ByVal AnyValue any_forward(@Const @ByRef AnyValue input);
  public native @ByVal AnyValue any_forward(@Const @ByRef Tensor input);
  public native @ByVal AnyValue any_forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2);
  public native @ByVal AnyValue any_forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3);
  public native @ByVal AnyValue any_forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4);
  public native @ByVal AnyValue any_forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4, @Const @ByRef Tensor input5, @Const @ByRef Tensor input6);
  public native @ByVal AnyValue any_forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4, @Const @ByRef Tensor input5, @Const @ByRef Tensor input6, @Const @ByRef Tensor input7, @Const @ByRef Tensor input8);
  public native @ByVal AnyValue any_forward(@Const @ByRef Tensor input, @ByRef(nullValue = "c10::optional<at::IntArrayRef>(c10::nullopt)") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long... output_size);
  public native @ByVal AnyValue any_forward(@Const @ByRef Tensor input, @Const @ByRef(nullValue = "c10::optional<at::IntArrayRef>(c10::nullopt)") LongArrayRefOptional output_size);
  public native @ByVal AnyValue any_forward(@Const @ByRef Tensor input, @Const @ByRef Tensor indices, @Const @ByRef(nullValue = "c10::optional<std::vector<int64_t> >(c10::nullopt)") LongVectorOptional output_size);
  public native @ByVal AnyValue any_forward(@Const @ByRef Tensor input, @ByVal(nullValue = "torch::optional<std::tuple<torch::Tensor,torch::Tensor> >{}") T_TensorTensor_TOptional hx_opt);
  public native @ByVal AnyValue any_forward(@Const @ByRef Tensor query, @Const @ByRef Tensor key, @Const @ByRef Tensor value, @Const @ByRef(nullValue = "torch::Tensor{}") Tensor key_padding_mask, @Cast("bool") boolean need_weights/*=true*/, @Const @ByRef(nullValue = "torch::Tensor{}") Tensor attn_mask, @Cast("bool") boolean average_attn_weights/*=true*/);

  /** Invokes {@code forward()} on the contained module with the given arguments, and
   *  casts the returned {@code AnyValue} to the supplied {@code ReturnType} (which defaults
   *  to {@code torch::Tensor}). */
  public native @ByVal Tensor forward(@Const @ByRef Tensor input);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4, @Const @ByRef Tensor input5, @Const @ByRef Tensor input6);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3, @Const @ByRef Tensor input4, @Const @ByRef Tensor input5, @Const @ByRef Tensor input6, @Const @ByRef Tensor input7, @Const @ByRef Tensor input8);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input, @ByRef(nullValue = "c10::optional<at::IntArrayRef>(c10::nullopt)") @Cast({"int64_t*", "c10::ArrayRef<int64_t>", "std::vector<int64_t>&"}) @StdVector long... output_size);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input, @Const @ByRef(nullValue = "c10::optional<at::IntArrayRef>(c10::nullopt)") LongArrayRefOptional output_size);
  public native @ByVal Tensor forward(@Const @ByRef Tensor input, @Const @ByRef Tensor indices, @Const @ByRef(nullValue = "c10::optional<std::vector<int64_t> >(c10::nullopt)") LongVectorOptional output_size);
  public native @ByVal @Name("forward<std::tuple<torch::Tensor,std::tuple<torch::Tensor,torch::Tensor>>>") T_TensorT_TensorTensor_T_T forwardT_TensorT_TensorTensor_T_T(@Const @ByRef Tensor input);
  public native @ByVal @Name("forward<std::tuple<torch::Tensor,std::tuple<torch::Tensor,torch::Tensor>>>") T_TensorT_TensorTensor_T_T forwardT_TensorT_TensorTensor_T_T(@Const @ByRef Tensor input, @ByVal(nullValue = "torch::optional<std::tuple<torch::Tensor,torch::Tensor> >{}") T_TensorTensor_TOptional hx_opt);
  public native @ByVal @Name("forward<std::tuple<torch::Tensor,torch::Tensor>>") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor input);
  public native @ByVal @Name("forward<std::tuple<torch::Tensor,torch::Tensor>>") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2);
  public native @ByVal @Name("forward<std::tuple<torch::Tensor,torch::Tensor>>") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor input1, @Const @ByRef Tensor input2, @Const @ByRef Tensor input3);
  public native @ByVal @Name("forward<std::tuple<torch::Tensor,torch::Tensor>>") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor input, @ByVal(nullValue = "torch::optional<std::tuple<torch::Tensor,torch::Tensor> >{}") T_TensorTensor_TOptional hx_opt);
  public native @ByVal @Name("forward<std::tuple<torch::Tensor,torch::Tensor>>") T_TensorTensor_T forwardT_TensorTensor_T(@Const @ByRef Tensor query, @Const @ByRef Tensor key, @Const @ByRef Tensor value, @Const @ByRef(nullValue = "torch::Tensor{}") Tensor key_padding_mask, @Cast("bool") boolean need_weights/*=true*/, @Const @ByRef(nullValue = "torch::Tensor{}") Tensor attn_mask, @Cast("bool") boolean average_attn_weights/*=true*/);
  public native @ByVal @Name("forward<torch::nn::ASMoutput>") ASMoutput forwardASMoutput(@Const @ByRef Tensor input, @Const @ByRef Tensor target);

  /** Attempts to cast the underlying module to the given module type. Throws an
   *  exception if the types do not match. */

  /** Attempts to cast the underlying module to the given module type. Throws an
   *  exception if the types do not match. */

  /** Returns the contained module in a {@code nn::ModuleHolder} subclass if possible
   *  (i.e. if {@code T} has a constructor for the underlying module type). */

  /** Returns a {@code std::shared_ptr} whose dynamic type is that of the underlying
   *  module. */
  public native @SharedPtr("torch::nn::Module") @ByVal Module ptr();

  /** Like {@code ptr()}, but casts the pointer to the given type. */

  /** Returns the {@code type_info} object of the contained value. */
  public native @Cast("const std::type_info*") @ByRef Pointer type_info();

  /** Returns true if the {@code AnyModule} does not contain a module. */
  public native @Cast("bool") @NoException(true) boolean is_empty();
}
