// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.pytorch;

import org.bytedeco.pytorch.Allocator;
import org.bytedeco.pytorch.Function;
import org.bytedeco.pytorch.functions.*;
import org.bytedeco.pytorch.Module;
import org.bytedeco.javacpp.annotation.Cast;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;

import static org.bytedeco.pytorch.global.torch.*;


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~ AdaptiveAvgPool1d ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

/** Applies adaptive avgpool over a 1-D input.
 *  See https://pytorch.org/docs/master/nn.html#torch.nn.AdaptiveAvgPool1d to
 *  learn about the exact behavior of this module.
 * 
 *  See the documentation for {@code torch::nn::AdaptiveAvgPool1dOptions} class to
 *  learn what constructor arguments are supported for this module.
 * 
 *  Example:
 *  <pre>{@code
 *  AdaptiveAvgPool1d model(AdaptiveAvgPool1dOptions(5));
 *  }</pre> */
@Namespace("torch::nn") @Properties(inherit = org.bytedeco.pytorch.presets.torch.class)
public class AdaptiveAvgPool1dImpl extends AdaptiveAvgPool1dImplBase {
    static { Loader.load(); }

  
    public AdaptiveAvgPool1dImpl(@ByVal @Cast("torch::ExpandingArray<1>*") LongPointer output_size) { super((Pointer)null); allocate(output_size); }
    private native void allocate(@ByVal @Cast("torch::ExpandingArray<1>*") LongPointer output_size);
    public AdaptiveAvgPool1dImpl(
          @Const @ByRef AdaptiveAvgPool1dOptions options_) { super((Pointer)null); allocate(options_); }
    private native void allocate(
          @Const @ByRef AdaptiveAvgPool1dOptions options_);
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AdaptiveAvgPool1dImpl(Pointer p) { super(p); }
    /** Downcast constructor. */
    public AdaptiveAvgPool1dImpl(Module pointer) { super((Pointer)null); allocate(pointer); }
    @Namespace private native @SharedPtr @Name("SHARED_PTR_NAMESPACE::dynamic_pointer_cast<torch::nn::AdaptiveAvgPool1dImpl, torch::nn::Module>") void allocate(@SharedPtr Module pointer);


  public native @ByVal Tensor forward(@Const @ByRef Tensor input);
}
