// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.leptonica;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.leptonica.global.leptonica.*;



    /**
     * <pre>
     * CCBord contains:
     *
     *    (1) a minimally-clipped bitmap of the component (pix),
     *    (2) a boxa consisting of:
     *          for the primary component:
     *                (xul, yul) pixel location in global coords
     *                (w, h) of the bitmap
     *          for the hole components:
     *                (x, y) in relative coordinates in primary component
     *                (w, h) of the hole border (which is 2 pixels
     *                       larger in each direction than the hole itself)
     *    (3) a pta ('start') of the initial border pixel location for each
     *        closed curve, all in relative coordinates of the primary
     *        component.  This is given for the primary component,
     *        followed by the hole components, if any.
     *    (4) a refcount of the ccbord; used internally when a ccbord
     *        is accessed from a ccborda (array of ccbord)
     *    (5) a ptaa for the chain code for the border in relative
     *        coordinates, where the first pta is the exterior border
     *        and all other pta are for interior borders (holes)
     *    (6) a ptaa for the global pixel loc rendition of the border,
     *        where the first pta is the exterior border and all other
     *        pta are for interior borders (holes).
     *        This is derived from the local or step chain code.
     *    (7) a numaa for the chain code for the border as orientation
     *        directions between successive border pixels, where
     *        the first numa is the exterior border and all other
     *        numa are for interior borders (holes).  This is derived
     *        from the local chain code.  The 8 directions are 0 - 7.
     *    (8) a pta for a single chain for each c.c., comprised of outer
     *        and hole borders, plus cut paths between them, all in
     *        local coords.
     *    (9) a pta for a single chain for each c.c., comprised of outer
     *        and hole borders, plus cut paths between them, all in
     *        global coords.
     * </pre>
     */
@Name("CCBord") @Properties(inherit = org.bytedeco.leptonica.presets.leptonica.class)
public class CCBORD extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public CCBORD() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CCBORD(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CCBORD(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public CCBORD position(long position) {
        return (CCBORD)super.position(position);
    }
    @Override public CCBORD getPointer(long i) {
        return new CCBORD((Pointer)this).offsetAddress(i);
    }

    /** component bitmap (min size)      */
    public native PIX pix(); public native CCBORD pix(PIX setter);
    /** regions of each closed curve     */
    public native BOXA boxa(); public native CCBORD boxa(BOXA setter);
    /** initial border pixel locations   */
    public native PTA start(); public native CCBORD start(PTA setter);
    /** number of handles; start at 1    */
    public native @Cast("l_int32") int refcount(); public native CCBORD refcount(int setter);
    /** ptaa of chain pixels (local)     */
    public native PTAA local(); public native CCBORD local(PTAA setter);
    /** ptaa of chain pixels (global)    */
    public native PTAA global(); public native CCBORD global(PTAA setter);
    /** numaa of chain code (step dir)   */
    public native NUMAA step(); public native CCBORD step(NUMAA setter);
    /** pta of single chain (local)      */
    public native PTA splocal(); public native CCBORD splocal(PTA setter);
    /** pta of single chain (global)     */
    public native PTA spglobal(); public native CCBORD spglobal(PTA setter);
}
