/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Raw;
import org.bytedeco.javacpp.indexer.UIntIndexer;

public class UIntRawIndexer
extends UIntIndexer {
    protected static final Raw RAW = Raw.getInstance();
    protected IntPointer pointer;
    final long base;
    final long size;

    public UIntRawIndexer(IntPointer pointer) {
        this(pointer, new long[]{pointer.limit() - pointer.position()}, ONE_STRIDE);
    }

    public UIntRawIndexer(IntPointer pointer, long ... sizes) {
        this(pointer, sizes, UIntRawIndexer.strides(sizes));
    }

    public UIntRawIndexer(IntPointer pointer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.pointer = pointer;
        this.base = pointer.address() + pointer.position() * 4L;
        this.size = pointer.limit() - pointer.position();
    }

    @Override
    public Pointer pointer() {
        return this.pointer;
    }

    @Override
    public long get(long i) {
        return (long)RAW.getInt(this.base + UIntRawIndexer.checkIndex(i, this.size) * 4L) & 0xFFFFFFFFL;
    }

    @Override
    public UIntIndexer get(long i, long[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.get(i * this.strides[0] + (long)n) & 0xFFFFFFFFL;
        }
        return this;
    }

    @Override
    public long get(long i, long j) {
        return this.get(i * this.strides[0] + j) & 0xFFFFFFFFL;
    }

    @Override
    public UIntIndexer get(long i, long j, long[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.get(i * this.strides[0] + j * this.strides[1] + (long)n) & 0xFFFFFFFFL;
        }
        return this;
    }

    @Override
    public long get(long i, long j, long k) {
        return this.get(i * this.strides[0] + j * this.strides[1] + k) & 0xFFFFFFFFL;
    }

    @Override
    public long get(long ... indices) {
        return this.get(this.index(indices)) & 0xFFFFFFFFL;
    }

    @Override
    public UIntIndexer get(long[] indices, long[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            m[offset + n] = this.get(this.index(indices) + (long)n) & 0xFFFFFFFFL;
        }
        return this;
    }

    @Override
    public UIntIndexer put(long i, long n) {
        RAW.putInt(this.base + UIntRawIndexer.checkIndex(i, this.size) * 4L, (int)n);
        return this;
    }

    @Override
    public UIntIndexer put(long i, long[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + (long)n, (long)((int)m[offset + n]));
        }
        return this;
    }

    @Override
    public UIntIndexer put(long i, long j, long n) {
        this.put(i * this.strides[0] + j, (long)((int)n));
        return this;
    }

    @Override
    public UIntIndexer put(long i, long j, long[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(i * this.strides[0] + j * this.strides[1] + (long)n, (long)((int)m[offset + n]));
        }
        return this;
    }

    @Override
    public UIntIndexer put(long i, long j, long k, long n) {
        this.put(i * this.strides[0] + j * this.strides[1] + k, (long)((int)n));
        return this;
    }

    @Override
    public UIntIndexer put(long[] indices, long n) {
        this.put(this.index(indices), (long)((int)n));
        return this;
    }

    @Override
    public UIntIndexer put(long[] indices, long[] m, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.put(this.index(indices) + (long)n, (long)((int)m[offset + n]));
        }
        return this;
    }

    @Override
    public void release() {
        this.pointer = null;
    }
}

