/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.bytedeco.javacpp.tools.Builder;
import org.bytedeco.javacpp.tools.Logger;
import org.bytedeco.javacpp.tools.UserClassLoader;

class ClassScanner {
    final Logger logger;
    final Collection<Class> classes;
    final UserClassLoader loader;

    ClassScanner(Logger logger, Collection<Class> classes, UserClassLoader loader) {
        this.logger = logger;
        this.classes = classes;
        this.loader = loader;
    }

    public Collection<Class> getClasses() {
        return this.classes;
    }

    public UserClassLoader getClassLoader() {
        return this.loader;
    }

    public void addClass(String className) throws ClassNotFoundException, NoClassDefFoundError {
        if (className == null) {
            return;
        }
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - 6);
        }
        Class<?> c = Class.forName(className, false, this.loader);
        this.addClass(c);
    }

    public void addClass(Class c) {
        if (!this.classes.contains(c)) {
            this.classes.add(c);
        }
    }

    public void addMatchingFile(String filename, String packagePath, boolean recursive) throws ClassNotFoundException, NoClassDefFoundError {
        if (filename != null && filename.endsWith(".class") && (packagePath == null || recursive && filename.startsWith(packagePath) || filename.regionMatches(0, packagePath, 0, Math.max(filename.lastIndexOf(47), packagePath.lastIndexOf(47))))) {
            this.addClass(filename.replace('/', '.'));
        }
    }

    public void addMatchingDir(String parentName, File dir, String packagePath, boolean recursive) throws ClassNotFoundException, NoClassDefFoundError {
        Object[] files = dir.listFiles();
        Arrays.sort(files);
        for (Object f : files) {
            String pathName;
            String string = pathName = parentName == null ? ((File)f).getName() : parentName + ((File)f).getName();
            if (((File)f).isDirectory()) {
                this.addMatchingDir(pathName + "/", (File)f, packagePath, recursive);
                continue;
            }
            this.addMatchingFile(pathName, packagePath, recursive);
        }
    }

    public void addPackage(String packageName, boolean recursive) throws IOException, ClassNotFoundException, NoClassDefFoundError {
        String[] paths = this.loader.getPaths();
        String packagePath = packageName == null ? null : packageName.replace('.', '/') + "/";
        int prevSize = this.classes.size();
        for (String p : paths) {
            File file = new File(p);
            if (file.isDirectory()) {
                this.addMatchingDir(null, file, packagePath, recursive);
                continue;
            }
            JarInputStream jis = new JarInputStream(new FileInputStream(file));
            ZipEntry e = jis.getNextEntry();
            while (e != null) {
                this.addMatchingFile(e.getName(), packagePath, recursive);
                jis.closeEntry();
                e = jis.getNextEntry();
            }
            jis.close();
        }
        if (this.classes.size() == 0 && packageName == null) {
            this.logger.warn("No classes found in the unnamed package");
            Builder.printHelp();
        } else if (prevSize == this.classes.size() && packageName != null) {
            this.logger.warn("No classes found in package " + packageName);
        }
    }

    public void addClassOrPackage(String name) throws IOException, ClassNotFoundException, NoClassDefFoundError {
        if (name == null) {
            return;
        }
        if ((name = name.replace('/', '.')).endsWith(".**")) {
            this.addPackage(name.substring(0, name.length() - 3), true);
        } else if (name.endsWith(".*")) {
            this.addPackage(name.substring(0, name.length() - 2), false);
        } else {
            this.addClass(name);
        }
    }
}

