/*
 * Decompiled with CFR 0.152.
 */
package org.buildobjects.process;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.buildobjects.process.ExternalProcessFailureException;
import org.buildobjects.process.Helper;
import org.buildobjects.process.Proc;
import org.buildobjects.process.ProcResult;
import org.buildobjects.process.StartupException;
import org.buildobjects.process.StreamConsumer;
import org.buildobjects.process.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcBuilder {
    private ByteArrayOutputStream defaultStdout = new ByteArrayOutputStream();
    private String command;
    private List<String> args = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private OutputStream stdout = this.defaultStdout;
    private InputStream stdin;
    private OutputStream stderr;
    private Long timoutMillis = 5000L;
    private Set<Integer> expectedExitStatuses = new HashSet<Integer>(){
        {
            this.add(0);
        }
    };
    private File directory;
    private StreamConsumer outputConsumer;

    public ProcBuilder(String command, String ... args) {
        this.command = command;
        this.withArgs(args);
    }

    public ProcBuilder withArg(String arg) {
        this.args.add(arg);
        return this;
    }

    public ProcBuilder withOutputStream(OutputStream stdout) {
        this.stdout = stdout;
        return this;
    }

    public ProcBuilder withErrorStream(OutputStream stderr) {
        this.stderr = stderr;
        return this;
    }

    public ProcBuilder withTimeoutMillis(long timeoutMillis) {
        this.timoutMillis = timeoutMillis;
        return this;
    }

    public ProcBuilder withNoTimeout() {
        this.timoutMillis = null;
        return this;
    }

    public ProcBuilder withInputStream(InputStream stdin) {
        this.stdin = stdin;
        return this;
    }

    public ProcBuilder withInput(String input) {
        this.stdin = new ByteArrayInputStream(input.getBytes());
        return this;
    }

    public ProcBuilder withInput(byte[] input) {
        this.stdin = new ByteArrayInputStream(input);
        return this;
    }

    public ProcBuilder withWorkingDirectory(File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("File '" + directory.getPath() + "' is not a directory.");
        }
        this.directory = directory;
        return this;
    }

    public ProcBuilder withArgs(String ... args) {
        this.args.addAll(Arrays.asList(args));
        return this;
    }

    public ProcBuilder withExitStatuses(int[] exitstatuses) {
        this.expectedExitStatuses = Helper.asSet(exitstatuses);
        return this;
    }

    public ProcBuilder withExpectedExitStatuses(Set<Integer> expectedExitStatuses) {
        this.expectedExitStatuses = expectedExitStatuses;
        return this;
    }

    public ProcBuilder withExpectedExitStatuses(int ... expectedExitStatuses) {
        this.expectedExitStatuses = Helper.asSet(expectedExitStatuses);
        return this;
    }

    public ProcBuilder ignoreExitStatus() {
        this.expectedExitStatuses = Collections.emptySet();
        return this;
    }

    public ProcResult run() throws StartupException, TimeoutException, ExternalProcessFailureException {
        if (this.stdout != this.defaultStdout && this.outputConsumer != null) {
            throw new IllegalArgumentException("You can either ...");
        }
        try {
            Proc proc = new Proc(this.command, this.args, this.env, this.stdin, this.outputConsumer != null ? this.outputConsumer : this.stdout, this.directory, this.timoutMillis, this.expectedExitStatuses, this.stderr);
            ProcResult procResult = new ProcResult(proc.toString(), this.defaultStdout == this.stdout && this.outputConsumer == null ? this.defaultStdout : null, proc.getExitValue(), proc.getExecutionTime(), proc.getErrorBytes());
            return procResult;
        }
        finally {
            this.defaultStdout = new ByteArrayOutputStream();
            this.stdout = this.defaultStdout;
            this.stdin = null;
        }
    }

    public static String run(String cmd, String ... args) {
        ProcBuilder builder = new ProcBuilder(cmd, new String[0]).withArgs(args);
        return builder.run().getOutputString();
    }

    public static String filter(String input, String cmd, String ... args) {
        ProcBuilder builder = new ProcBuilder(cmd, new String[0]).withArgs(args).withInput(input);
        return builder.run().getOutputString();
    }

    public ProcBuilder withVar(String var, String value) {
        this.env.put(var, value);
        return this;
    }

    public ProcBuilder withOutputConsumer(StreamConsumer outputConsumer) {
        this.outputConsumer = outputConsumer;
        return this;
    }
}

