/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.langchain4j.tool;

import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.service.tool.DefaultToolExecutor;
import dev.langchain4j.service.tool.ToolExecutor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolNode {
    private static final Logger log = LoggerFactory.getLogger(ToolNode.class);
    private final List<Specification> entries;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static ToolNode of(Collection<Object> objectsWithToolsOrSpecification) {
        Builder builder = ToolNode.builder();
        for (Object objectWithToolOrSpecification : objectsWithToolsOrSpecification) {
            if (objectWithToolOrSpecification instanceof Specification) {
                builder.specification((Specification)objectWithToolOrSpecification);
                continue;
            }
            for (Method method : objectWithToolOrSpecification.getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Tool.class)) continue;
                DefaultToolExecutor toolExecutor = new DefaultToolExecutor(objectWithToolOrSpecification, method);
                builder.specification(Specification.of(ToolSpecifications.toolSpecificationFrom((Method)method), (ToolExecutor)toolExecutor));
            }
        }
        return builder.build();
    }

    @Deprecated
    public static ToolNode of(Object ... objectsWithToolsOrSpecification) {
        return ToolNode.of(Arrays.asList(objectsWithToolsOrSpecification));
    }

    private ToolNode(@NonNull List<Specification> entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        if (entries.isEmpty()) {
            throw new IllegalArgumentException("entries cannot be empty!");
        }
        this.entries = entries;
    }

    public List<ToolSpecification> toolSpecifications() {
        return this.entries.stream().map(Specification::value).collect(Collectors.toList());
    }

    public Optional<ToolExecutionResultMessage> execute(@NonNull ToolExecutionRequest request, Object memoryId) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        log.trace("execute: {}", (Object)request.name());
        return this.entries.stream().filter(v -> v.value().name().equals(request.name())).findFirst().map(e -> {
            String value = e.executor().execute(request, memoryId);
            return new ToolExecutionResultMessage(request.id(), request.name(), value);
        });
    }

    public Optional<ToolExecutionResultMessage> execute(@NonNull Collection<ToolExecutionRequest> requests, Object memoryId) {
        if (requests == null) {
            throw new NullPointerException("requests is marked non-null but is null");
        }
        for (ToolExecutionRequest request : requests) {
            Optional<ToolExecutionResultMessage> result = this.execute(request, memoryId);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public Optional<ToolExecutionResultMessage> execute(ToolExecutionRequest request) {
        return this.execute(request, null);
    }

    public Optional<ToolExecutionResultMessage> execute(Collection<ToolExecutionRequest> requests) {
        return this.execute(requests, null);
    }

    public static class Builder {
        private final List<Specification> toolSpecifications = new ArrayList<Specification>();

        public Builder specification(ToolSpecification spec, ToolExecutor executor) {
            return this.specification(Specification.of(spec, executor));
        }

        public Builder specification(Specification toolSpecifications) {
            this.toolSpecifications.add(toolSpecifications);
            return this;
        }

        public Builder specification(Object objectWithTool) {
            for (Method method : objectWithTool.getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Tool.class)) continue;
                DefaultToolExecutor toolExecutor = new DefaultToolExecutor(objectWithTool, method);
                this.toolSpecifications.add(new Specification(ToolSpecifications.toolSpecificationFrom((Method)method), (ToolExecutor)toolExecutor));
            }
            return this;
        }

        public ToolNode build() {
            return new ToolNode(this.toolSpecifications);
        }
    }

    public record Specification(ToolSpecification value, ToolExecutor executor) {
        public static Specification of(@NonNull ToolSpecification value, @NonNull ToolExecutor executor) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (executor == null) {
                throw new NullPointerException("executor is marked non-null but is null");
            }
            return new Specification(value, executor);
        }
    }
}

