/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agentexecutor;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class Agent {
    private final ChatLanguageModel chatLanguageModel;
    private final StreamingChatLanguageModel streamingChatLanguageModel;
    private final List<ToolSpecification> tools;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isStreaming() {
        return this.streamingChatLanguageModel != null;
    }

    protected Agent(ChatLanguageModel chatLanguageModel, StreamingChatLanguageModel streaming, List<ToolSpecification> tools) {
        this.chatLanguageModel = chatLanguageModel;
        this.streamingChatLanguageModel = streaming;
        this.tools = tools;
    }

    private ChatRequest prepareRequest(List<ChatMessage> messages) {
        ArrayList<ChatMessage> reqMessages = new ArrayList<ChatMessage>(messages);
        reqMessages.add((ChatMessage)SystemMessage.from((String)"You are a helpful assistant"));
        ChatRequestParameters parameters = ChatRequestParameters.builder().toolSpecifications(this.tools).build();
        return ChatRequest.builder().messages(reqMessages).parameters(parameters).build();
    }

    public void execute(List<ChatMessage> messages, StreamingChatResponseHandler handler) {
        Objects.requireNonNull(this.streamingChatLanguageModel, "streamingChatLanguageModel is required!");
        this.streamingChatLanguageModel.chat(this.prepareRequest(messages), handler);
    }

    public ChatResponse execute(List<ChatMessage> messages) {
        Objects.requireNonNull(this.chatLanguageModel, "chatLanguageModel is required!");
        return this.chatLanguageModel.chat(this.prepareRequest(messages));
    }

    public static class Builder {
        private ChatLanguageModel chatLanguageModel;
        private StreamingChatLanguageModel streamingChatLanguageModel;
        private List<ToolSpecification> tools = new ArrayList<ToolSpecification>();

        public Builder chatLanguageModel(ChatLanguageModel chatLanguageModel) {
            this.chatLanguageModel = chatLanguageModel;
            return this;
        }

        public Builder streamingChatLanguageModel(StreamingChatLanguageModel streamingChatLanguageModel) {
            this.streamingChatLanguageModel = streamingChatLanguageModel;
            return this;
        }

        public Builder tool(ToolSpecification toolSpecification) {
            this.tools.add(toolSpecification);
            return this;
        }

        public Builder tools(Collection<? extends ToolSpecification> toolSpecifications) {
            this.tools.addAll(toolSpecifications);
            return this;
        }

        public Agent build() {
            return new Agent(this.chatLanguageModel, this.streamingChatLanguageModel, this.tools);
        }
    }
}

