/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agentexecutor.actions;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.bsc.langgraph4j.action.NodeAction;
import org.bsc.langgraph4j.agentexecutor.Agent;
import org.bsc.langgraph4j.agentexecutor.AgentExecutor;
import org.bsc.langgraph4j.langchain4j.tool.ToolNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteTools
implements NodeAction<AgentExecutor.State> {
    private static final Logger log = LoggerFactory.getLogger(ExecuteTools.class);
    final Agent agent;
    final ToolNode toolNode;

    public ExecuteTools(@NonNull Agent agent, @NonNull ToolNode toolNode) {
        if (agent == null) {
            throw new NullPointerException("agent is marked non-null but is null");
        }
        if (toolNode == null) {
            throw new NullPointerException("toolNode is marked non-null but is null");
        }
        this.agent = agent;
        this.toolNode = toolNode;
    }

    public Map<String, Object> apply(AgentExecutor.State state) {
        log.trace("executeTools");
        List toolExecutionRequests = state.lastMessage().filter(m -> ChatMessageType.AI == m.type()).map(m -> (AiMessage)m).filter(AiMessage::hasToolExecutionRequests).map(AiMessage::toolExecutionRequests).orElseThrow(() -> new IllegalArgumentException("no tool execution request found!"));
        List<ToolExecutionResultMessage> result = toolExecutionRequests.stream().map(arg_0 -> ((ToolNode)this.toolNode).execute(arg_0)).filter(Optional::isPresent).map(Optional::get).toList();
        return Map.of("messages", result);
    }
}

