/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agentexecutor;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bsc.langgraph4j.GraphStateException;
import org.bsc.langgraph4j.StateGraph;
import org.bsc.langgraph4j.action.AsyncEdgeAction;
import org.bsc.langgraph4j.action.AsyncNodeAction;
import org.bsc.langgraph4j.action.EdgeAction;
import org.bsc.langgraph4j.action.NodeAction;
import org.bsc.langgraph4j.agentexecutor.Agent;
import org.bsc.langgraph4j.agentexecutor.actions.CallAgent;
import org.bsc.langgraph4j.agentexecutor.actions.ExecuteTools;
import org.bsc.langgraph4j.agentexecutor.serializer.jackson.JSONStateSerializer;
import org.bsc.langgraph4j.agentexecutor.serializer.std.STDStateSerializer;
import org.bsc.langgraph4j.langchain4j.tool.ToolNode;
import org.bsc.langgraph4j.prebuilt.MessagesState;
import org.bsc.langgraph4j.serializer.StateSerializer;

public interface AgentExecutor {
    public static GraphBuilder graphBuilder() {
        return new GraphBuilder();
    }

    public static class GraphBuilder {
        private StreamingChatLanguageModel streamingChatLanguageModel;
        private ChatLanguageModel chatLanguageModel;
        private final ToolNode.Builder toolNodeBuilder = ToolNode.builder();
        private StateSerializer<State> stateSerializer;

        public GraphBuilder chatLanguageModel(ChatLanguageModel chatLanguageModel) {
            this.chatLanguageModel = chatLanguageModel;
            return this;
        }

        public GraphBuilder chatLanguageModel(StreamingChatLanguageModel streamingChatLanguageModel) {
            this.streamingChatLanguageModel = streamingChatLanguageModel;
            return this;
        }

        @Deprecated
        public GraphBuilder objectsWithTools(List<Object> objectsWithTools) {
            objectsWithTools.forEach(arg_0 -> ((ToolNode.Builder)this.toolNodeBuilder).specification(arg_0));
            return this;
        }

        public GraphBuilder toolSpecification(Object objectsWithTool) {
            this.toolNodeBuilder.specification(objectsWithTool);
            return this;
        }

        public GraphBuilder toolSpecification(ToolSpecification spec, ToolExecutor executor) {
            this.toolNodeBuilder.specification(spec, executor);
            return this;
        }

        public GraphBuilder toolSpecification(ToolNode.Specification toolSpecifications) {
            this.toolNodeBuilder.specification(toolSpecifications);
            return this;
        }

        public GraphBuilder stateSerializer(StateSerializer<State> stateSerializer) {
            this.stateSerializer = stateSerializer;
            return this;
        }

        public StateGraph<State> build() throws GraphStateException {
            if (this.streamingChatLanguageModel != null && this.chatLanguageModel != null) {
                throw new IllegalArgumentException("chatLanguageModel and streamingChatLanguageModel are mutually exclusive!");
            }
            if (this.streamingChatLanguageModel == null && this.chatLanguageModel == null) {
                throw new IllegalArgumentException("a chatLanguageModel or streamingChatLanguageModel is required!");
            }
            ToolNode toolNode = this.toolNodeBuilder.build();
            Agent agent = Agent.builder().chatLanguageModel(this.chatLanguageModel).streamingChatLanguageModel(this.streamingChatLanguageModel).tools(toolNode.toolSpecifications()).build();
            if (this.stateSerializer == null) {
                this.stateSerializer = Serializers.STD.object();
            }
            CallAgent callAgent = new CallAgent(agent);
            ExecuteTools executeTools = new ExecuteTools(agent, toolNode);
            EdgeAction shouldContinue = state -> state.finalResponse().map(res -> "end").orElse("continue");
            return new StateGraph(State.SCHEMA, this.stateSerializer).addNode("agent", AsyncNodeAction.node_async((NodeAction)callAgent)).addNode("action", AsyncNodeAction.node_async((NodeAction)executeTools)).addEdge(StateGraph.START, "agent").addConditionalEdges("agent", AsyncEdgeAction.edge_async((EdgeAction)shouldContinue), Map.of("continue", "action", "end", StateGraph.END)).addEdge("action", "agent");
        }
    }

    public static enum Serializers {
        STD((StateSerializer<State>)new STDStateSerializer()),
        JSON((StateSerializer<State>)new JSONStateSerializer());

        private final StateSerializer<State> serializer;

        private Serializers(StateSerializer<State> serializer) {
            this.serializer = serializer;
        }

        public StateSerializer<State> object() {
            return this.serializer;
        }
    }

    public static class State
    extends MessagesState<ChatMessage> {
        public State(Map<String, Object> initData) {
            super(initData);
        }

        public Optional<String> finalResponse() {
            return this.value("agent_response");
        }
    }
}

