/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.agentexecutor;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Agent {
    private final ChatLanguageModel chatLanguageModel;
    private final StreamingChatLanguageModel streamingChatLanguageModel;
    private final List<ToolSpecification> tools;

    public boolean isStreaming() {
        return this.streamingChatLanguageModel != null;
    }

    private ChatRequest prepareRequest(List<ChatMessage> messages) {
        ArrayList<ChatMessage> reqMessages = new ArrayList<ChatMessage>(messages);
        reqMessages.add((ChatMessage)SystemMessage.from((String)"You are a helpful assistant"));
        ChatRequestParameters parameters = ChatRequestParameters.builder().toolSpecifications(this.tools).build();
        return ChatRequest.builder().messages(reqMessages).parameters(parameters).build();
    }

    public void execute(List<ChatMessage> messages, StreamingChatResponseHandler handler) {
        Objects.requireNonNull(this.streamingChatLanguageModel, "streamingChatLanguageModel is required!");
        this.streamingChatLanguageModel.chat(this.prepareRequest(messages), handler);
    }

    public ChatResponse execute(List<ChatMessage> messages) {
        Objects.requireNonNull(this.chatLanguageModel, "chatLanguageModel is required!");
        return this.chatLanguageModel.chat(this.prepareRequest(messages));
    }

    Agent(ChatLanguageModel chatLanguageModel, StreamingChatLanguageModel streamingChatLanguageModel, List<ToolSpecification> tools) {
        this.chatLanguageModel = chatLanguageModel;
        this.streamingChatLanguageModel = streamingChatLanguageModel;
        this.tools = tools;
    }

    public static AgentBuilder builder() {
        return new AgentBuilder();
    }

    public static class AgentBuilder {
        private ChatLanguageModel chatLanguageModel;
        private StreamingChatLanguageModel streamingChatLanguageModel;
        private ArrayList<ToolSpecification> tools;

        AgentBuilder() {
        }

        public AgentBuilder chatLanguageModel(ChatLanguageModel chatLanguageModel) {
            this.chatLanguageModel = chatLanguageModel;
            return this;
        }

        public AgentBuilder streamingChatLanguageModel(StreamingChatLanguageModel streamingChatLanguageModel) {
            this.streamingChatLanguageModel = streamingChatLanguageModel;
            return this;
        }

        public AgentBuilder tool(ToolSpecification tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        public AgentBuilder tools(Collection<? extends ToolSpecification> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        public AgentBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        public Agent build() {
            return new Agent(this.chatLanguageModel, this.streamingChatLanguageModel, switch (this.tools == null ? 0 : this.tools.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.tools.get(0));
                default -> Collections.unmodifiableList(new ArrayList<ToolSpecification>(this.tools));
            });
        }

        public String toString() {
            return "Agent.AgentBuilder(chatLanguageModel=" + String.valueOf(this.chatLanguageModel) + ", streamingChatLanguageModel=" + String.valueOf(this.streamingChatLanguageModel) + ", tools=" + String.valueOf(this.tools) + ")";
        }
    }
}

