/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.util.Arrays;

public class BcDefaultTlsCredentialedDecryptor
implements TlsCredentialedDecryptor {
    protected BcTlsCrypto crypto;
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;

    public BcDefaultTlsCredentialedDecryptor(BcTlsCrypto crypto, Certificate certificate, AsymmetricKeyParameter privateKey) {
        if (crypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (!(privateKey instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        this.crypto = crypto;
        this.certificate = certificate;
        this.privateKey = privateKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TlsSecret decrypt(TlsCryptoParameters cryptoParams, byte[] ciphertext) throws IOException {
        return this.safeDecryptPreMasterSecret(cryptoParams, (RSAKeyParameters)this.privateKey, ciphertext);
    }

    protected TlsSecret safeDecryptPreMasterSecret(TlsCryptoParameters cryptoParams, RSAKeyParameters rsaServerPrivateKey, byte[] encryptedPreMasterSecret) {
        SecureRandom secureRandom = this.crypto.getSecureRandom();
        ProtocolVersion expectedVersion = cryptoParams.getRSAPreMasterSecretVersion();
        boolean versionNumberCheckDisabled = false;
        byte[] fallback = new byte[48];
        secureRandom.nextBytes(fallback);
        byte[] M = Arrays.clone((byte[])fallback);
        try {
            PKCS1Encoding encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine(), fallback);
            encoding.init(false, (CipherParameters)new ParametersWithRandom((CipherParameters)rsaServerPrivateKey, secureRandom));
            M = encoding.processBlock(encryptedPreMasterSecret, 0, encryptedPreMasterSecret.length);
        }
        catch (Exception encoding) {
            // empty catch block
        }
        if (!versionNumberCheckDisabled || TlsImplUtils.isTLSv11(expectedVersion)) {
            int mask = expectedVersion.getMajorVersion() ^ M[0] & 0xFF | expectedVersion.getMinorVersion() ^ M[1] & 0xFF;
            mask = mask - 1 >> 31;
            for (int i = 0; i < 48; ++i) {
                M[i] = (byte)(M[i] & mask | fallback[i] & ~mask);
            }
        }
        return this.crypto.createSecret(M);
    }
}

