/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import org.bouncycastle.util.Arrays;

final class BcTlsAEADCipherImpl
implements TlsAEADCipherImpl {
    private final boolean isEncrypting;
    private final AEADBlockCipher cipher;
    private KeyParameter key;

    BcTlsAEADCipherImpl(AEADBlockCipher aEADBlockCipher, boolean bl) {
        this.cipher = aEADBlockCipher;
        this.isEncrypting = bl;
    }

    public void setKey(byte[] byArray, int n, int n2) {
        this.key = new KeyParameter(byArray, n, n2);
    }

    public void init(byte[] byArray, int n) {
        this.cipher.init(this.isEncrypting, (CipherParameters)new AEADParameters(this.key, n * 8, byArray, null));
    }

    public int getOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }

    public int doFinal(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) throws IOException {
        if (!Arrays.isNullOrEmpty((byte[])byArray)) {
            this.cipher.processAADBytes(byArray, 0, byArray.length);
        }
        int n4 = this.cipher.processBytes(byArray2, n, n2, byArray3, n3);
        try {
            n4 += this.cipher.doFinal(byArray3, n3 + n4);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new TlsFatalAlert(20, (Throwable)invalidCipherTextException);
        }
        return n4;
    }
}

