/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.AbstractTlsServer;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPSKIdentityManager;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;

public class PSKTlsServer
extends AbstractTlsServer {
    private static final int[] DEFAULT_CIPHER_SUITES = new int[]{52396, 49208, 49207, 49206, 49205, 52397, 171, 170, 179, 178, 145, 144};
    protected TlsPSKIdentityManager pskIdentityManager;

    public PSKTlsServer(TlsCrypto tlsCrypto, TlsPSKIdentityManager tlsPSKIdentityManager) {
        super(tlsCrypto);
        this.pskIdentityManager = tlsPSKIdentityManager;
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.only();
    }

    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), DEFAULT_CIPHER_SUITES);
    }

    public TlsCredentials getCredentials() throws IOException {
        int n = this.context.getSecurityParametersHandshake().getKeyExchangeAlgorithm();
        switch (n) {
            case 13: 
            case 14: 
            case 24: {
                return null;
            }
            case 15: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsPSKIdentityManager getPSKIdentityManager() {
        return this.pskIdentityManager;
    }
}

