/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class JceTlsSecret
extends AbstractTlsSecret {
    protected final JcaTlsCrypto crypto;

    public JceTlsSecret(JcaTlsCrypto jcaTlsCrypto, byte[] byArray) {
        super(byArray);
        this.crypto = jcaTlsCrypto;
    }

    public synchronized TlsSecret deriveUsingPRF(int n, String string, byte[] byArray, int n2) {
        this.checkAlive();
        byte[] byArray2 = Arrays.concatenate((byte[])Strings.toByteArray((String)string), (byte[])byArray);
        try {
            byte[] byArray3 = n == 0 ? this.prf_1_0(this.data, byArray2, n2) : this.prf_1_2(n, this.data, byArray2, n2);
            return this.crypto.adoptLocalSecret(byArray3);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalStateException();
        }
    }

    protected TlsSecret adoptLocalSecret(byte[] byArray) {
        return this.crypto.adoptLocalSecret(byArray);
    }

    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    protected void hmacHash(String string, byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3) throws GeneralSecurityException {
        String string2 = "Hmac" + string;
        Mac mac = this.crypto.getHelper().createMac(string2);
        mac.init(new SecretKeySpec(byArray, n, n2, string2));
        byte[] byArray4 = byArray2;
        int n3 = mac.getMacLength();
        byte[] byArray5 = new byte[n3];
        byte[] byArray6 = new byte[n3];
        for (int i = 0; i < byArray3.length; i += n3) {
            mac.update(byArray4, 0, byArray4.length);
            mac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            mac.update(byArray4, 0, byArray4.length);
            mac.update(byArray2, 0, byArray2.length);
            mac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, i, Math.min(n3, byArray3.length - i));
        }
    }

    protected byte[] prf_1_0(byte[] byArray, byte[] byArray2, int n) throws GeneralSecurityException {
        int n2 = (byArray.length + 1) / 2;
        byte[] byArray3 = new byte[n];
        this.hmacHash("MD5", byArray, 0, n2, byArray2, byArray3);
        byte[] byArray4 = new byte[n];
        this.hmacHash("SHA1", byArray, byArray.length - n2, n2, byArray2, byArray4);
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            byArray3[n3] = (byte)(byArray3[n3] ^ byArray4[i]);
        }
        return byArray3;
    }

    protected byte[] prf_1_2(int n, byte[] byArray, byte[] byArray2, int n2) throws GeneralSecurityException {
        String string = this.crypto.getDigestName(TlsUtils.getHashAlgorithmForPRFAlgorithm(n)).replaceAll("-", "");
        byte[] byArray3 = new byte[n2];
        this.hmacHash(string, byArray, 0, byArray.length, byArray2, byArray3);
        return byArray3;
    }
}

