/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;

public class TlsImplUtils {
    public static boolean isTLSv11(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv11.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static boolean isTLSv11(TlsCryptoParameters tlsCryptoParameters) {
        return TlsImplUtils.isTLSv11(tlsCryptoParameters.getServerVersion());
    }

    public static boolean isTLSv12(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv12.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static boolean isTLSv12(TlsCryptoParameters tlsCryptoParameters) {
        return TlsImplUtils.isTLSv12(tlsCryptoParameters.getServerVersion());
    }

    public static boolean isTLSv13(ProtocolVersion protocolVersion) {
        return ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion.getEquivalentTLSVersion());
    }

    public static boolean isTLSv13(TlsCryptoParameters tlsCryptoParameters) {
        return TlsImplUtils.isTLSv13(tlsCryptoParameters.getServerVersion());
    }

    public static byte[] calculateKeyBlock(TlsCryptoParameters tlsCryptoParameters, int n) {
        SecurityParameters securityParameters = tlsCryptoParameters.getSecurityParametersHandshake();
        TlsSecret tlsSecret = securityParameters.getMasterSecret();
        byte[] byArray = Arrays.concatenate((byte[])securityParameters.getServerRandom(), (byte[])securityParameters.getClientRandom());
        return TlsImplUtils.PRF(tlsCryptoParameters, tlsSecret, "key expansion", byArray, n).extract();
    }

    public static TlsSecret PRF(TlsCryptoParameters tlsCryptoParameters, TlsSecret tlsSecret, String string, byte[] byArray, int n) {
        int n2 = tlsCryptoParameters.getSecurityParametersHandshake().getPrfAlgorithm();
        return tlsSecret.deriveUsingPRF(n2, string, byArray, n);
    }
}

