/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.AbstractTlsContext;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.HandshakeMessageInput;
import org.bouncycastle.tls.HandshakeMessageOutput;
import org.bouncycastle.tls.KeyShareEntry;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerHello;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsClient;
import org.bouncycastle.tls.TlsClientContextImpl;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class TlsClientProtocol
extends TlsProtocol {
    protected TlsClient tlsClient = null;
    TlsClientContextImpl tlsClientContext = null;
    protected Hashtable clientAgreements = null;
    protected ClientHello clientHello = null;
    protected TlsKeyExchange keyExchange = null;
    protected TlsAuthentication authentication = null;
    protected CertificateStatus certificateStatus = null;
    protected CertificateRequest certificateRequest = null;

    public TlsClientProtocol() {
    }

    public TlsClientProtocol(InputStream inputStream, OutputStream outputStream) {
        super(inputStream, outputStream);
    }

    public void connect(TlsClient tlsClient) throws IOException {
        if (tlsClient == null) {
            throw new IllegalArgumentException("'tlsClient' cannot be null");
        }
        if (this.tlsClient != null) {
            throw new IllegalStateException("'connect' can only be called once");
        }
        this.tlsClient = tlsClient;
        this.tlsClientContext = new TlsClientContextImpl(tlsClient.getCrypto());
        tlsClient.init(this.tlsClientContext);
        this.recordStream.init(this.tlsClientContext);
        tlsClient.notifyCloseHandle(this);
        this.beginHandshake();
        if (this.blocking) {
            this.blockForHandshake();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beginHandshake() throws IOException {
        SessionParameters sessionParameters;
        super.beginHandshake();
        TlsSession tlsSession = this.tlsClient.getSessionToResume();
        if (tlsSession != null && tlsSession.isResumable() && (sessionParameters = tlsSession.exportSessionParameters()) != null && (sessionParameters.isExtendedMasterSecret() || !this.tlsClient.requiresExtendedMasterSecret() && this.tlsClient.allowLegacyResumption())) {
            TlsSecret tlsSecret;
            TlsSecret tlsSecret2 = tlsSecret = sessionParameters.getMasterSecret();
            synchronized (tlsSecret2) {
                if (tlsSecret.isAlive()) {
                    this.tlsSession = tlsSession;
                    this.sessionParameters = sessionParameters;
                    this.sessionMasterSecret = this.tlsClientContext.getCrypto().adoptSecret(tlsSecret);
                }
            }
        }
        this.sendClientHello();
        this.connection_state = 1;
    }

    @Override
    protected void cleanupHandshake() {
        super.cleanupHandshake();
        this.clientAgreements = null;
        this.clientHello = null;
        this.keyExchange = null;
        this.authentication = null;
        this.certificateStatus = null;
        this.certificateRequest = null;
    }

    @Override
    protected TlsContext getContext() {
        return this.tlsClientContext;
    }

    @Override
    AbstractTlsContext getContextAdmin() {
        return this.tlsClientContext;
    }

    @Override
    protected TlsPeer getPeer() {
        return this.tlsClient;
    }

    protected void handle13HandshakeMessage(short s, HandshakeMessageInput handshakeMessageInput) throws IOException {
        if (!this.isTLSv13ConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        if (this.resumedSession) {
            throw new TlsFatalAlert(80);
        }
        block0 : switch (s) {
            case 11: {
                switch (this.connection_state) {
                    case 5: {
                        this.skip13CertificateRequest();
                    }
                    case 11: {
                        this.receive13ServerCertificate(handshakeMessageInput);
                        this.connection_state = (short)7;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 13: {
                switch (this.connection_state) {
                    case 21: {
                        throw new TlsFatalAlert(10);
                    }
                    case 5: {
                        this.receive13CertificateRequest(handshakeMessageInput, false);
                        this.connection_state = (short)11;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 15: {
                switch (this.connection_state) {
                    case 7: {
                        this.receive13ServerCertificateVerify(handshakeMessageInput);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)9;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 8: {
                switch (this.connection_state) {
                    case 4: {
                        this.receive13EncryptedExtensions(handshakeMessageInput);
                        this.connection_state = (short)5;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 5: {
                        this.skip13CertificateRequest();
                    }
                    case 11: {
                        this.skip13ServerCertificate();
                    }
                    case 9: {
                        this.receive13ServerFinished(handshakeMessageInput);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)20;
                        byte[] byArray = TlsUtils.getCurrentPRFHash(this.handshakeHash);
                        this.recordStream.setIgnoreChangeCipherSpec(false);
                        if (null != this.certificateRequest) {
                            TlsCredentialedSigner tlsCredentialedSigner = TlsUtils.establish13ClientCredentials(this.authentication, this.certificateRequest);
                            Certificate certificate = null;
                            if (null != tlsCredentialedSigner) {
                                certificate = tlsCredentialedSigner.getCertificate();
                            }
                            if (null == certificate) {
                                certificate = Certificate.EMPTY_CHAIN_TLS13;
                            }
                            this.send13CertificateMessage(certificate, null);
                            this.connection_state = (short)15;
                            if (null != tlsCredentialedSigner) {
                                DigitallySigned digitallySigned = TlsUtils.generate13CertificateVerify(this.tlsClientContext, tlsCredentialedSigner, this.handshakeHash);
                                this.send13CertificateVerifyMessage(digitallySigned);
                                this.connection_state = (short)17;
                            }
                        }
                        this.send13FinishedMessage();
                        this.connection_state = (short)18;
                        TlsUtils.establish13PhaseApplication(this.tlsClientContext, byArray, this.recordStream);
                        this.recordStream.enablePendingCipherWrite();
                        this.recordStream.enablePendingCipherRead(false);
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 24: {
                switch (this.connection_state) {
                    case 21: {
                        this.receive13ServerKeyUpdate(handshakeMessageInput);
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 4: {
                switch (this.connection_state) {
                    case 21: {
                        this.receive13NewSessionTicket(handshakeMessageInput);
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        throw new TlsFatalAlert(80);
                    }
                    case 3: {
                        ServerHello serverHello = this.receiveServerHelloMessage(handshakeMessageInput);
                        if (serverHello.isHelloRetryRequest()) {
                            throw new TlsFatalAlert(10);
                        }
                        this.process13ServerHello(serverHello, true);
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)4;
                        this.process13ServerHelloCoda(serverHello, true);
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    @Override
    protected void handleHandshakeMessage(short s, HandshakeMessageInput handshakeMessageInput) throws IOException {
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParameters();
        if (this.connection_state > 1 && TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) {
            this.handle13HandshakeMessage(s, handshakeMessageInput);
            return;
        }
        if (!this.isLegacyConnectionState()) {
            throw new TlsFatalAlert(80);
        }
        if (this.resumedSession) {
            if (s != 20 || this.connection_state != 4) {
                throw new TlsFatalAlert(10);
            }
            this.processFinishedMessage(handshakeMessageInput);
            handshakeMessageInput.updateHash(this.handshakeHash);
            this.connection_state = (short)20;
            this.sendChangeCipherSpec();
            this.sendFinishedMessage();
            this.connection_state = (short)18;
            this.completeHandshake();
            return;
        }
        block0 : switch (s) {
            case 11: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = TlsUtils.receiveServerCertificate(this.tlsClientContext, this.tlsClient, handshakeMessageInput);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)7;
                break;
            }
            case 22: {
                switch (this.connection_state) {
                    case 7: {
                        if (securityParameters.getStatusRequestVersion() < 1) {
                            throw new TlsFatalAlert(10);
                        }
                        this.certificateStatus = CertificateStatus.parse(this.tlsClientContext, handshakeMessageInput);
                        TlsClientProtocol.assertEmpty(handshakeMessageInput);
                        this.connection_state = (short)8;
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 20: {
                switch (this.connection_state) {
                    case 18: {
                        if (this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                    }
                    case 19: {
                        this.processFinishedMessage(handshakeMessageInput);
                        this.connection_state = (short)20;
                        this.completeHandshake();
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 2: {
                switch (this.connection_state) {
                    case 1: {
                        ServerHello serverHello = this.receiveServerHelloMessage(handshakeMessageInput);
                        if (serverHello.isHelloRetryRequest()) {
                            this.process13HelloRetryRequest(serverHello);
                            this.handshakeHash.notifyPRFDetermined();
                            TlsUtils.adjustTranscriptForRetry(this.handshakeHash);
                            handshakeMessageInput.updateHash(this.handshakeHash);
                            this.connection_state = (short)2;
                            this.send13ClientHelloRetry();
                            this.connection_state = (short)3;
                            break block0;
                        }
                        this.processServerHello(serverHello);
                        this.handshakeHash.notifyPRFDetermined();
                        handshakeMessageInput.updateHash(this.handshakeHash);
                        this.connection_state = (short)4;
                        if (!TlsUtils.isTLSv13(securityParameters.getNegotiatedVersion())) break block0;
                        this.process13ServerHelloCoda(serverHello, false);
                        break block0;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
            }
            case 23: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(TlsClientProtocol.readSupplementalDataMessage(handshakeMessageInput));
                        break block0;
                    }
                }
                throw new TlsFatalAlert(10);
            }
            case 14: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = null;
                    }
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 10: 
                    case 11: {
                        TlsClientProtocol.assertEmpty(handshakeMessageInput);
                        this.connection_state = (short)12;
                        Vector vector = this.tlsClient.getClientSupplementalData();
                        if (vector != null) {
                            this.sendSupplementalDataMessage(vector);
                            this.connection_state = (short)14;
                        }
                        TlsCredentialedSigner tlsCredentialedSigner = null;
                        TlsStreamSigner tlsStreamSigner = null;
                        if (this.certificateRequest == null) {
                            this.keyExchange.skipClientCredentials();
                        } else {
                            Certificate certificate = null;
                            TlsCredentials tlsCredentials = TlsUtils.establishClientCredentials(this.authentication, this.certificateRequest);
                            if (null == tlsCredentials) {
                                this.keyExchange.skipClientCredentials();
                            } else {
                                this.keyExchange.processClientCredentials(tlsCredentials);
                                certificate = tlsCredentials.getCertificate();
                                if (tlsCredentials instanceof TlsCredentialedSigner) {
                                    tlsCredentialedSigner = (TlsCredentialedSigner)tlsCredentials;
                                    tlsStreamSigner = tlsCredentialedSigner.getStreamSigner();
                                }
                            }
                            this.sendCertificateMessage(certificate, null);
                            this.connection_state = (short)15;
                        }
                        boolean bl = tlsStreamSigner != null;
                        TlsUtils.sealHandshakeHash(this.tlsClientContext, this.handshakeHash, bl);
                        this.sendClientKeyExchange();
                        this.connection_state = (short)16;
                        boolean bl2 = TlsUtils.isSSL(this.tlsClientContext);
                        if (bl2) {
                            TlsClientProtocol.establishMasterSecret(this.tlsClientContext, this.keyExchange);
                        }
                        this.tlsClientContext.getSecurityParametersHandshake().sessionHash = TlsUtils.getCurrentPRFHash(this.handshakeHash);
                        if (!bl2) {
                            TlsClientProtocol.establishMasterSecret(this.tlsClientContext, this.keyExchange);
                        }
                        this.recordStream.setPendingCipher(TlsUtils.initCipher(this.tlsClientContext));
                        if (tlsCredentialedSigner != null) {
                            DigitallySigned digitallySigned = TlsUtils.generateCertificateVerifyClient(this.tlsClientContext, tlsCredentialedSigner, tlsStreamSigner, this.handshakeHash);
                            this.sendCertificateVerifyMessage(digitallySigned);
                            this.connection_state = (short)17;
                        }
                        this.handshakeHash = this.handshakeHash.stopTracking();
                        this.sendChangeCipherSpec();
                        this.sendFinishedMessage();
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)18;
                break;
            }
            case 12: {
                switch (this.connection_state) {
                    case 4: {
                        this.handleSupplementalData(null);
                    }
                    case 6: {
                        this.authentication = null;
                    }
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.processServerKeyExchange(handshakeMessageInput);
                        TlsClientProtocol.assertEmpty(handshakeMessageInput);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)10;
                break;
            }
            case 13: {
                switch (this.connection_state) {
                    case 7: 
                    case 8: {
                        this.handleServerCertificate();
                        this.keyExchange.skipServerKeyExchange();
                    }
                    case 10: {
                        this.receiveCertificateRequest(handshakeMessageInput);
                        TlsUtils.establishServerSigAlgs(securityParameters, this.certificateRequest);
                        TlsUtils.trackHashAlgorithms(this.handshakeHash, securityParameters.getServerSigAlgs());
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)11;
                break;
            }
            case 4: {
                switch (this.connection_state) {
                    case 18: {
                        if (!this.expectSessionTicket) {
                            throw new TlsFatalAlert(10);
                        }
                        this.invalidateSession();
                        this.receiveNewSessionTicket(handshakeMessageInput);
                        break;
                    }
                    default: {
                        throw new TlsFatalAlert(10);
                    }
                }
                this.connection_state = (short)19;
                break;
            }
            case 0: {
                TlsClientProtocol.assertEmpty(handshakeMessageInput);
                if (this.connection_state != 21) break;
                this.refuseRenegotiation();
                break;
            }
            default: {
                throw new TlsFatalAlert(10);
            }
        }
    }

    protected void handleServerCertificate() throws IOException {
        TlsUtils.processServerCertificate(this.tlsClientContext, this.certificateStatus, this.keyExchange, this.authentication, this.clientExtensions, this.serverExtensions);
    }

    protected void handleSupplementalData(Vector vector) throws IOException {
        this.tlsClient.processServerSupplementalData(vector);
        this.connection_state = (short)6;
        this.keyExchange = TlsUtils.initKeyExchangeClient(this.tlsClientContext, this.tlsClient);
    }

    protected void process13HelloRetryRequest(ServerHello serverHello) throws IOException {
        ProtocolVersion protocolVersion = ProtocolVersion.TLSv12;
        this.recordStream.setWriteVersion(protocolVersion);
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion2 = serverHello.getVersion();
        byte[] byArray = serverHello.getSessionID();
        int n = serverHello.getCipherSuite();
        if (!(ProtocolVersion.TLSv12.equals(protocolVersion2) && Arrays.areEqual((byte[])this.clientHello.getSessionID(), (byte[])byArray) && TlsUtils.isValidCipherSuiteSelection(this.clientHello.getCipherSuites(), n))) {
            throw new TlsFatalAlert(47);
        }
        Hashtable hashtable = serverHello.getExtensions();
        if (null == hashtable) {
            throw new TlsFatalAlert(47);
        }
        ProtocolVersion protocolVersion3 = TlsExtensionsUtils.getSupportedVersionsExtensionServer(hashtable);
        if (null == protocolVersion3) {
            throw new TlsFatalAlert(109);
        }
        if (!(ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion3) && ProtocolVersion.contains(this.tlsClientContext.getClientSupportedVersions(), protocolVersion3) && TlsUtils.isValidVersionForCipherSuite(n, protocolVersion3))) {
            throw new TlsFatalAlert(47);
        }
        int n2 = TlsExtensionsUtils.getKeyShareHelloRetryRequest(hashtable);
        if (!TlsUtils.isValidKeyShareSelection(protocolVersion3, securityParameters.getClientSupportedGroups(), this.clientAgreements, n2)) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray2 = TlsExtensionsUtils.getCookieExtension(hashtable);
        securityParameters.negotiatedVersion = protocolVersion3;
        TlsUtils.negotiatedVersionTLSClient(this.tlsClientContext, this.tlsClient);
        this.resumedSession = false;
        securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
        this.tlsClient.notifySessionID(TlsUtils.EMPTY_BYTES);
        TlsUtils.negotiatedCipherSuite(securityParameters, n);
        this.tlsClient.notifySelectedCipherSuite(n);
        this.clientAgreements = null;
        this.retryCookie = byArray2;
        this.retryGroup = n2;
    }

    protected void process13ServerHello(ServerHello serverHello, boolean bl) throws IOException {
        Object object;
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = serverHello.getVersion();
        byte[] byArray = serverHello.getSessionID();
        int n = serverHello.getCipherSuite();
        if (!ProtocolVersion.TLSv12.equals(protocolVersion) || !Arrays.areEqual((byte[])this.clientHello.getSessionID(), (byte[])byArray)) {
            throw new TlsFatalAlert(47);
        }
        Hashtable hashtable = serverHello.getExtensions();
        if (null == hashtable) {
            throw new TlsFatalAlert(47);
        }
        if (bl) {
            object = TlsExtensionsUtils.getSupportedVersionsExtensionServer(hashtable);
            if (null == object) {
                throw new TlsFatalAlert(109);
            }
            if (!securityParameters.getNegotiatedVersion().equals((ProtocolVersion)object) || securityParameters.getCipherSuite() != n) {
                throw new TlsFatalAlert(47);
            }
        } else {
            if (!TlsUtils.isValidCipherSuiteSelection(this.clientHello.getCipherSuites(), n) || !TlsUtils.isValidVersionForCipherSuite(n, securityParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            this.resumedSession = false;
            securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
            this.tlsClient.notifySessionID(TlsUtils.EMPTY_BYTES);
            TlsUtils.negotiatedCipherSuite(securityParameters, n);
            this.tlsClient.notifySelectedCipherSuite(n);
        }
        this.clientHello = null;
        securityParameters.serverRandom = serverHello.getRandom();
        securityParameters.secureRenegotiation = false;
        securityParameters.extendedMasterSecret = true;
        object = TlsExtensionsUtils.getKeyShareServerHello(hashtable);
        if (null == object) {
            throw new TlsFatalAlert(47);
        }
        TlsAgreement tlsAgreement = (TlsAgreement)this.clientAgreements.get(Integers.valueOf((int)((KeyShareEntry)object).getNamedGroup()));
        if (null == tlsAgreement) {
            throw new TlsFatalAlert(47);
        }
        this.clientAgreements = null;
        tlsAgreement.receivePeerValue(((KeyShareEntry)object).getKeyExchange());
        securityParameters.sharedSecret = tlsAgreement.calculateSecret();
        TlsUtils.establish13PhaseSecrets(this.tlsClientContext);
        this.invalidateSession();
        this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
        this.sessionParameters = null;
        this.sessionMasterSecret = null;
    }

    protected void process13ServerHelloCoda(ServerHello serverHello, boolean bl) throws IOException {
        byte[] byArray = TlsUtils.getCurrentPRFHash(this.handshakeHash);
        TlsUtils.establish13PhaseHandshake(this.tlsClientContext, byArray, this.recordStream);
        if (!bl) {
            this.recordStream.setIgnoreChangeCipherSpec(true);
            this.sendChangeCipherSpecMessage();
        }
        this.recordStream.enablePendingCipherWrite();
        this.recordStream.enablePendingCipherRead(false);
    }

    protected void processServerHello(ServerHello serverHello) throws IOException {
        byte[] byArray;
        ProtocolVersion protocolVersion;
        Hashtable hashtable = serverHello.getExtensions();
        ProtocolVersion protocolVersion2 = serverHello.getVersion();
        ProtocolVersion protocolVersion3 = TlsExtensionsUtils.getSupportedVersionsExtensionServer(hashtable);
        if (null == protocolVersion3) {
            protocolVersion = protocolVersion2;
        } else {
            if (!ProtocolVersion.TLSv12.equals(protocolVersion2) || !ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion3)) {
                throw new TlsFatalAlert(47);
            }
            protocolVersion = protocolVersion3;
        }
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        if (!ProtocolVersion.contains(this.tlsClientContext.getClientSupportedVersions(), protocolVersion)) {
            throw new TlsFatalAlert(70);
        }
        Object object = protocolVersion.isLaterVersionOf(ProtocolVersion.TLSv12) ? ProtocolVersion.TLSv12 : protocolVersion;
        this.recordStream.setWriteVersion((ProtocolVersion)object);
        securityParameters.negotiatedVersion = protocolVersion;
        TlsUtils.negotiatedVersionTLSClient(this.tlsClientContext, this.tlsClient);
        if (ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion)) {
            this.process13ServerHello(serverHello, false);
            return;
        }
        object = this.clientHello.getCipherSuites();
        this.clientHello = null;
        this.retryCookie = null;
        this.retryGroup = -1;
        securityParameters.serverRandom = serverHello.getRandom();
        if (!this.tlsClientContext.getClientVersion().equals(protocolVersion)) {
            TlsUtils.checkDowngradeMarker(protocolVersion, securityParameters.getServerRandom());
        }
        byte[] byArray2 = serverHello.getSessionID();
        securityParameters.sessionID = byArray2;
        this.tlsClient.notifySessionID(byArray2);
        this.resumedSession = byArray2.length > 0 && this.tlsSession != null && Arrays.areEqual((byte[])byArray2, (byte[])this.tlsSession.getSessionID());
        int n = serverHello.getCipherSuite();
        if (!TlsUtils.isValidCipherSuiteSelection((int[])object, n) || !TlsUtils.isValidVersionForCipherSuite(n, securityParameters.getNegotiatedVersion())) {
            throw new TlsFatalAlert(47);
        }
        TlsUtils.negotiatedCipherSuite(securityParameters, n);
        this.tlsClient.notifySelectedCipherSuite(n);
        this.serverExtensions = hashtable;
        if (this.serverExtensions != null) {
            Enumeration enumeration = this.serverExtensions.keys();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                if (n2.equals(EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(this.clientExtensions, n2)) {
                    throw new TlsFatalAlert(110);
                }
                if (!this.resumedSession) continue;
            }
        }
        if ((byArray = TlsUtils.getExtensionData(this.serverExtensions, EXT_RenegotiationInfo)) == null) {
            securityParameters.secureRenegotiation = false;
        } else {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])byArray, (byte[])TlsClientProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        this.tlsClient.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        boolean bl = TlsExtensionsUtils.hasExtendedMasterSecretExtension(this.serverExtensions);
        if (bl ? protocolVersion.isSSL() || !this.resumedSession && !this.tlsClient.shouldUseExtendedMasterSecret() : this.tlsClient.requiresExtendedMasterSecret() || this.resumedSession && !this.tlsClient.allowLegacyResumption()) {
            throw new TlsFatalAlert(40);
        }
        securityParameters.extendedMasterSecret = bl;
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(this.serverExtensions);
        securityParameters.applicationProtocolSet = true;
        Hashtable hashtable2 = this.clientExtensions;
        Hashtable hashtable3 = this.serverExtensions;
        if (this.resumedSession) {
            if (securityParameters.getCipherSuite() != this.sessionParameters.getCipherSuite() || 0 != this.sessionParameters.getCompressionAlgorithm() || !protocolVersion.equals(this.sessionParameters.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            hashtable2 = null;
            hashtable3 = this.sessionParameters.readServerExtensions();
        }
        if (hashtable3 != null && !hashtable3.isEmpty()) {
            boolean bl2 = TlsExtensionsUtils.hasEncryptThenMACExtension(hashtable3);
            if (bl2 && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.encryptThenMAC = bl2;
            securityParameters.maxFragmentLength = this.processMaxFragmentLengthExtension(hashtable2, hashtable3, (short)47);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(hashtable3);
            if (!this.resumedSession) {
                if (TlsUtils.hasExpectedEmptyExtensionData(hashtable3, TlsExtensionsUtils.EXT_status_request_v2, (short)47)) {
                    securityParameters.statusRequestVersion = 2;
                } else if (TlsUtils.hasExpectedEmptyExtensionData(hashtable3, TlsExtensionsUtils.EXT_status_request, (short)47)) {
                    securityParameters.statusRequestVersion = 1;
                }
            }
            boolean bl3 = this.expectSessionTicket = !this.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(hashtable3, TlsProtocol.EXT_SessionTicket, (short)47);
        }
        if (hashtable2 != null) {
            this.tlsClient.processServerExtensions(hashtable3);
        }
        this.applyMaxFragmentLengthExtension();
        if (this.resumedSession) {
            securityParameters.masterSecret = this.sessionMasterSecret;
            this.recordStream.setPendingCipher(TlsUtils.initCipher(this.tlsClientContext));
        } else {
            this.invalidateSession();
            this.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
            this.sessionParameters = null;
            this.sessionMasterSecret = null;
        }
    }

    protected void receive13CertificateRequest(ByteArrayInputStream byteArrayInputStream, boolean bl) throws IOException {
        CertificateRequest certificateRequest = CertificateRequest.parse(this.tlsClientContext, byteArrayInputStream);
        TlsClientProtocol.assertEmpty(byteArrayInputStream);
        if (bl) {
            throw new TlsFatalAlert(80);
        }
        if (!certificateRequest.hasCertificateRequestContext(TlsUtils.EMPTY_BYTES)) {
            throw new TlsFatalAlert(47);
        }
        this.certificateRequest = certificateRequest;
        TlsUtils.establishServerSigAlgs(this.tlsClientContext.getSecurityParametersHandshake(), certificateRequest);
    }

    protected void receive13EncryptedExtensions(ByteArrayInputStream byteArrayInputStream) throws IOException {
        byte[] byArray = TlsUtils.readOpaque16(byteArrayInputStream);
        TlsClientProtocol.assertEmpty(byteArrayInputStream);
        this.serverExtensions = TlsClientProtocol.readExtensionsData(byArray);
        this.tlsClient.processServerExtensions(this.serverExtensions);
    }

    protected void receive13NewSessionTicket(ByteArrayInputStream byteArrayInputStream) throws IOException {
        TlsUtils.readUint32(byteArrayInputStream);
        TlsUtils.readUint32(byteArrayInputStream);
        TlsUtils.readOpaque8(byteArrayInputStream);
        TlsUtils.readOpaque16(byteArrayInputStream);
        TlsUtils.readOpaque16(byteArrayInputStream);
        TlsClientProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void receive13ServerCertificate(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.authentication = TlsUtils.receiveServerCertificate(this.tlsClientContext, this.tlsClient, byteArrayInputStream);
        this.handleServerCertificate();
    }

    protected void receive13ServerCertificateVerify(ByteArrayInputStream byteArrayInputStream) throws IOException {
        Certificate certificate = this.tlsClientContext.getSecurityParametersHandshake().getPeerCertificate();
        if (null == certificate || certificate.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        DigitallySigned digitallySigned = DigitallySigned.parse(this.tlsClientContext, byteArrayInputStream);
        TlsClientProtocol.assertEmpty(byteArrayInputStream);
        TlsUtils.verify13CertificateVerifyServer(this.tlsClientContext, digitallySigned, this.handshakeHash);
    }

    protected void receive13ServerFinished(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.processFinishedMessage(byteArrayInputStream);
    }

    protected void receive13ServerKeyUpdate(ByteArrayInputStream byteArrayInputStream) throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected void receiveCertificateRequest(ByteArrayInputStream byteArrayInputStream) throws IOException {
        if (null == this.authentication) {
            throw new TlsFatalAlert(40);
        }
        CertificateRequest certificateRequest = CertificateRequest.parse(this.tlsClientContext, byteArrayInputStream);
        TlsClientProtocol.assertEmpty(byteArrayInputStream);
        this.certificateRequest = TlsUtils.validateCertificateRequest(certificateRequest, this.keyExchange);
    }

    protected void receiveNewSessionTicket(ByteArrayInputStream byteArrayInputStream) throws IOException {
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(byteArrayInputStream);
        TlsClientProtocol.assertEmpty(byteArrayInputStream);
        this.tlsClient.notifyNewSessionTicket(newSessionTicket);
    }

    protected ServerHello receiveServerHelloMessage(ByteArrayInputStream byteArrayInputStream) throws IOException {
        return ServerHello.parse(byteArrayInputStream);
    }

    protected void send13ClientHelloRetry() throws IOException {
        Hashtable hashtable = this.clientHello.getExtensions();
        hashtable.remove(TlsExtensionsUtils.EXT_cookie);
        hashtable.remove(TlsExtensionsUtils.EXT_early_data);
        hashtable.remove(TlsExtensionsUtils.EXT_key_share);
        if (null != this.retryCookie) {
            TlsExtensionsUtils.addCookieExtension(hashtable, this.retryCookie);
            this.retryCookie = null;
        }
        if (this.retryGroup < 0) {
            throw new TlsFatalAlert(80);
        }
        this.clientAgreements = TlsUtils.addKeyShareToClientHelloRetry(this.tlsClientContext, hashtable, this.retryGroup);
        this.recordStream.setIgnoreChangeCipherSpec(true);
        this.sendChangeCipherSpecMessage();
        this.sendClientHelloMessage();
    }

    protected void sendCertificateVerifyMessage(DigitallySigned digitallySigned) throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(15);
        digitallySigned.encode(handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void sendClientHello() throws IOException {
        boolean bl;
        SecurityParameters securityParameters = this.tlsClientContext.getSecurityParametersHandshake();
        this.tlsClientContext.setClientSupportedVersions(this.tlsClient.getProtocolVersions());
        if (ProtocolVersion.contains(this.tlsClientContext.getClientSupportedVersions(), ProtocolVersion.SSLv3)) {
            this.recordStream.setWriteVersion(ProtocolVersion.SSLv3);
        } else {
            this.recordStream.setWriteVersion(ProtocolVersion.TLSv10);
        }
        ProtocolVersion protocolVersion = ProtocolVersion.getLatestTLS(this.tlsClientContext.getClientSupportedVersions());
        if (!ProtocolVersion.isSupportedTLSVersionClient(protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        this.tlsClientContext.setClientVersion(protocolVersion);
        boolean bl2 = ProtocolVersion.TLSv13.isEqualOrEarlierVersionOf(protocolVersion);
        byte[] byArray = TlsUtils.getSessionID(this.tlsSession);
        boolean bl3 = this.tlsClient.isFallback();
        int[] nArray = this.tlsClient.getCipherSuites();
        if (!(byArray.length <= 0 || this.sessionParameters == null || Arrays.contains((int[])nArray, (int)this.sessionParameters.getCipherSuite()) && 0 == this.sessionParameters.getCompressionAlgorithm())) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        this.clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(this.tlsClient.getClientExtensions());
        ProtocolVersion protocolVersion2 = protocolVersion;
        if (bl2) {
            protocolVersion2 = ProtocolVersion.TLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionClient(this.clientExtensions, this.tlsClientContext.getClientSupportedVersions());
            if (byArray.length < 1) {
                byArray = this.tlsClientContext.getNonceGenerator().generateNonce(32);
            }
        }
        this.tlsClientContext.setRSAPreMasterSecretVersion(protocolVersion2);
        securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(this.clientExtensions);
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) {
            TlsUtils.establishClientSigAlgs(securityParameters, this.clientExtensions);
        }
        securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(this.clientExtensions);
        this.clientAgreements = TlsUtils.addEarlyKeySharesToClientHello(this.tlsClientContext, this.tlsClient, this.clientExtensions);
        if (TlsUtils.isExtendedMasterSecretOptionalTLS(this.tlsClientContext.getClientSupportedVersions()) && this.tlsClient.shouldUseExtendedMasterSecret()) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(this.clientExtensions);
        } else if (!bl2 && this.tlsClient.requiresExtendedMasterSecret()) {
            throw new TlsFatalAlert(80);
        }
        boolean bl4 = !bl2 && this.tlsClient.shouldUseGMTUnixTime();
        securityParameters.clientRandom = TlsClientProtocol.createRandomBlock(bl4, this.tlsClientContext);
        bl4 = null == TlsUtils.getExtensionData(this.clientExtensions, EXT_RenegotiationInfo);
        boolean bl5 = bl = !Arrays.contains((int[])nArray, (int)255);
        if (bl4 && bl) {
            nArray = Arrays.append((int[])nArray, (int)255);
        }
        if (bl3 && !Arrays.contains((int[])nArray, (int)22016)) {
            nArray = Arrays.append((int[])nArray, (int)22016);
        }
        this.clientHello = new ClientHello(protocolVersion2, securityParameters.getClientRandom(), byArray, null, nArray, this.clientExtensions);
        this.sendClientHelloMessage();
    }

    protected void sendClientHelloMessage() throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(1);
        this.clientHello.encode(this.tlsClientContext, handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void sendClientKeyExchange() throws IOException {
        HandshakeMessageOutput handshakeMessageOutput = new HandshakeMessageOutput(16);
        this.keyExchange.generateClientKeyExchange(handshakeMessageOutput);
        handshakeMessageOutput.send(this);
    }

    protected void skip13CertificateRequest() throws IOException {
        this.certificateRequest = null;
    }

    protected void skip13ServerCertificate() throws IOException {
        this.authentication = null;
        throw new TlsFatalAlert(10);
    }
}

