/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.DummyX509KeyManager;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.NamedGroupInfo;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvDHGroupVerifier;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSessionHandshake;
import org.bouncycastle.jsse.provider.ProvSSLSessionResumed;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvX509Key;
import org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatusRequest;
import org.bouncycastle.tls.CertificateStatusRequestItemV2;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.OCSPStatusRequest;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerName;
import org.bouncycastle.tls.SignatureAlgorithm;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.TrustedAuthority;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.IPAddress;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvTlsClient
extends DefaultTlsClient
implements ProvTlsPeer {
    private static final Logger LOG = Logger.getLogger(ProvTlsClient.class.getName());
    private static final boolean provEnableSNIExtension = PropertyUtils.getBooleanSystemProperty("jsse.enableSNIExtension", true);
    private static final boolean provClientEnableStatusRequest = PropertyUtils.getBooleanSystemProperty("jdk.tls.client.enableStatusRequestExtension", true);
    private static final boolean provClientEnableTrustedCAKeys = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.client.enableTrustedCAKeysExtension", false);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected final JsseSecurityParameters jsseSecurityParameters = new JsseSecurityParameters();
    protected ProvSSLSession sslSession = null;
    protected boolean handshakeComplete = false;

    ProvTlsClient(ProvTlsManager provTlsManager, ProvSSLParameters provSSLParameters) {
        super(provTlsManager.getContextData().getCrypto());
        this.manager = provTlsManager;
        this.sslParameters = provSSLParameters.copyForConnection();
    }

    @Override
    protected Vector<X500Name> getCertificateAuthorities() {
        return null;
    }

    @Override
    protected CertificateStatusRequest getCertificateStatusRequest() {
        if (!provClientEnableStatusRequest) {
            return null;
        }
        OCSPStatusRequest oCSPStatusRequest = new OCSPStatusRequest(null, null);
        return new CertificateStatusRequest(1, oCSPStatusRequest);
    }

    @Override
    protected Vector<CertificateStatusRequestItemV2> getMultiCertStatusRequest() {
        if (!provClientEnableStatusRequest) {
            return null;
        }
        OCSPStatusRequest oCSPStatusRequest = new OCSPStatusRequest(null, null);
        Vector<CertificateStatusRequestItemV2> vector = new Vector<CertificateStatusRequestItemV2>(2);
        vector.add(new CertificateStatusRequestItemV2(2, oCSPStatusRequest));
        vector.add(new CertificateStatusRequestItemV2(1, oCSPStatusRequest));
        return vector;
    }

    @Override
    protected Vector<ProtocolName> getProtocolNames() {
        return JsseUtils.getProtocolNames(this.sslParameters.getApplicationProtocols());
    }

    @Override
    protected Vector<Integer> getSupportedGroups(Vector vector) {
        return NamedGroupInfo.getSupportedGroupsLocal(this.jsseSecurityParameters.namedGroups);
    }

    @Override
    protected Vector<ServerName> getSNIServerNames() {
        if (provEnableSNIExtension) {
            Object object;
            List<BCSNIServerName> list = this.sslParameters.getServerNames();
            if (null == list && null != (object = this.manager.getPeerHostSNI()) && ((String)object).indexOf(46) > 0 && !IPAddress.isValid((String)object)) {
                try {
                    list = Collections.singletonList(new BCSNIHostName((String)object));
                }
                catch (RuntimeException runtimeException) {
                    LOG.fine("Failed to add peer host as default SNI host_name: " + (String)object);
                }
            }
            if (null != list && !list.isEmpty()) {
                object = new Vector(list.size());
                for (BCSNIServerName bCSNIServerName : list) {
                    ((Vector)object).add(new ServerName((short)bCSNIServerName.getType(), bCSNIServerName.getEncoded()));
                }
                return object;
            }
        }
        return null;
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return this.manager.getContextData().getContext().getActiveCipherSuites(this.getCrypto(), this.sslParameters, this.getProtocolVersions());
    }

    @Override
    protected Vector<SignatureAndHashAlgorithm> getSupportedSignatureAlgorithms() {
        ContextData contextData = this.manager.getContextData();
        ProtocolVersion[] protocolVersionArray = this.getProtocolVersions();
        List<SignatureSchemeInfo> list = contextData.getActiveCertsSignatureSchemes(false, this.sslParameters, protocolVersionArray, this.jsseSecurityParameters.namedGroups);
        this.jsseSecurityParameters.localSigSchemes = list;
        this.jsseSecurityParameters.localSigSchemesCert = list;
        return SignatureSchemeInfo.getSignatureAndHashAlgorithms(this.jsseSecurityParameters.localSigSchemes);
    }

    @Override
    protected Vector<SignatureAndHashAlgorithm> getSupportedSignatureAlgorithmsCert() {
        return null;
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return this.manager.getContextData().getContext().getActiveProtocolVersions(this.sslParameters);
    }

    @Override
    protected Vector<TrustedAuthority> getTrustedCAIndication() {
        Vector<X500Name> vector;
        if (provClientEnableTrustedCAKeys && null != (vector = JsseUtils.getCertificateAuthorities(this.manager.getContextData().getX509TrustManager()))) {
            Vector<TrustedAuthority> vector2 = new Vector<TrustedAuthority>(vector.size());
            for (X500Name x500Name : vector) {
                vector2.add(new TrustedAuthority(2, x500Name));
            }
            return vector2;
        }
        return null;
    }

    @Override
    public boolean allowLegacyResumption() {
        return JsseUtils.allowLegacyResumption();
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public TlsDHGroupVerifier getDHGroupVerifier() {
        return new ProvDHGroupVerifier();
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            @Override
            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                ContextData contextData = ProvTlsClient.this.manager.getContextData();
                SecurityParameters securityParameters = ProvTlsClient.this.context.getSecurityParametersHandshake();
                ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
                boolean bl = TlsUtils.isTLSv13(protocolVersion);
                Principal[] principalArray = securityParameters.getServerSigAlgs();
                Object object = securityParameters.getServerSigAlgsCert();
                ProvTlsClient.this.jsseSecurityParameters.peerSigSchemes = contextData.getSignatureSchemes((Vector<SignatureAndHashAlgorithm>)principalArray);
                List<SignatureSchemeInfo> list = ProvTlsClient.this.jsseSecurityParameters.peerSigSchemesCert = principalArray == object ? ProvTlsClient.this.jsseSecurityParameters.peerSigSchemes : contextData.getSignatureSchemes((Vector<SignatureAndHashAlgorithm>)object);
                if (DummyX509KeyManager.INSTANCE == contextData.getX509KeyManager()) {
                    return null;
                }
                principalArray = JsseUtils.toX500Principals(certificateRequest.getCertificateAuthorities());
                object = certificateRequest.getCertificateRequestContext();
                if (bl != (null != object)) {
                    throw new TlsFatalAlert(80);
                }
                short[] sArray = certificateRequest.getCertificateTypes();
                if (bl != (null == sArray)) {
                    throw new TlsFatalAlert(80);
                }
                if (bl) {
                    return ProvTlsClient.this.chooseClientCredentials13(principalArray, (byte[])object);
                }
                if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) {
                    return ProvTlsClient.this.chooseClientCredentials12(principalArray, sArray);
                }
                return ProvTlsClient.this.chooseClientCredentialsLegacy(principalArray, sArray);
            }

            @Override
            public void notifyServerCertificate(TlsServerCertificate tlsServerCertificate) throws IOException {
                if (null == tlsServerCertificate || null == tlsServerCertificate.getCertificate() || tlsServerCertificate.getCertificate().isEmpty()) {
                    throw new TlsFatalAlert(40);
                }
                X509Certificate[] x509CertificateArray = JsseUtils.getX509CertificateChain(ProvTlsClient.this.getCrypto(), tlsServerCertificate.getCertificate());
                String string = JsseUtils.getAuthTypeServer(ProvTlsClient.this.context.getSecurityParametersHandshake().getKeyExchangeAlgorithm());
                ProvTlsClient.this.jsseSecurityParameters.statusResponses = JsseUtils.getStatusResponses(tlsServerCertificate.getCertificateStatus());
                ProvTlsClient.this.manager.checkServerTrusted(x509CertificateArray, string);
            }
        };
    }

    @Override
    public JcaTlsCrypto getCrypto() {
        return this.manager.getContextData().getCrypto();
    }

    @Override
    public TlsSession getSessionToResume() {
        Object object;
        ProvSSLSession provSSLSession = this.sslParameters.getSessionToResume();
        if (null == provSSLSession) {
            object = this.manager.getContextData().getClientSessionContext();
            provSSLSession = ((ProvSSLSessionContext)object).getSessionImpl(this.manager.getPeerHost(), this.manager.getPeerPort());
        }
        if (null != provSSLSession && null != (object = provSSLSession.getTlsSession()) && this.isResumable(provSSLSession)) {
            this.sslSession = provSSLSession;
            return object;
        }
        if (!this.manager.getEnableSessionCreation()) {
            throw new IllegalStateException("No resumable sessions and session creation is disabled");
        }
        return null;
    }

    @Override
    public void notifyAlertRaised(short s, short s2, String string, Throwable throwable) {
        Level level;
        super.notifyAlertRaised(s, s2, string, throwable);
        Level level2 = s == 1 ? Level.FINE : (level = s2 == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            Object object = JsseUtils.getAlertLogMessage("Client raised", s, s2);
            if (string != null) {
                object = (String)object + ": " + string;
            }
            LOG.log(level, (String)object, throwable);
        }
    }

    @Override
    public void notifyAlertReceived(short s, short s2) {
        Level level;
        super.notifyAlertReceived(s, s2);
        Level level2 = level = s == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String string = JsseUtils.getAlertLogMessage("Client received", s, s2);
            LOG.log(level, string);
        }
    }

    @Override
    public void notifyHandshakeBeginning() throws IOException {
        super.notifyHandshakeBeginning();
        ContextData contextData = this.manager.getContextData();
        ProtocolVersion[] protocolVersionArray = this.getProtocolVersions();
        this.jsseSecurityParameters.namedGroups = contextData.getNamedGroups(this.sslParameters, protocolVersionArray);
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.handshakeComplete = true;
        TlsSession tlsSession = this.context.getSession();
        if (null == this.sslSession || this.sslSession.getTlsSession() != tlsSession) {
            ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getClientSessionContext();
            String string = this.manager.getPeerHost();
            int n = this.manager.getPeerPort();
            JsseSessionParameters jsseSessionParameters = new JsseSessionParameters(this.sslParameters.getEndpointIdentificationAlgorithm());
            this.sslSession = provSSLSessionContext.reportSession(string, n, tlsSession, jsseSessionParameters);
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this.context, this.sslSession));
    }

    @Override
    public void notifySecureRenegotiation(boolean bl) throws IOException {
        boolean bl2;
        if (!bl && !(bl2 = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public void notifySelectedCipherSuite(int n) {
        String string = this.manager.getContextData().getContext().validateNegotiatedCipherSuite(this.sslParameters, n);
        LOG.fine("Client notified of selected cipher suite: " + string);
        super.notifySelectedCipherSuite(n);
    }

    @Override
    public void notifyServerVersion(ProtocolVersion protocolVersion) throws IOException {
        String string = this.manager.getContextData().getContext().validateNegotiatedProtocol(this.sslParameters, protocolVersion);
        LOG.fine("Client notified of selected protocol version: " + string);
        super.notifyServerVersion(protocolVersion);
    }

    @Override
    public void notifySessionID(byte[] byArray) {
        boolean bl;
        boolean bl2 = bl = null != byArray && byArray.length > 0 && null != this.sslSession && Arrays.areEqual((byte[])byArray, (byte[])this.sslSession.getId());
        if (bl) {
            LOG.fine("Server resumed session: " + Hex.toHexString((byte[])byArray));
        } else {
            if (byArray == null || byArray.length < 1) {
                LOG.fine("Server did not specify a session ID");
            } else {
                LOG.fine("Server specified new session: " + Hex.toHexString((byte[])byArray));
            }
            if (!this.manager.getEnableSessionCreation()) {
                throw new IllegalStateException("Server did not resume session and session creation is disabled");
            }
        }
        ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getClientSessionContext();
        String string = this.manager.getPeerHost();
        int n = this.manager.getPeerPort();
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        ProvSSLSessionHandshake provSSLSessionHandshake = !bl ? new ProvSSLSessionHandshake(provSSLSessionContext, string, n, securityParameters, this.jsseSecurityParameters) : new ProvSSLSessionResumed(provSSLSessionContext, string, n, securityParameters, this.jsseSecurityParameters, this.sslSession.getTlsSession(), this.sslSession.getJsseSessionParameters());
        this.manager.notifyHandshakeSession(provSSLSessionHandshake);
    }

    @Override
    public boolean requiresExtendedMasterSecret() {
        return !JsseUtils.allowLegacyMasterSecret();
    }

    @Override
    public boolean shouldUseExtendedMasterSecret() {
        return JsseUtils.useExtendedMasterSecret();
    }

    protected TlsCredentials chooseClientCredentials13(Principal[] principalArray, byte[] byArray) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        for (SignatureSchemeInfo signatureSchemeInfo : this.jsseSecurityParameters.peerSigSchemes) {
            String string;
            if (!signatureSchemeInfo.isSupported13() || !this.jsseSecurityParameters.localSigSchemes.contains(signatureSchemeInfo) || hashSet.contains(string = JsseUtils.getKeyType(signatureSchemeInfo))) continue;
            ProvX509Key provX509Key = this.manager.chooseClientKey(new String[]{string}, principalArray);
            if (null == provX509Key) {
                hashSet.add(string);
                continue;
            }
            return JsseUtils.createCredentialedSigner13(this.context, this.getCrypto(), provX509Key, signatureSchemeInfo.getSignatureAndHashAlgorithm(), byArray);
        }
        return null;
    }

    protected TlsCredentials chooseClientCredentials12(Principal[] principalArray, short[] sArray) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        for (SignatureSchemeInfo signatureSchemeInfo : this.jsseSecurityParameters.peerSigSchemes) {
            short s;
            short s2;
            String string = JsseUtils.getKeyType(signatureSchemeInfo);
            if (hashSet.contains(string) || (s2 = SignatureAlgorithm.getClientCertificateType(s = signatureSchemeInfo.getSignatureAlgorithm())) < 0 || !Arrays.contains((short[])sArray, (short)s2) || !this.jsseSecurityParameters.localSigSchemes.contains(signatureSchemeInfo)) continue;
            ProvX509Key provX509Key = this.manager.chooseClientKey(new String[]{string}, principalArray);
            if (null == provX509Key) {
                hashSet.add(string);
                continue;
            }
            return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), provX509Key, signatureSchemeInfo.getSignatureAndHashAlgorithm());
        }
        return null;
    }

    protected TlsCredentials chooseClientCredentialsLegacy(Principal[] principalArray, short[] sArray) throws IOException {
        String[] stringArray = this.getKeyTypesLegacy(sArray);
        ProvX509Key provX509Key = this.manager.chooseClientKey(stringArray, principalArray);
        if (null == provX509Key) {
            return null;
        }
        return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), provX509Key, null);
    }

    protected String[] getKeyTypesLegacy(short[] sArray) throws IOException {
        String[] stringArray = new String[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            stringArray[i] = JsseUtils.getKeyTypeLegacyClient(sArray[i]);
        }
        return stringArray;
    }

    protected boolean isResumable(ProvSSLSession provSSLSession) {
        String string;
        JsseSessionParameters jsseSessionParameters = provSSLSession.getJsseSessionParameters();
        String string2 = this.sslParameters.getEndpointIdentificationAlgorithm();
        if (null != string2 && !string2.equalsIgnoreCase(string = jsseSessionParameters.getIdentificationProtocol())) {
            LOG.finest("Session not resumed - endpoint ID algorithm mismatch; requested: " + string2 + ", session: " + string);
            return false;
        }
        return true;
    }
}

