/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.DummyX509KeyManager;
import org.bouncycastle.jsse.provider.JsseSecurityParameters;
import org.bouncycastle.jsse.provider.JsseSessionParameters;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.NamedGroupInfo;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSession;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsDHUtils;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.DHGroup;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvTlsServer
extends DefaultTlsServer
implements ProvTlsPeer {
    private static final Logger LOG = Logger.getLogger(ProvTlsServer.class.getName());
    private static final String PROPERTY_DEFAULT_DHE_PARAMETERS = "jdk.tls.server.defaultDHEParameters";
    private static final int provEphemeralDHKeySize = PropertyUtils.getIntegerSystemProperty("jdk.tls.ephemeralDHKeySize", 2048, 1024, 8192);
    private static final DHGroup[] provServerDefaultDHEParameters = ProvTlsServer.getDefaultDHEParameters();
    private static final boolean provServerEnableCA = PropertyUtils.getBooleanSystemProperty("jdk.tls.server.enableCAExtension", true);
    private static final boolean provServerEnableSessionResumption = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.server.enableSessionResumption", true);
    private static final boolean provServerEnableStatusRequest = false;
    private static final boolean provServerEnableTrustedCAKeys = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.server.enableTrustedCAKeysExtension", false);
    protected final ProvTlsManager manager;
    protected final ProvSSLParameters sslParameters;
    protected final JsseSecurityParameters jsseSecurityParameters = new JsseSecurityParameters();
    protected ProvSSLSession sslSession = null;
    protected BCSNIServerName matchedSNIServerName = null;
    protected Set<String> keyManagerMissCache = null;
    protected TlsCredentials credentials = null;
    protected boolean handshakeComplete = false;

    private static DHGroup[] getDefaultDHEParameters() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String string = PropertyUtils.getStringSecurityProperty(PROPERTY_DEFAULT_DHE_PARAMETERS);
        if (null == string) {
            return null;
        }
        String string2 = JsseUtils.stripDoubleQuotes(JsseUtils.removeAllWhitespace(string));
        int n6 = string2.length();
        if (n6 < 1) {
            return null;
        }
        ArrayList<DHGroup> arrayList = new ArrayList<DHGroup>();
        int n7 = -1;
        while ((n5 = n7 + 1) < n6 && '{' == string2.charAt(n5) && (n4 = string2.indexOf(44, n3 = n5 + 1)) > n3 && (n2 = string2.indexOf(125, n = n4 + 1)) > n) {
            try {
                BigInteger bigInteger = ProvTlsServer.parseDHParameter(string2, n3, n4);
                BigInteger bigInteger2 = ProvTlsServer.parseDHParameter(string2, n, n2);
                DHGroup dHGroup = TlsDHUtils.getStandardGroupForDHParameters(bigInteger, bigInteger2);
                if (null != dHGroup) {
                    arrayList.add(dHGroup);
                } else if (!bigInteger.isProbablePrime(120)) {
                    LOG.log(Level.WARNING, "Non-prime modulus ignored in security property [jdk.tls.server.defaultDHEParameters]: " + bigInteger.toString(16));
                } else {
                    arrayList.add(new DHGroup(bigInteger, null, bigInteger2, 0));
                }
            }
            catch (Exception exception) {
                break;
            }
            n7 = n2 + 1;
            if (n7 >= n6) {
                return arrayList.toArray(new DHGroup[arrayList.size()]);
            }
            if (',' == string2.charAt(n7)) continue;
        }
        LOG.log(Level.WARNING, "Invalid syntax for security property [jdk.tls.server.defaultDHEParameters]");
        return null;
    }

    private static BigInteger parseDHParameter(String string, int n, int n2) {
        return new BigInteger(string.substring(n, n2), 16);
    }

    ProvTlsServer(ProvTlsManager provTlsManager, ProvSSLParameters provSSLParameters) {
        super(provTlsManager.getContextData().getCrypto());
        this.manager = provTlsManager;
        this.sslParameters = provSSLParameters.copyForConnection();
    }

    @Override
    protected boolean allowCertificateStatus() {
        return false;
    }

    @Override
    protected boolean allowMultiCertStatus() {
        return false;
    }

    @Override
    protected boolean allowTrustedCAIndication() {
        return null != this.jsseSecurityParameters.trustedIssuers;
    }

    @Override
    protected int getMaximumNegotiableCurveBits() {
        return NamedGroupInfo.getMaximumBitsServerECDH(this.jsseSecurityParameters.namedGroups);
    }

    @Override
    protected int getMaximumNegotiableFiniteFieldBits() {
        int n = NamedGroupInfo.getMaximumBitsServerFFDHE(this.jsseSecurityParameters.namedGroups);
        return n >= provEphemeralDHKeySize ? n : 0;
    }

    @Override
    protected Vector<ProtocolName> getProtocolNames() {
        return JsseUtils.getProtocolNames(this.sslParameters.getApplicationProtocols());
    }

    @Override
    protected int[] getSupportedCipherSuites() {
        return this.manager.getContextData().getContext().getActiveCipherSuites(this.getCrypto(), this.sslParameters, this.getProtocolVersions());
    }

    @Override
    protected ProtocolVersion[] getSupportedVersions() {
        return this.manager.getContextData().getContext().getActiveProtocolVersions(this.sslParameters);
    }

    @Override
    protected boolean preferLocalCipherSuites() {
        return this.sslParameters.getUseCipherSuitesOrder();
    }

    @Override
    protected boolean selectCipherSuite(int n) throws IOException {
        TlsCredentials tlsCredentials = this.selectCredentials(this.jsseSecurityParameters.trustedIssuers, n);
        if (null == tlsCredentials) {
            String string = ProvSSLContextSpi.getCipherSuiteName(n);
            LOG.finer("Server found no credentials for cipher suite: " + string);
            return false;
        }
        boolean bl = super.selectCipherSuite(n);
        if (bl) {
            this.credentials = tlsCredentials;
        }
        return bl;
    }

    @Override
    protected int selectDH(int n) {
        n = Math.max(n, provEphemeralDHKeySize);
        return NamedGroupInfo.selectServerFFDHE(this.jsseSecurityParameters.namedGroups, n);
    }

    @Override
    protected int selectDHDefault(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int selectECDH(int n) {
        return NamedGroupInfo.selectServerECDH(this.jsseSecurityParameters.namedGroups, n);
    }

    @Override
    protected int selectECDHDefault(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ProtocolName selectProtocolName() throws IOException {
        if (null == this.sslParameters.getEngineAPSelector() && null == this.sslParameters.getSocketAPSelector()) {
            return super.selectProtocolName();
        }
        Vector vector = this.clientProtocolNames;
        List<String> list = JsseUtils.getProtocolNames(vector);
        String string = this.manager.selectApplicationProtocol(Collections.unmodifiableList(list));
        if (null == string) {
            throw new TlsFatalAlert(120);
        }
        if (string.length() < 1) {
            return null;
        }
        if (!list.contains(string)) {
            throw new TlsFatalAlert(120);
        }
        return ProtocolName.asUtf8Encoding(string);
    }

    @Override
    protected boolean shouldSelectProtocolNameEarly() {
        return null == this.sslParameters.getEngineAPSelector() && null == this.sslParameters.getSocketAPSelector();
    }

    @Override
    public boolean allowLegacyResumption() {
        return JsseUtils.allowLegacyResumption();
    }

    @Override
    public int getMaxCertificateChainLength() {
        return JsseUtils.getMaxCertificateChainLength();
    }

    @Override
    public int getMaxHandshakeMessageSize() {
        return JsseUtils.getMaxHandshakeMessageSize();
    }

    @Override
    public synchronized boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        return this.credentials;
    }

    @Override
    public CertificateRequest getCertificateRequest() throws IOException {
        if (!this.isClientAuthEnabled()) {
            return null;
        }
        ContextData contextData = this.manager.getContextData();
        ProtocolVersion protocolVersion = this.context.getServerVersion();
        List<SignatureSchemeInfo> list = contextData.getActiveCertsSignatureSchemes(true, this.sslParameters, new ProtocolVersion[]{protocolVersion}, this.jsseSecurityParameters.namedGroups);
        this.jsseSecurityParameters.localSigSchemes = list;
        this.jsseSecurityParameters.localSigSchemesCert = list;
        Vector<SignatureAndHashAlgorithm> vector = SignatureSchemeInfo.getSignatureAndHashAlgorithms(this.jsseSecurityParameters.localSigSchemes);
        Vector<X500Name> vector2 = null;
        if (provServerEnableCA) {
            vector2 = JsseUtils.getCertificateAuthorities(contextData.getX509TrustManager());
        }
        if (TlsUtils.isTLSv13(protocolVersion)) {
            byte[] byArray = TlsUtils.EMPTY_BYTES;
            Vector<SignatureAndHashAlgorithm> vector3 = null;
            if (this.jsseSecurityParameters.localSigSchemes != this.jsseSecurityParameters.localSigSchemesCert) {
                vector3 = SignatureSchemeInfo.getSignatureAndHashAlgorithms(this.jsseSecurityParameters.localSigSchemesCert);
            }
            return new CertificateRequest(byArray, vector, vector3, vector2);
        }
        short[] sArray = new short[]{64, 1, 2};
        return new CertificateRequest(sArray, vector, vector2);
    }

    @Override
    public CertificateStatus getCertificateStatus() throws IOException {
        return null;
    }

    @Override
    public JcaTlsCrypto getCrypto() {
        return this.manager.getContextData().getCrypto();
    }

    @Override
    public int[] getSupportedGroups() throws IOException {
        ProtocolVersion[] protocolVersionArray = new ProtocolVersion[]{this.context.getServerVersion()};
        this.jsseSecurityParameters.namedGroups = this.manager.getContextData().getNamedGroups(this.sslParameters, protocolVersionArray);
        return NamedGroupInfo.getSupportedGroupsLocalServer(this.jsseSecurityParameters.namedGroups);
    }

    @Override
    public int getSelectedCipherSuite() throws IOException {
        ContextData contextData = this.manager.getContextData();
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        Object object = securityParameters.getClientSupportedGroups();
        NamedGroupInfo.notifyPeer(this.jsseSecurityParameters.namedGroups, object);
        object = securityParameters.getClientSigAlgs();
        Object object2 = securityParameters.getClientSigAlgsCert();
        this.jsseSecurityParameters.peerSigSchemes = contextData.getSignatureSchemes((Vector<SignatureAndHashAlgorithm>)object);
        List<SignatureSchemeInfo> list = this.jsseSecurityParameters.peerSigSchemesCert = object == object2 ? this.jsseSecurityParameters.peerSigSchemes : contextData.getSignatureSchemes((Vector<SignatureAndHashAlgorithm>)object2);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest(JsseUtils.getSignatureAlgorithmsReport("Peer signature_algorithms", this.jsseSecurityParameters.peerSigSchemes));
            if (this.jsseSecurityParameters.peerSigSchemesCert != this.jsseSecurityParameters.peerSigSchemes) {
                LOG.finest(JsseUtils.getSignatureAlgorithmsReport("Peer signature_algorithms_cert", this.jsseSecurityParameters.peerSigSchemesCert));
            }
        }
        if (DummyX509KeyManager.INSTANCE == contextData.getX509KeyManager()) {
            throw new TlsFatalAlert(40);
        }
        this.keyManagerMissCache = new HashSet<String>();
        int n = super.getSelectedCipherSuite();
        this.keyManagerMissCache = null;
        object2 = this.manager.getContextData().getContext().validateNegotiatedCipherSuite(this.sslParameters, n);
        LOG.fine("Server selected cipher suite: " + (String)object2);
        return n;
    }

    @Override
    public Hashtable<Integer, byte[]> getServerExtensions() throws IOException {
        super.getServerExtensions();
        if (null != this.matchedSNIServerName) {
            TlsExtensionsUtils.addServerNameExtensionServer(this.serverExtensions);
        }
        Hashtable hashtable = this.serverExtensions;
        return hashtable;
    }

    @Override
    public TlsSession getSessionToResume(byte[] byArray) {
        TlsSession tlsSession;
        ProvSSLSession provSSLSession;
        ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getServerSessionContext();
        if (provServerEnableSessionResumption && null != (provSSLSession = provSSLSessionContext.getSessionImpl(byArray)) && this.isResumable(provSSLSession, tlsSession = provSSLSession.getTlsSession())) {
            this.sslSession = provSSLSession;
            return tlsSession;
        }
        JsseUtils.checkSessionCreationEnabled(this.manager);
        return null;
    }

    @Override
    public byte[] getNewSessionID() {
        if (!provServerEnableSessionResumption || TlsUtils.isTLSv13(this.context)) {
            return null;
        }
        return this.context.getNonceGenerator().generateNonce(32);
    }

    @Override
    public void notifySession(TlsSession tlsSession) {
        boolean bl;
        byte[] byArray = tlsSession.getSessionID();
        boolean bl2 = bl = null != this.sslSession && this.sslSession.getTlsSession() == tlsSession;
        if (bl) {
            LOG.fine("Server resumed session: " + Hex.toHexString((byte[])byArray));
        } else {
            this.sslSession = null;
            if (TlsUtils.isNullOrEmpty(byArray)) {
                LOG.fine("Server did not specify a session ID");
            } else {
                LOG.fine("Server specified new session: " + Hex.toHexString((byte[])byArray));
            }
            JsseUtils.checkSessionCreationEnabled(this.manager);
        }
        this.manager.notifyHandshakeSession(this.manager.getContextData().getServerSessionContext(), this.context.getSecurityParametersHandshake(), this.jsseSecurityParameters, this.sslSession);
    }

    @Override
    public void notifyAlertRaised(short s, short s2, String string, Throwable throwable) {
        Level level;
        Level level2 = s == 1 ? Level.FINE : (level = s2 == 80 ? Level.WARNING : Level.INFO);
        if (LOG.isLoggable(level)) {
            Object object = JsseUtils.getAlertLogMessage("Server raised", s, s2);
            if (string != null) {
                object = (String)object + ": " + string;
            }
            LOG.log(level, (String)object, throwable);
        }
    }

    @Override
    public void notifyAlertReceived(short s, short s2) {
        Level level;
        super.notifyAlertReceived(s, s2);
        Level level2 = level = s == 1 ? Level.FINE : Level.INFO;
        if (LOG.isLoggable(level)) {
            String string = JsseUtils.getAlertLogMessage("Server received", s, s2);
            LOG.log(level, string);
        }
    }

    @Override
    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion protocolVersion = super.getServerVersion();
        String string = this.manager.getContextData().getContext().validateNegotiatedProtocol(this.sslParameters, protocolVersion);
        LOG.fine("Server selected protocol version: " + string);
        return protocolVersion;
    }

    @Override
    public void notifyClientCertificate(Certificate certificate) throws IOException {
        if (!this.isClientAuthEnabled()) {
            throw new TlsFatalAlert(80);
        }
        if (null == certificate || certificate.isEmpty()) {
            if (this.sslParameters.getNeedClientAuth()) {
                short s = TlsUtils.isTLSv13(this.context) ? (short)116 : 40;
                throw new TlsFatalAlert(s);
            }
        } else {
            X509Certificate[] x509CertificateArray = JsseUtils.getX509CertificateChain(this.getCrypto(), certificate);
            TlsCertificate tlsCertificate = certificate.getCertificateAt(0);
            short s = tlsCertificate.supportsSignatureAlgorithm((short)7) ? (short)7 : (tlsCertificate.supportsSignatureAlgorithm((short)8) ? (short)8 : tlsCertificate.getLegacySignatureAlgorithm());
            if (s < 0) {
                throw new TlsFatalAlert(43);
            }
            String string = JsseUtils.getAuthTypeClient(s);
            this.manager.checkClientTrusted(x509CertificateArray, string);
        }
    }

    @Override
    public synchronized void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.handshakeComplete = true;
        TlsSession tlsSession = this.context.getSession();
        if (null == this.sslSession || this.sslSession.getTlsSession() != tlsSession) {
            ProvSSLSessionContext provSSLSessionContext = this.manager.getContextData().getServerSessionContext();
            String string = this.manager.getPeerHost();
            int n = this.manager.getPeerPort();
            JsseSessionParameters jsseSessionParameters = new JsseSessionParameters(null, this.matchedSNIServerName);
            boolean bl = provServerEnableSessionResumption && !TlsUtils.isTLSv13(this.context) && this.context.getSecurityParametersConnection().isExtendedMasterSecret();
            this.sslSession = provSSLSessionContext.reportSession(string, n, tlsSession, jsseSessionParameters, bl);
        }
        this.manager.notifyHandshakeComplete(new ProvSSLConnection(this.context, this.sslSession));
    }

    @Override
    public void notifySecureRenegotiation(boolean bl) throws IOException {
        boolean bl2;
        if (!bl && !(bl2 = PropertyUtils.getBooleanSystemProperty("sun.security.ssl.allowLegacyHelloMessages", true))) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public void processClientExtensions(Hashtable hashtable) throws IOException {
        Vector vector;
        super.processClientExtensions(hashtable);
        Vector vector2 = this.context.getSecurityParametersHandshake().getClientServerNames();
        if (null != vector2) {
            vector = this.sslParameters.getSNIMatchers();
            if (null == vector || vector.isEmpty()) {
                LOG.fine("Server ignored SNI (no matchers specified)");
            } else {
                this.matchedSNIServerName = JsseUtils.findMatchingSNIServerName(vector2, vector);
                if (null == this.matchedSNIServerName) {
                    throw new TlsFatalAlert(112);
                }
                LOG.fine("Server accepted SNI: " + this.matchedSNIServerName);
            }
        }
        if (TlsUtils.isTLSv13(this.context)) {
            vector = TlsExtensionsUtils.getCertificateAuthoritiesExtension(hashtable);
            this.jsseSecurityParameters.trustedIssuers = JsseUtils.toX500Principals(vector);
        } else if (provServerEnableTrustedCAKeys) {
            vector = this.trustedCAKeys;
            this.jsseSecurityParameters.trustedIssuers = JsseUtils.getTrustedIssuers(vector);
        }
    }

    @Override
    public boolean requiresCloseNotify() {
        return JsseUtils.requireCloseNotify();
    }

    @Override
    public boolean requiresExtendedMasterSecret() {
        return !JsseUtils.allowLegacyMasterSecret();
    }

    @Override
    public boolean shouldUseExtendedMasterSecret() {
        return JsseUtils.useExtendedMasterSecret();
    }

    protected boolean isClientAuthEnabled() {
        return this.sslParameters.getNeedClientAuth() || this.sslParameters.getWantClientAuth();
    }

    protected boolean isResumable(ProvSSLSession provSSLSession, TlsSession tlsSession) {
        if (null == tlsSession || !tlsSession.isResumable()) {
            return false;
        }
        Object object = this.context.getSecurityParametersHandshake();
        Object object2 = ((SecurityParameters)object).getNegotiatedVersion();
        if (TlsUtils.isTLSv13((ProtocolVersion)object2)) {
            return false;
        }
        Object object3 = tlsSession.exportSessionParameters();
        if (!(null != object3 && ((ProtocolVersion)object2).equals(((SessionParameters)object3).getNegotiatedVersion()) && Arrays.contains((int[])this.getCipherSuites(), (int)((SessionParameters)object3).getCipherSuite()) && Arrays.contains((int[])this.offeredCipherSuites, (int)((SessionParameters)object3).getCipherSuite()))) {
            return false;
        }
        if (!((SessionParameters)object3).isExtendedMasterSecret()) {
            return false;
        }
        object2 = this.matchedSNIServerName;
        object = provSSLSession.getJsseSessionParameters();
        object3 = ((JsseSessionParameters)object).getMatchedSNIServerName();
        if (!JsseUtils.equals(object2, object3)) {
            LOG.finest("Session not resumable - SNI mismatch; connection: " + (BCSNIServerName)object2 + ", session: " + (BCSNIServerName)object3);
            return false;
        }
        return true;
    }

    protected TlsCredentials selectCredentials(Principal[] principalArray, int n) throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(n);
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 17: 
            case 19: {
                if (1 == n2 || !TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.context.getServerVersion())) {
                    return this.selectServerCredentialsLegacy(principalArray, n2);
                }
                return this.selectServerCredentials12(principalArray, n2);
            }
            case 0: {
                byte[] byArray = TlsUtils.EMPTY_BYTES;
                return this.selectServerCredentials13(principalArray, byArray);
            }
        }
        return null;
    }

    protected TlsCredentials selectServerCredentials12(Principal[] principalArray, int n) throws IOException {
        Object object;
        BCAlgorithmConstraints bCAlgorithmConstraints = this.sslParameters.getAlgorithmConstraints();
        short s = TlsUtils.getLegacySignatureAlgorithmServer(n);
        LinkedHashMap<String, SignatureSchemeInfo> linkedHashMap = new LinkedHashMap<String, SignatureSchemeInfo>();
        for (SignatureSchemeInfo object22 : this.jsseSecurityParameters.peerSigSchemes) {
            short string;
            if (!TlsUtils.isValidSignatureSchemeForServerKeyExchange(object22.getSignatureScheme(), n) || this.keyManagerMissCache.contains(object = s == (string = object22.getSignatureAlgorithm()) ? JsseUtils.getKeyTypeLegacyServer(n) : object22.getKeyType()) || linkedHashMap.containsKey(object) || !object22.isActive(bCAlgorithmConstraints, false, true, this.jsseSecurityParameters.namedGroups)) continue;
            linkedHashMap.put((String)object, object22);
        }
        if (linkedHashMap.isEmpty()) {
            LOG.fine("Server (1.2) has no key types to try for KeyExchangeAlgorithm " + n);
            return null;
        }
        String[] stringArray = linkedHashMap.keySet().toArray(TlsUtils.EMPTY_STRINGS);
        BCX509Key bCX509Key = this.manager.chooseServerKey(stringArray, principalArray);
        if (null == bCX509Key) {
            this.handleKeyManagerMisses(linkedHashMap, null);
            LOG.fine("Server (1.2) did not select any credentials for KeyExchangeAlgorithm " + n);
            return null;
        }
        String string = bCX509Key.getKeyType();
        this.handleKeyManagerMisses(linkedHashMap, string);
        object = linkedHashMap.get(string);
        if (null == object) {
            throw new TlsFatalAlert(80, "Key manager returned invalid key type");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Server (1.2) selected credentials for signature scheme '" + (SignatureSchemeInfo)object + "' (keyType '" + string + "'), with private key algorithm '" + JsseUtils.getPrivateKeyAlgorithm(bCX509Key.getPrivateKey()) + "'");
        }
        return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), bCX509Key, ((SignatureSchemeInfo)object).getSignatureAndHashAlgorithm());
    }

    protected TlsCredentials selectServerCredentials13(Principal[] principalArray, byte[] byArray) throws IOException {
        String string;
        BCAlgorithmConstraints bCAlgorithmConstraints = this.sslParameters.getAlgorithmConstraints();
        LinkedHashMap<String, SignatureSchemeInfo> linkedHashMap = new LinkedHashMap<String, SignatureSchemeInfo>();
        for (SignatureSchemeInfo object2 : this.jsseSecurityParameters.peerSigSchemes) {
            string = object2.getKeyType13();
            if (this.keyManagerMissCache.contains(string) || linkedHashMap.containsKey(string) || !object2.isActive(bCAlgorithmConstraints, true, false, this.jsseSecurityParameters.namedGroups)) continue;
            linkedHashMap.put(string, object2);
        }
        if (linkedHashMap.isEmpty()) {
            LOG.fine("Server (1.3) found no usable signature schemes");
            return null;
        }
        String[] stringArray = linkedHashMap.keySet().toArray(TlsUtils.EMPTY_STRINGS);
        BCX509Key bCX509Key = this.manager.chooseServerKey(stringArray, principalArray);
        if (null == bCX509Key) {
            this.handleKeyManagerMisses(linkedHashMap, null);
            LOG.fine("Server (1.3) did not select any credentials");
            return null;
        }
        string = bCX509Key.getKeyType();
        this.handleKeyManagerMisses(linkedHashMap, string);
        SignatureSchemeInfo signatureSchemeInfo = linkedHashMap.get(string);
        if (null == signatureSchemeInfo) {
            throw new TlsFatalAlert(80, "Key manager returned invalid key type");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Server (1.3) selected credentials for signature scheme '" + signatureSchemeInfo + "' (keyType '" + string + "'), with private key algorithm '" + JsseUtils.getPrivateKeyAlgorithm(bCX509Key.getPrivateKey()) + "'");
        }
        return JsseUtils.createCredentialedSigner13(this.context, this.getCrypto(), bCX509Key, signatureSchemeInfo.getSignatureAndHashAlgorithm(), byArray);
    }

    protected TlsCredentials selectServerCredentialsLegacy(Principal[] principalArray, int n) throws IOException {
        String string = JsseUtils.getKeyTypeLegacyServer(n);
        if (this.keyManagerMissCache.contains(string)) {
            return null;
        }
        BCX509Key bCX509Key = this.manager.chooseServerKey(new String[]{string}, principalArray);
        if (null == bCX509Key) {
            this.keyManagerMissCache.add(string);
            return null;
        }
        if (1 == n) {
            return JsseUtils.createCredentialedDecryptor(this.getCrypto(), bCX509Key);
        }
        return JsseUtils.createCredentialedSigner(this.context, this.getCrypto(), bCX509Key, null);
    }

    private void handleKeyManagerMisses(LinkedHashMap<String, SignatureSchemeInfo> linkedHashMap, String string) {
        Map.Entry<String, SignatureSchemeInfo> entry;
        String string2;
        Iterator<Map.Entry<String, SignatureSchemeInfo>> iterator = linkedHashMap.entrySet().iterator();
        while (iterator.hasNext() && !(string2 = (entry = iterator.next()).getKey()).equals(string)) {
            this.keyManagerMissCache.add(string2);
            if (!LOG.isLoggable(Level.FINER)) continue;
            SignatureSchemeInfo signatureSchemeInfo = entry.getValue();
            LOG.finer("Server found no credentials for signature scheme '" + signatureSchemeInfo + "' (keyType '" + string2 + "')");
        }
    }
}

