/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URI;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.bouncycastle.jcajce.PKIXCRLStore;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Iterable;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

class CrlCache {
    private static final int DEFAULT_TIMEOUT = 15000;
    private static Map cache = Collections.synchronizedMap(new WeakHashMap());

    CrlCache() {
    }

    static synchronized PKIXCRLStore getCrl(CertificateFactory certificateFactory, Date date, URI uRI) throws IOException, CRLException {
        Object object;
        PKIXCRLStore pKIXCRLStore = null;
        WeakReference weakReference = (WeakReference)cache.get(uRI);
        if (weakReference != null) {
            pKIXCRLStore = (PKIXCRLStore)weakReference.get();
        }
        if (pKIXCRLStore != null) {
            boolean bl = false;
            object = pKIXCRLStore.getMatches(null).iterator();
            while (object.hasNext()) {
                X509CRL x509CRL = (X509CRL)object.next();
                Date date2 = x509CRL.getNextUpdate();
                if (date2 == null || !date2.before(date)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return pKIXCRLStore;
            }
        }
        Collection collection = uRI.getScheme().equals("ldap") ? CrlCache.getCrlsFromLDAP(certificateFactory, uRI) : CrlCache.getCrls(certificateFactory, uRI);
        object = new LocalCRLStore(new CollectionStore(collection));
        cache.put(uRI, new WeakReference<Object>(object));
        return object;
    }

    private static Collection getCrlsFromLDAP(CertificateFactory certificateFactory, URI uRI) throws IOException, CRLException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", uRI.toString());
        byte[] byArray = null;
        try {
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            Attributes attributes = initialDirContext.getAttributes("");
            Attribute attribute = attributes.get("certificateRevocationList;binary");
            byArray = (byte[])attribute.get();
        }
        catch (NamingException namingException) {
            throw new CRLException("issue connecting to: " + uRI.toString());
        }
        if (byArray == null || byArray.length == 0) {
            throw new CRLException("no CRL returned from: " + uRI);
        }
        return certificateFactory.generateCRLs(new ByteArrayInputStream(byArray));
    }

    private static Collection getCrls(CertificateFactory certificateFactory, URI uRI) throws IOException, CRLException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRI.toURL().openConnection();
        InputStream inputStream = httpURLConnection.getInputStream();
        Collection<? extends CRL> collection = certificateFactory.generateCRLs(inputStream);
        inputStream.close();
        return collection;
    }

    private static class LocalCRLStore
    implements PKIXCRLStore,
    Iterable {
        private Collection _local;

        public LocalCRLStore(Store store) {
            this._local = new ArrayList(store.getMatches(null));
        }

        public Collection getMatches(Selector selector) {
            if (selector == null) {
                return new ArrayList(this._local);
            }
            ArrayList<CRL> arrayList = new ArrayList<CRL>();
            Iterator iterator = this._local.iterator();
            while (iterator.hasNext()) {
                CRL cRL = (CRL)iterator.next();
                if (!selector.match(cRL)) continue;
                arrayList.add(cRL);
            }
            return arrayList;
        }

        public Iterator iterator() {
            return this.getMatches(null).iterator();
        }
    }
}

