/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.sasn1;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.sasn1.DerObject;

public class Asn1ObjectIdentifier
extends DerObject {
    private String _oid;

    Asn1ObjectIdentifier(int n, byte[] byArray) throws IOException {
        super(n, 6, byArray);
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        boolean bl = true;
        int n2 = 0;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        while ((n2 = byteArrayInputStream.read()) >= 0) {
            l = l * 128L + (long)(n2 & 0x7F);
            if ((n2 & 0x80) != 0) continue;
            if (bl) {
                switch ((int)l / 40) {
                    case 0: {
                        stringBuffer.append('0');
                        break;
                    }
                    case 1: {
                        stringBuffer.append('1');
                        l -= 40L;
                        break;
                    }
                    default: {
                        stringBuffer.append('2');
                        l -= 80L;
                    }
                }
                bl = false;
            }
            stringBuffer.append('.');
            stringBuffer.append(Long.toString(l));
            l = 0L;
        }
        this._oid = stringBuffer.toString();
    }

    public Asn1ObjectIdentifier(String string) throws IllegalArgumentException {
        super(0, 6, Asn1ObjectIdentifier.toByteArray(string));
        this._oid = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Asn1ObjectIdentifier)) {
            return false;
        }
        return this._oid.equals(((Asn1ObjectIdentifier)object)._oid);
    }

    public int hashCode() {
        return this._oid.hashCode();
    }

    private static byte[] toByteArray(String string) throws IllegalArgumentException {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Asn1ObjectIdentifier.writeField(byteArrayOutputStream, Integer.parseInt(oIDTokenizer.nextToken()) * 40 + Integer.parseInt(oIDTokenizer.nextToken()));
            while (oIDTokenizer.hasMoreTokens()) {
                Asn1ObjectIdentifier.writeField(byteArrayOutputStream, Long.parseLong(oIDTokenizer.nextToken()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("exception parsing field value: " + numberFormatException.getMessage());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("exception converting to bytes: " + iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        return this._oid;
    }

    private static void writeField(OutputStream outputStream, long l) throws IOException {
        if (l >= 128L) {
            if (l >= 16384L) {
                if (l >= 0x200000L) {
                    if (l >= 0x10000000L) {
                        if (l >= 8L) {
                            if (l >= 1024L) {
                                if (l >= 131072L) {
                                    if (l >= 0x1000000L) {
                                        outputStream.write((int)(l >> 56) | 0x80);
                                    }
                                    outputStream.write((int)(l >> 49) | 0x80);
                                }
                                outputStream.write((int)(l >> 42) | 0x80);
                            }
                            outputStream.write((int)(l >> 35) | 0x80);
                        }
                        outputStream.write((int)(l >> 28) | 0x80);
                    }
                    outputStream.write((int)(l >> 21) | 0x80);
                }
                outputStream.write((int)(l >> 14) | 0x80);
            }
            outputStream.write((int)(l >> 7) | 0x80);
        }
        outputStream.write((int)l & 0x7F);
    }

    private static class OIDTokenizer {
        private String oid;
        private int index;

        public OIDTokenizer(String string) {
            this.oid = string;
            this.index = 0;
        }

        public boolean hasMoreTokens() {
            return this.index != -1;
        }

        public String nextToken() {
            if (this.index == -1) {
                return null;
            }
            int n = this.oid.indexOf(46, this.index);
            if (n == -1) {
                String string = this.oid.substring(this.index);
                this.index = -1;
                return string;
            }
            String string = this.oid.substring(this.index, n);
            this.index = n + 1;
            return string;
        }
    }
}

