/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509V2AttributeCertificate;

public class PEMWriter
extends BufferedWriter {
    public PEMWriter(Writer writer) {
        super(writer);
    }

    private void writeEncoded(byte[] byArray) throws IOException {
        char[] cArray = new char[64];
        byArray = Base64.encode(byArray);
        int n = 0;
        while (n < byArray.length) {
            int n2 = 0;
            while (n2 != cArray.length) {
                if (n + n2 >= byArray.length) break;
                cArray[n2] = (char)byArray[n + n2];
                ++n2;
            }
            this.write(cArray, 0, n2);
            this.newLine();
            n += cArray.length;
        }
    }

    private void writeHexEncoded(byte[] byArray) throws IOException {
        byArray = Hex.encode(byArray);
        int n = 0;
        while (n != byArray.length) {
            this.write((char)byArray[n]);
            ++n;
        }
    }

    public void writeObject(Object object) throws IOException {
        byte[] byArray;
        String string;
        if (object instanceof X509Certificate) {
            string = "CERTIFICATE";
            try {
                byArray = ((X509Certificate)object).getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException("Cannot encode object: " + certificateEncodingException.toString());
            }
        } else {
            if (object instanceof KeyPair) {
                this.writeObject(((KeyPair)object).getPrivate());
                return;
            }
            if (object instanceof PrivateKey) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((Key)object).getEncoded());
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo((ASN1Sequence)aSN1InputStream.readObject());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
                if (object instanceof RSAPrivateKey) {
                    string = "RSA PRIVATE KEY";
                    aSN1OutputStream.writeObject(privateKeyInfo.getPrivateKey());
                } else if (object instanceof DSAPrivateKey) {
                    string = "DSA PRIVATE KEY";
                    DSAParameter dSAParameter = DSAParameter.getInstance(privateKeyInfo.getAlgorithmId().getParameters());
                    ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                    aSN1EncodableVector.add(new DERInteger(0));
                    aSN1EncodableVector.add(new DERInteger(dSAParameter.getP()));
                    aSN1EncodableVector.add(new DERInteger(dSAParameter.getQ()));
                    aSN1EncodableVector.add(new DERInteger(dSAParameter.getG()));
                    BigInteger bigInteger = ((DSAPrivateKey)object).getX();
                    BigInteger bigInteger2 = dSAParameter.getG().modPow(bigInteger, dSAParameter.getP());
                    aSN1EncodableVector.add(new DERInteger(bigInteger2));
                    aSN1EncodableVector.add(new DERInteger(bigInteger));
                    aSN1OutputStream.writeObject(new DERSequence(aSN1EncodableVector));
                } else {
                    throw new IOException("Cannot identify private key");
                }
                byArray = byteArrayOutputStream.toByteArray();
            } else if (object instanceof PublicKey) {
                string = "PUBLIC KEY";
                byArray = ((PublicKey)object).getEncoded();
            } else if (object instanceof X509AttributeCertificate) {
                string = "ATTRIBUTE CERTIFICATE";
                byArray = ((X509V2AttributeCertificate)object).getEncoded();
            } else if (object instanceof PKCS10CertificationRequest) {
                string = "CERTIFICATE REQUEST";
                byArray = ((PKCS10CertificationRequest)object).getEncoded();
            } else {
                throw new IOException("unknown object passed - can't encode.");
            }
        }
        this.write("-----BEGIN " + string + "-----");
        this.newLine();
        this.writeEncoded(byArray);
        this.write("-----END " + string + "-----");
        this.newLine();
    }

    public void writeObject(Object object, String string, char[] cArray, SecureRandom secureRandom) throws IOException {
        Object object2;
        Object object3;
        byte[] byArray = new byte[8];
        secureRandom.nextBytes(byArray);
        OpenSSLPBEParametersGenerator openSSLPBEParametersGenerator = new OpenSSLPBEParametersGenerator();
        openSSLPBEParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray);
        SecretKeySpec secretKeySpec = null;
        if (!string.equalsIgnoreCase("DESEDE")) {
            throw new IOException("unknown algorithm in writeObject");
        }
        int n = 24;
        secretKeySpec = new SecretKeySpec(((KeyParameter)openSSLPBEParametersGenerator.generateDerivedParameters(n * 8)).getKey(), string);
        byte[] byArray2 = null;
        if (object instanceof RSAPrivateCrtKey) {
            object3 = (RSAPrivateCrtKey)object;
            object2 = new RSAPrivateKeyStructure(object3.getModulus(), object3.getPublicExponent(), object3.getPrivateExponent(), object3.getPrimeP(), object3.getPrimeQ(), object3.getPrimeExponentP(), object3.getPrimeExponentQ(), object3.getCrtCoefficient());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(object2);
            aSN1OutputStream.close();
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        object3 = null;
        try {
            object2 = Cipher.getInstance("DESede/CBC/PKCS5Padding", "BC");
            ((Cipher)object2).init(1, (Key)secretKeySpec, new IvParameterSpec(byArray));
            object3 = ((Cipher)object2).doFinal(byArray2);
        }
        catch (Exception exception) {
            throw new IOException("exception using cipher: " + exception.toString());
        }
        this.write("-----BEGIN RSA PRIVATE KEY-----");
        this.newLine();
        this.write("Proc-Type: 4,ENCRYPTED");
        this.newLine();
        this.write("DEK-Info: DES-EDE3-CBC,");
        this.writeHexEncoded(byArray);
        this.newLine();
        this.newLine();
        this.writeEncoded((byte[])object3);
        this.write("-----END RSA PRIVATE KEY-----");
    }
}

