/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ElGamalKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class ElGamalEngine
implements AsymmetricBlockCipher {
    private ElGamalKeyParameters key;
    private SecureRandom random;
    private boolean forEncryption;
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private static BigInteger TWO = BigInteger.valueOf(2L);

    public int getInputBlockSize() {
        int n = this.key.getParameters().getP().bitLength();
        if (this.forEncryption) {
            if (n % 8 == 0) {
                return n / 8 - 1;
            }
            return n / 8;
        }
        return 2 * ((n - 1 + 7) / 8);
    }

    public int getOutputBlockSize() {
        int n = this.key.getParameters().getP().bitLength();
        if (this.forEncryption) {
            return 2 * ((n - 1 + 7) / 8);
        }
        return (n - 7) / 8;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.key = (ElGamalKeyParameters)parametersWithRandom.getParameters();
            this.random = parametersWithRandom.getRandom();
        } else {
            this.key = (ElGamalKeyParameters)cipherParameters;
            this.random = new SecureRandom();
        }
        this.forEncryption = bl;
    }

    public byte[] processBlock(byte[] byArray, int n, int n2) {
        byte[] byArray2;
        if (n2 > this.getInputBlockSize() + 1) {
            throw new DataLengthException("input too large for ElGamal cipher.\n");
        }
        if (n2 == this.getInputBlockSize() + 1 && (byArray[n] & 0x80) != 0) {
            throw new DataLengthException("input too large for ElGamal cipher.\n");
        }
        if (n != 0 || n2 != byArray.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        } else {
            byArray2 = byArray;
        }
        BigInteger bigInteger = this.key.getParameters().getG();
        BigInteger bigInteger2 = this.key.getParameters().getP();
        if (this.key instanceof ElGamalPrivateKeyParameters) {
            byte[] byArray3 = new byte[byArray2.length / 2];
            byte[] byArray4 = new byte[byArray2.length / 2];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
            System.arraycopy(byArray2, byArray3.length, byArray4, 0, byArray4.length);
            BigInteger bigInteger3 = new BigInteger(1, byArray3);
            BigInteger bigInteger4 = new BigInteger(1, byArray4);
            ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)this.key;
            BigInteger bigInteger5 = bigInteger3.modPow(bigInteger2.subtract(ONE).subtract(elGamalPrivateKeyParameters.getX()), bigInteger2).multiply(bigInteger4).mod(bigInteger2);
            byte[] byArray5 = bigInteger5.toByteArray();
            if (byArray5[0] != 0) {
                return byArray5;
            }
            byte[] byArray6 = new byte[byArray5.length - 1];
            System.arraycopy(byArray5, 1, byArray6, 0, byArray6.length);
            return byArray6;
        }
        ElGamalPublicKeyParameters elGamalPublicKeyParameters = (ElGamalPublicKeyParameters)this.key;
        BigInteger bigInteger6 = new BigInteger(1, byArray2);
        int n3 = bigInteger2.bitLength();
        BigInteger bigInteger7 = new BigInteger(n3, this.random);
        while (bigInteger7.equals(ZERO) || bigInteger7.compareTo(bigInteger2.subtract(TWO)) > 0) {
            bigInteger7 = new BigInteger(n3, this.random);
        }
        BigInteger bigInteger8 = bigInteger.modPow(bigInteger7, bigInteger2);
        BigInteger bigInteger9 = bigInteger6.multiply(elGamalPublicKeyParameters.getY().modPow(bigInteger7, bigInteger2)).mod(bigInteger2);
        byte[] byArray7 = bigInteger8.toByteArray();
        byte[] byArray8 = bigInteger9.toByteArray();
        byte[] byArray9 = new byte[this.getOutputBlockSize()];
        if (byArray7.length > byArray9.length / 2) {
            System.arraycopy(byArray7, 1, byArray9, byArray9.length / 2 - (byArray7.length - 1), byArray7.length - 1);
        } else {
            System.arraycopy(byArray7, 0, byArray9, byArray9.length / 2 - byArray7.length, byArray7.length);
        }
        if (byArray8.length > byArray9.length / 2) {
            System.arraycopy(byArray8, 1, byArray9, byArray9.length - (byArray8.length - 1), byArray8.length - 1);
        } else {
            System.arraycopy(byArray8, 0, byArray9, byArray9.length - byArray8.length, byArray8.length);
        }
        return byArray9;
    }
}

