/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.misc;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class IDEACBCPar
extends ASN1Encodable {
    ASN1OctetString iv;

    public IDEACBCPar(ASN1Sequence aSN1Sequence) {
        this.iv = aSN1Sequence.size() == 1 ? (ASN1OctetString)aSN1Sequence.getObjectAt(0) : null;
    }

    public IDEACBCPar(byte[] byArray) {
        this.iv = new DEROctetString(byArray);
    }

    public byte[] getIV() {
        if (this.iv != null) {
            return this.iv.getOctets();
        }
        return null;
    }

    public static IDEACBCPar getInstance(Object object) {
        if (object instanceof IDEACBCPar) {
            return (IDEACBCPar)object;
        }
        if (object instanceof ASN1Sequence) {
            return new IDEACBCPar((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in IDEACBCPar factory");
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.iv != null) {
            aSN1EncodableVector.add(this.iv);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

