/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xwing;

import org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMExtractor;
import org.bouncycastle.pqc.crypto.xwing.XWingKEMGenerator;
import org.bouncycastle.pqc.crypto.xwing.XWingPrivateKeyParameters;
import org.bouncycastle.util.Arrays;

public class XWingKEMExtractor
implements EncapsulatedSecretExtractor {
    private static final int MLKEM_CIPHERTEXT_SIZE = 1088;
    private final XWingPrivateKeyParameters key;
    private final MLKEMExtractor mlkemExtractor;

    public XWingKEMExtractor(XWingPrivateKeyParameters privParams) {
        this.key = privParams;
        this.mlkemExtractor = new MLKEMExtractor(this.key.getKyberPrivateKey());
    }

    public byte[] extractSecret(byte[] encapsulation) {
        byte[] ctM = Arrays.copyOfRange(encapsulation, 0, 1088);
        byte[] ctX = Arrays.copyOfRange(encapsulation, 1088, encapsulation.length);
        byte[] ssX = XWingKEMGenerator.computeSSX(new X25519PublicKeyParameters(ctX, 0), this.key.getXDHPrivateKey());
        byte[] kemSecret = XWingKEMGenerator.computeSharedSecret(this.key.getXDHPublicKey().getEncoded(), this.mlkemExtractor.extractSecret(ctM), ctX, ssX);
        Arrays.clear(ssX);
        return kemSecret;
    }

    public int getEncapsulationLength() {
        return this.mlkemExtractor.getEncapsulationLength() + 32;
    }
}

