/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.falcon;

import org.bouncycastle.pqc.crypto.falcon.FPREngine;
import org.bouncycastle.pqc.crypto.falcon.FalconRNG;
import org.bouncycastle.pqc.crypto.falcon.SamplerCtx;

class SamplerZ {
    SamplerZ() {
    }

    static int sample(SamplerCtx ctx, double mu, double iSigma) {
        return SamplerZ.sampler(ctx, mu, iSigma);
    }

    static int gaussian0_sampler(FalconRNG p) {
        int[] dist = new int[]{10745844, 3068844, 3741698, 5559083, 1580863, 8248194, 2260429, 13669192, 2736639, 708981, 4421575, 10046180, 169348, 7122675, 4136815, 30538, 13063405, 7650655, 4132, 14505003, 7826148, 417, 16768101, 11363290, 31, 8444042, 8086568, 1, 12844466, 265321, 0, 1232676, 13644283, 0, 38047, 9111839, 0, 870, 6138264, 0, 14, 12545723, 0, 0, 3104126, 0, 0, 28824, 0, 0, 198, 0, 0, 1};
        long lo = p.prng_get_u64();
        int hi = p.prng_get_u8() & 0xFF;
        int v0 = (int)lo & 0xFFFFFF;
        int v1 = (int)(lo >>> 24) & 0xFFFFFF;
        int v2 = (int)(lo >>> 48) | hi << 16;
        int z = 0;
        for (int u = 0; u < dist.length; u += 3) {
            int w0 = dist[u + 2];
            int w1 = dist[u + 1];
            int w2 = dist[u];
            int cc = v0 - w0 >>> 31;
            cc = v1 - w1 - cc >>> 31;
            cc = v2 - w2 - cc >>> 31;
            z += cc;
        }
        return z;
    }

    private static int BerExp(FalconRNG p, double x, double ccs) {
        int w;
        int s = (int)(x * 1.4426950408889634);
        double r = x - (double)s * 0.6931471805599453;
        int sw = s;
        sw ^= (sw ^ 0x3F) & -(63 - sw >>> 31);
        s = sw;
        long z = (FPREngine.fpr_expm_p63(r, ccs) << 1) - 1L >>> s;
        int i = 64;
        while ((w = (p.prng_get_u8() & 0xFF) - ((int)(z >>> (i -= 8)) & 0xFF)) == 0 && i > 0) {
        }
        return w >>> 31;
    }

    private static int sampler(SamplerCtx ctx, double mu, double isigma) {
        int z;
        int z0;
        SamplerCtx spc = ctx;
        int s = (int)FPREngine.fpr_floor(mu);
        double r = mu - (double)s;
        double dss = isigma * isigma * 0.5;
        double ccs = isigma * spc.sigma_min;
        do {
            z0 = SamplerZ.gaussian0_sampler(spc.p);
            int b = spc.p.prng_get_u8() & 0xFF & 1;
            z = b + ((b << 1) - 1) * z0;
            double x = (double)z - r;
            x = x * x * dss;
        } while (SamplerZ.BerExp(spc.p, x -= (double)(z0 * z0) * 0.15086504887537272, ccs) == 0);
        return s + z;
    }
}

