/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.threshold;

import java.io.IOException;
import org.bouncycastle.crypto.threshold.Polynomial;
import org.bouncycastle.crypto.threshold.SecretShare;
import org.bouncycastle.crypto.threshold.ShamirSecretSplitter;
import org.bouncycastle.crypto.threshold.ShamirSplitSecretShare;
import org.bouncycastle.crypto.threshold.SplitSecret;

public class ShamirSplitSecret
implements SplitSecret {
    private final ShamirSplitSecretShare[] secretShares;
    private final Polynomial poly;

    public ShamirSplitSecret(ShamirSecretSplitter.Algorithm algorithm, ShamirSecretSplitter.Mode mode, ShamirSplitSecretShare[] secretShares) {
        this.secretShares = secretShares;
        this.poly = Polynomial.newInstance(algorithm, mode);
    }

    ShamirSplitSecret(Polynomial poly, ShamirSplitSecretShare[] secretShares) {
        this.secretShares = secretShares;
        this.poly = poly;
    }

    public SecretShare[] getSecretShares() {
        return this.secretShares;
    }

    public ShamirSplitSecret multiple(int mul) throws IOException {
        for (int i = 0; i < this.secretShares.length; ++i) {
            byte[] ss = this.secretShares[i].getEncoded();
            for (int j = 0; j < ss.length; ++j) {
                ss[j] = this.poly.gfMul(ss[j] & 0xFF, mul);
            }
            this.secretShares[i] = new ShamirSplitSecretShare(ss, i + 1);
        }
        return this;
    }

    public ShamirSplitSecret divide(int div) throws IOException {
        for (int i = 0; i < this.secretShares.length; ++i) {
            byte[] ss = this.secretShares[i].getEncoded();
            for (int j = 0; j < ss.length; ++j) {
                ss[j] = this.poly.gfDiv(ss[j] & 0xFF, div);
            }
            this.secretShares[i] = new ShamirSplitSecretShare(ss, i + 1);
        }
        return this;
    }

    public byte[] getSecret() throws IOException {
        int n = this.secretShares.length;
        byte[] r = new byte[n];
        byte[] products = new byte[n - 1];
        byte[][] splits = new byte[n][this.secretShares[0].getEncoded().length];
        for (int i = 0; i < n; ++i) {
            splits[i] = this.secretShares[i].getEncoded();
            int tmp = 0;
            for (int j = 0; j < n; ++j) {
                if (j == i) continue;
                int n2 = tmp;
                tmp = (byte)(tmp + 1);
                products[n2] = this.poly.gfDiv(this.secretShares[j].r, this.secretShares[i].r ^ this.secretShares[j].r);
            }
            tmp = 1;
            for (int prdI = 0; prdI != products.length; ++prdI) {
                tmp = this.poly.gfMul(tmp & 0xFF, products[prdI] & 0xFF);
            }
            r[i] = tmp;
        }
        return this.poly.gfVecMul(r, splits);
    }
}

