/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.AsconBaseEngine;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Pack;

public class AsconAEAD128
extends AsconBaseEngine {
    public AsconAEAD128() {
        this.CRYPTO_KEYBYTES = 16;
        this.CRYPTO_ABYTES = 16;
        this.ASCON_AEAD_RATE = 16;
        this.ASCON_IV = 17594342703105L;
        this.algorithmName = "Ascon-AEAD128";
        this.nr = 8;
        this.m_bufferSizeDecrypt = this.ASCON_AEAD_RATE + this.CRYPTO_ABYTES;
        this.m_buf = new byte[this.m_bufferSizeDecrypt];
        this.dsep = Long.MIN_VALUE;
    }

    protected long pad(int i) {
        return 1L << (i << 3);
    }

    protected long loadBytes(byte[] in, int inOff) {
        return Pack.littleEndianToLong(in, inOff);
    }

    protected void setBytes(long n, byte[] bs, int off) {
        Pack.longToLittleEndian(n, bs, off);
    }

    protected void ascon_aeadinit() {
        this.x0 = this.ASCON_IV;
        this.x1 = this.K0;
        this.x2 = this.K1;
        this.x3 = this.N0;
        this.x4 = this.N1;
        this.p(12);
        this.x3 ^= this.K0;
        this.x4 ^= this.K1;
    }

    protected void processFinalAadBlock() {
        if (this.m_bufPos >= 8) {
            this.x0 ^= Pack.littleEndianToLong(this.m_buf, 0);
            this.x1 ^= Pack.littleEndianToLong(this.m_buf, 8) ^ this.pad(this.m_bufPos);
        } else {
            this.x0 ^= Pack.littleEndianToLong(this.m_buf, 0) ^ this.pad(this.m_bufPos);
        }
    }

    protected void processFinalDecrypt(byte[] input, int inLen, byte[] output, int outOff) {
        if (inLen >= 8) {
            long c0 = Pack.littleEndianToLong(input, 0);
            long c1 = Pack.littleEndianToLong(input, 8, inLen -= 8);
            Pack.longToLittleEndian(this.x0 ^ c0, output, outOff);
            Pack.longToLittleEndian(this.x1 ^ c1, output, outOff + 8, inLen);
            this.x0 = c0;
            this.x1 &= -(1L << (inLen << 3));
            this.x1 |= c1;
            this.x1 ^= this.pad(inLen);
        } else {
            if (inLen != 0) {
                long c0 = Pack.littleEndianToLong(input, 0, inLen);
                Pack.longToLittleEndian(this.x0 ^ c0, output, outOff, inLen);
                this.x0 &= -(1L << (inLen << 3));
                this.x0 |= c0;
            }
            this.x0 ^= this.pad(inLen);
        }
        this.finishData(DecFinal);
    }

    protected void processFinalEncrypt(byte[] input, int inLen, byte[] output, int outOff) {
        if (inLen >= 8) {
            this.x0 ^= Pack.littleEndianToLong(input, 0);
            this.x1 ^= Pack.littleEndianToLong(input, 8, inLen -= 8);
            Pack.longToLittleEndian(this.x0, output, outOff);
            Pack.longToLittleEndian(this.x1, output, outOff + 8);
            this.x1 ^= this.pad(inLen);
        } else {
            if (inLen != 0) {
                this.x0 ^= Pack.littleEndianToLong(input, 0, inLen);
                Pack.longToLittleEndian(this.x0, output, outOff, inLen);
            }
            this.x0 ^= this.pad(inLen);
        }
        this.finishData(EncFinal);
    }

    private void finishData(AsconBaseEngine.State nextState) {
        this.x2 ^= this.K0;
        this.x3 ^= this.K1;
        this.p(12);
        this.x3 ^= this.K0;
        this.x4 ^= this.K1;
        this.m_state = nextState;
    }

    /*
     * WARNING - void declaration
     */
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        void var4_5;
        void var3_4;
        byte[] npub;
        KeyParameter key;
        if (params instanceof AEADParameters) {
            AEADParameters aeadParameters = (AEADParameters)params;
            key = aeadParameters.getKey();
            npub = aeadParameters.getNonce();
            this.initialAssociatedText = aeadParameters.getAssociatedText();
            int macSizeBits = aeadParameters.getMacSize();
            if (macSizeBits != this.CRYPTO_ABYTES * 8) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + macSizeBits);
            }
        } else if (params instanceof ParametersWithIV) {
            ParametersWithIV withIV = (ParametersWithIV)params;
            key = (KeyParameter)withIV.getParameters();
            npub = withIV.getIV();
            this.initialAssociatedText = null;
        } else {
            throw new IllegalArgumentException("invalid parameters passed to Ascon");
        }
        if (var3_4 == null) {
            throw new IllegalArgumentException("Ascon Init parameters must include a key");
        }
        if (var4_5 == null || ((void)var4_5).length != this.CRYPTO_ABYTES) {
            throw new IllegalArgumentException("Ascon-AEAD-128 requires exactly " + this.CRYPTO_ABYTES + " bytes of IV");
        }
        byte[] k = var3_4.getKey();
        if (k.length != this.CRYPTO_KEYBYTES) {
            throw new IllegalArgumentException("Ascon-AEAD-128 key must be " + this.CRYPTO_KEYBYTES + " bytes long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, Utils.getPurpose(forEncryption)));
        this.K0 = Pack.littleEndianToLong(k, 0);
        this.K1 = Pack.littleEndianToLong(k, 8);
        this.N0 = Pack.littleEndianToLong((byte[])var4_5, 0);
        this.N1 = Pack.littleEndianToLong((byte[])var4_5, 8);
        this.m_state = forEncryption ? EncInit : DecInit;
        this.reset(true);
    }

    public String getAlgorithmVersion() {
        return "v1.3";
    }
}

