/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;

public class LiteralDataPacket
extends InputStreamPacket {
    int format;
    char[] fileName;
    long modDate;

    LiteralDataPacket(BCPGInputStream bCPGInputStream) throws IOException {
        super(bCPGInputStream);
        this.format = bCPGInputStream.read();
        int n = bCPGInputStream.read();
        this.fileName = new char[n];
        for (int i = 0; i != this.fileName.length; ++i) {
            this.fileName[i] = (char)bCPGInputStream.read();
        }
        this.modDate = (long)bCPGInputStream.read() << 24 | (long)(bCPGInputStream.read() << 16) | (long)(bCPGInputStream.read() << 8) | (long)bCPGInputStream.read();
    }

    public int getFormat() {
        return this.format;
    }

    public long getModificationTime() {
        return this.modDate * 1000L;
    }

    public String getFileName() {
        return new String(this.fileName);
    }

    public byte[] getRawFileName() {
        byte[] byArray = new byte[this.fileName.length];
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = (byte)this.fileName[i];
        }
        return byArray;
    }
}

