/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.OctetArrayBCPGKey;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserDataPacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersIndex;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.Util;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Arrays;

public class PGPPublicKey
implements PublicKeyAlgorithmTags {
    private static final int[] MASTER_KEY_CERTIFICATION_TYPES = new int[]{19, 18, 17, 16, 31};
    PublicKeyPacket publicPk;
    TrustPacket trustPk;
    List<PGPSignature> keySigs = new ArrayList<PGPSignature>();
    List<UserDataPacket> ids = new ArrayList<UserDataPacket>();
    List<TrustPacket> idTrusts = new ArrayList<TrustPacket>();
    List<List<PGPSignature>> idSigs = new ArrayList<List<PGPSignature>>();
    List<PGPSignature> subSigs = null;
    private KeyIdentifier keyIdentifier;
    private int keyStrength;

    private void init(KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        BCPGKey key = this.publicPk.getKey();
        byte[] fingerprint = fingerPrintCalculator.calculateFingerprint(this.publicPk);
        long keyID = PublicKeyPacket.getKeyID(this.publicPk, fingerprint);
        this.keyIdentifier = new KeyIdentifier(fingerprint, keyID);
        if (this.publicPk.getVersion() <= 3) {
            RSAPublicBCPGKey rK = (RSAPublicBCPGKey)key;
            this.keyStrength = rK.getModulus().bitLength();
        } else if (this.publicPk.getVersion() >= 4) {
            if (key instanceof RSAPublicBCPGKey) {
                this.keyStrength = ((RSAPublicBCPGKey)key).getModulus().bitLength();
            } else if (key instanceof DSAPublicBCPGKey) {
                this.keyStrength = ((DSAPublicBCPGKey)key).getP().bitLength();
            } else if (key instanceof ElGamalPublicBCPGKey) {
                this.keyStrength = ((ElGamalPublicBCPGKey)key).getP().bitLength();
            } else if (key instanceof ECPublicBCPGKey) {
                NamedECDomainParameters ecParameters;
                ASN1ObjectIdentifier curveOID = ((ECPublicBCPGKey)key).getCurveOID();
                this.keyStrength = curveOID.equals((ASN1Primitive)GNUObjectIdentifiers.Ed25519) || curveOID.equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519) ? 256 : (curveOID.equals((ASN1Primitive)EdECObjectIdentifiers.id_X448) ? 448 : (curveOID.equals((ASN1Primitive)EdECObjectIdentifiers.id_Ed448) ? 456 : ((ecParameters = ECDomainParametersIndex.lookupDomainParameters((ASN1ObjectIdentifier)curveOID)) != null ? ecParameters.getCurve().getFieldSize() : -1)));
            } else if (key instanceof OctetArrayBCPGKey) {
                this.keyStrength = key.getEncoded().length * 8;
            }
        }
    }

    public PGPPublicKey(PublicKeyPacket publicKeyPacket, KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        this.publicPk = publicKeyPacket;
        this.ids = new ArrayList<UserDataPacket>();
        this.idSigs = new ArrayList<List<PGPSignature>>();
        this.init(fingerPrintCalculator);
    }

    PGPPublicKey(PublicKeyPacket publicPk, TrustPacket trustPk, List<PGPSignature> sigs, KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        this.publicPk = publicPk;
        this.trustPk = trustPk;
        this.subSigs = sigs;
        this.init(fingerPrintCalculator);
    }

    PGPPublicKey(PGPPublicKey key, TrustPacket trust, List<PGPSignature> subSigs) {
        this.publicPk = key.publicPk;
        this.trustPk = trust;
        this.subSigs = subSigs;
        this.keyStrength = key.keyStrength;
        this.keyIdentifier = key.keyIdentifier;
    }

    PGPPublicKey(PGPPublicKey pubKey) {
        this.publicPk = pubKey.publicPk;
        this.keySigs = new ArrayList<PGPSignature>(pubKey.keySigs);
        this.ids = new ArrayList<UserDataPacket>(pubKey.ids);
        this.idTrusts = new ArrayList<TrustPacket>(pubKey.idTrusts);
        this.idSigs = new ArrayList<List<PGPSignature>>(pubKey.idSigs.size());
        for (int i = 0; i != pubKey.idSigs.size(); ++i) {
            this.idSigs.add(new ArrayList<PGPSignature>(pubKey.idSigs.get(i)));
        }
        if (pubKey.subSigs != null) {
            this.subSigs = new ArrayList<PGPSignature>(pubKey.subSigs.size());
            this.subSigs.addAll(pubKey.subSigs);
        }
        this.keyStrength = pubKey.keyStrength;
        this.keyIdentifier = pubKey.keyIdentifier;
    }

    PGPPublicKey(PublicKeyPacket publicPk, TrustPacket trustPk, List<PGPSignature> keySigs, List<UserDataPacket> ids, List<TrustPacket> idTrusts, List<List<PGPSignature>> idSigs, KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        this.publicPk = publicPk;
        this.trustPk = trustPk;
        this.keySigs = keySigs;
        this.ids = ids;
        this.idTrusts = idTrusts;
        this.idSigs = idSigs;
        this.init(fingerPrintCalculator);
    }

    PGPPublicKey(PGPPublicKey original, TrustPacket trustPk, List<PGPSignature> keySigs, List<UserDataPacket> ids, List<TrustPacket> idTrusts, List<List<PGPSignature>> idSigs) throws PGPException {
        this.publicPk = original.publicPk;
        this.keyStrength = original.keyStrength;
        this.keyIdentifier = original.keyIdentifier;
        this.trustPk = trustPk;
        this.keySigs = keySigs;
        this.ids = ids;
        this.idTrusts = idTrusts;
        this.idSigs = idSigs;
    }

    public int getVersion() {
        return this.publicPk.getVersion();
    }

    public Date getCreationTime() {
        return this.publicPk.getTime();
    }

    public int getValidDays() {
        if (this.publicPk.getVersion() > 3) {
            long delta = this.getValidSeconds() % 86400L;
            int days = (int)(this.getValidSeconds() / 86400L);
            if (delta > 0L && days == 0) {
                return 1;
            }
            return days;
        }
        return this.publicPk.getValidDays();
    }

    public byte[] getTrustData() {
        if (this.trustPk == null) {
            return null;
        }
        return Arrays.clone((byte[])this.trustPk.getLevelAndTrustAmount());
    }

    public long getValidSeconds() {
        if (this.publicPk.getVersion() > 3) {
            if (this.isMasterKey()) {
                for (int i = 0; i != MASTER_KEY_CERTIFICATION_TYPES.length; ++i) {
                    long seconds = this.getExpirationTimeFromSig(true, MASTER_KEY_CERTIFICATION_TYPES[i]);
                    if (seconds < 0L) continue;
                    return seconds;
                }
            } else {
                long seconds = this.getExpirationTimeFromSig(false, 24);
                if (seconds >= 0L) {
                    return seconds;
                }
                seconds = this.getExpirationTimeFromSig(false, 31);
                if (seconds >= 0L) {
                    return seconds;
                }
            }
            return 0L;
        }
        return (long)this.publicPk.getValidDays() * 24L * 60L * 60L;
    }

    private long getExpirationTimeFromSig(boolean selfSigned, int signatureType) {
        Iterator<PGPSignature> signatures = this.getSignaturesOfType(signatureType);
        long expiryTime = -1L;
        long lastDate = -1L;
        while (signatures.hasNext()) {
            PGPSignatureSubpacketVector hashed;
            PGPSignature sig = signatures.next();
            if (selfSigned && sig.getKeyID() != this.getKeyID() || (hashed = sig.getHashedSubPackets()) == null || !hashed.hasSubpacket(9)) continue;
            long current = hashed.getKeyExpirationTime();
            if (sig.getKeyID() == this.getKeyID()) {
                if (sig.getCreationTime().getTime() <= lastDate) continue;
                lastDate = sig.getCreationTime().getTime();
                expiryTime = current;
                continue;
            }
            if (current != 0L && current <= expiryTime) continue;
            expiryTime = current;
        }
        return expiryTime;
    }

    public long getKeyID() {
        return this.keyIdentifier.getKeyId();
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public byte[] getFingerprint() {
        return this.keyIdentifier.getFingerprint();
    }

    public boolean hasFingerprint(byte[] fingerprint) {
        return this.keyIdentifier.hasFingerprint(fingerprint);
    }

    public boolean isEncryptionKey() {
        int algorithm = this.publicPk.getAlgorithm();
        return algorithm == 1 || algorithm == 2 || algorithm == 16 || algorithm == 20 || algorithm == 21 || algorithm == 18 || algorithm == 26 || algorithm == 25;
    }

    public boolean isMasterKey() {
        return !(this.publicPk instanceof PublicSubkeyPacket) && (!this.isEncryptionKey() || this.publicPk.getAlgorithm() == 1);
    }

    public int getAlgorithm() {
        return this.publicPk.getAlgorithm();
    }

    public int getBitStrength() {
        return this.keyStrength;
    }

    public Iterator<String> getUserIDs() {
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof UserIDPacket)) continue;
            temp.add(((UserIDPacket)this.ids.get(i)).getID());
        }
        return temp.iterator();
    }

    public Iterator<byte[]> getRawUserIDs() {
        ArrayList<byte[]> temp = new ArrayList<byte[]>();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof UserIDPacket)) continue;
            temp.add(((UserIDPacket)this.ids.get(i)).getRawID());
        }
        return temp.iterator();
    }

    public Iterator<PGPUserAttributeSubpacketVector> getUserAttributes() {
        ArrayList<PGPUserAttributeSubpacketVector> temp = new ArrayList<PGPUserAttributeSubpacketVector>();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof PGPUserAttributeSubpacketVector)) continue;
            temp.add((PGPUserAttributeSubpacketVector)this.ids.get(i));
        }
        return temp.iterator();
    }

    public Iterator<PGPSignature> getSignaturesForID(String id) {
        return this.getSignaturesForID(new UserIDPacket(id));
    }

    public Iterator<PGPSignature> getSignaturesForID(byte[] rawID) {
        return this.getSignaturesForID(new UserIDPacket(rawID));
    }

    public Iterator<PGPSignature> getSignaturesForKeyID(long keyID) {
        ArrayList<PGPSignature> sigs = new ArrayList<PGPSignature>();
        Iterator<PGPSignature> it = this.getSignatures();
        while (it.hasNext()) {
            PGPSignature sig = it.next();
            if (sig.getKeyID() != keyID) continue;
            sigs.add(sig);
        }
        return sigs.iterator();
    }

    public Iterator<PGPSignature> getSignaturesForKey(KeyIdentifier identifier) {
        ArrayList<PGPSignature> sigs = new ArrayList<PGPSignature>();
        Iterator<PGPSignature> it = this.getSignatures();
        while (it.hasNext()) {
            PGPSignature sig = it.next();
            if (!identifier.isPresentIn(sig.getKeyIdentifiers())) continue;
            sigs.add(sig);
        }
        return sigs.iterator();
    }

    private Iterator<PGPSignature> getSignaturesForID(UserIDPacket id) {
        ArrayList<PGPSignature> signatures = new ArrayList<PGPSignature>();
        boolean userIdFound = false;
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!id.equals(this.ids.get(i))) continue;
            userIdFound = true;
            signatures.addAll(this.idSigs.get(i));
        }
        return userIdFound ? signatures.iterator() : null;
    }

    public Iterator<PGPSignature> getSignaturesForUserAttribute(PGPUserAttributeSubpacketVector userAttributes) {
        ArrayList<PGPSignature> signatures = new ArrayList<PGPSignature>();
        boolean attributeFound = false;
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!userAttributes.equals(this.ids.get(i))) continue;
            attributeFound = true;
            signatures.addAll(this.idSigs.get(i));
        }
        return attributeFound ? signatures.iterator() : null;
    }

    public Iterator<PGPSignature> getSignaturesOfType(int signatureType) {
        ArrayList<PGPSignature> l = new ArrayList<PGPSignature>();
        Iterator<PGPSignature> it = this.getSignatures();
        while (it.hasNext()) {
            PGPSignature sig = it.next();
            if (sig.getSignatureType() != signatureType) continue;
            l.add(sig);
        }
        return l.iterator();
    }

    public Iterator<PGPSignature> getSignatures() {
        if (this.subSigs == null) {
            ArrayList<PGPSignature> sigs = new ArrayList<PGPSignature>(this.keySigs);
            for (int i = 0; i != this.idSigs.size(); ++i) {
                sigs.addAll(this.idSigs.get(i));
            }
            return sigs.iterator();
        }
        return this.subSigs.iterator();
    }

    public Iterator<PGPSignature> getKeySignatures() {
        if (this.subSigs == null) {
            ArrayList<PGPSignature> sigs = new ArrayList<PGPSignature>(this.keySigs);
            return sigs.iterator();
        }
        return this.subSigs.iterator();
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.publicPk;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut, false);
        return bOut.toByteArray();
    }

    public byte[] getEncoded(boolean forTransfer) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut, forTransfer);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        this.encode(outStream, false);
    }

    public void encode(OutputStream outStream, boolean forTransfer) throws IOException {
        BCPGOutputStream out = BCPGOutputStream.wrap(outStream);
        out.writePacket(this.publicPk);
        if (!forTransfer && this.trustPk != null) {
            out.writePacket(this.trustPk);
        }
        if (this.subSigs == null) {
            Util.encodePGPSignatures(out, this.keySigs, false);
            for (int i = 0; i != this.ids.size(); ++i) {
                if (this.ids.get(i) instanceof UserIDPacket) {
                    UserIDPacket id = (UserIDPacket)this.ids.get(i);
                    out.writePacket(id);
                } else {
                    PGPUserAttributeSubpacketVector v = (PGPUserAttributeSubpacketVector)this.ids.get(i);
                    out.writePacket(new UserAttributePacket(v.toSubpacketArray()));
                }
                if (!forTransfer && this.idTrusts.get(i) != null) {
                    out.writePacket(this.idTrusts.get(i));
                }
                List<PGPSignature> sigs = this.idSigs.get(i);
                Util.encodePGPSignatures(out, sigs, forTransfer);
            }
        } else {
            Util.encodePGPSignatures(out, this.subSigs, forTransfer);
        }
    }

    public boolean isRevoked() {
        return this.hasRevocation();
    }

    public boolean hasRevocation() {
        int ns = 0;
        boolean revoked = false;
        if (this.isMasterKey()) {
            while (!revoked && ns < this.keySigs.size()) {
                if (this.keySigs.get(ns++).getSignatureType() != 32) continue;
                revoked = true;
            }
        } else {
            while (!revoked && ns < this.subSigs.size()) {
                if (this.subSigs.get(ns++).getSignatureType() != 40) continue;
                revoked = true;
            }
        }
        return revoked;
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, byte[] rawID, PGPSignature certification) {
        return PGPPublicKey.addCert(key, new UserIDPacket(rawID), certification);
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, String id, PGPSignature certification) {
        return PGPPublicKey.addCert(key, new UserIDPacket(id), certification);
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, PGPUserAttributeSubpacketVector userAttributes, PGPSignature certification) {
        return PGPPublicKey.addCert(key, userAttributes, certification);
    }

    private static PGPPublicKey addCert(PGPPublicKey key, UserDataPacket id, PGPSignature certification) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        List<PGPSignature> sigList = null;
        for (int i = 0; i != returnKey.ids.size(); ++i) {
            if (!id.equals(returnKey.ids.get(i))) continue;
            sigList = returnKey.idSigs.get(i);
        }
        if (sigList != null) {
            sigList.add(certification);
        } else {
            sigList = new ArrayList<PGPSignature>();
            sigList.add(certification);
            returnKey.ids.add(id);
            returnKey.idTrusts.add(null);
            returnKey.idSigs.add(sigList);
        }
        return returnKey;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, PGPUserAttributeSubpacketVector userAttributes) {
        return PGPPublicKey.removeCert(key, userAttributes);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, String id) {
        return PGPPublicKey.removeCert(key, new UserIDPacket(id));
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, byte[] rawID) {
        return PGPPublicKey.removeCert(key, new UserIDPacket(rawID));
    }

    private static PGPPublicKey removeCert(PGPPublicKey key, UserDataPacket id) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        boolean found = false;
        for (int i = returnKey.ids.size() - 1; i >= 0; --i) {
            if (!id.equals(returnKey.ids.get(i))) continue;
            found = true;
            returnKey.ids.remove(i);
            returnKey.idTrusts.remove(i);
            returnKey.idSigs.remove(i);
        }
        return found ? returnKey : null;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, byte[] id, PGPSignature certification) {
        return PGPPublicKey.removeCert(key, new UserIDPacket(id), certification);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, String id, PGPSignature certification) {
        return PGPPublicKey.removeCert(key, new UserIDPacket(id), certification);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, PGPUserAttributeSubpacketVector userAttributes, PGPSignature certification) {
        return PGPPublicKey.removeCert(key, userAttributes, certification);
    }

    private static PGPPublicKey removeCert(PGPPublicKey key, UserDataPacket id, PGPSignature certification) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        boolean found = false;
        for (int i = 0; i < returnKey.ids.size(); ++i) {
            if (!id.equals(returnKey.ids.get(i))) continue;
            found |= returnKey.idSigs.get(i).remove(certification);
        }
        return found ? returnKey : null;
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, PGPSignature certification) {
        if (key.isMasterKey()) {
            if (certification.getSignatureType() == 40) {
                throw new IllegalArgumentException("signature type incorrect for master key revocation.");
            }
        } else if (certification.getSignatureType() == 32) {
            throw new IllegalArgumentException("signature type incorrect for sub-key revocation.");
        }
        PGPPublicKey returnKey = new PGPPublicKey(key);
        List<PGPSignature> sigs = returnKey.subSigs != null ? returnKey.subSigs : returnKey.keySigs;
        sigs.add(certification);
        return returnKey;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, PGPSignature certification) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        List<PGPSignature> sigs = returnKey.subSigs != null ? returnKey.subSigs : returnKey.keySigs;
        boolean found = sigs.remove(certification);
        for (List<PGPSignature> idSigs : returnKey.idSigs) {
            found |= idSigs.remove(certification);
        }
        return found ? returnKey : null;
    }

    public static PGPPublicKey join(PGPPublicKey key, PGPPublicKey copy, boolean joinTrustPackets, boolean allowSubkeySigsOnNonSubkey) throws PGPException {
        ArrayList<PGPSignature> subSigs;
        if (key.getKeyID() != copy.getKeyID()) {
            throw new IllegalArgumentException("Key-ID mismatch.");
        }
        TrustPacket trustPk = key.trustPk;
        ArrayList<PGPSignature> keySigs = new ArrayList<PGPSignature>(key.keySigs);
        ArrayList<UserDataPacket> ids = new ArrayList<UserDataPacket>(key.ids);
        ArrayList<TrustPacket> idTrusts = new ArrayList<TrustPacket>(key.idTrusts);
        ArrayList<List<PGPSignature>> idSigs = new ArrayList<List<PGPSignature>>(key.idSigs);
        ArrayList<PGPSignature> arrayList = subSigs = key.subSigs == null ? null : new ArrayList<PGPSignature>(key.subSigs);
        if (joinTrustPackets && copy.trustPk != null) {
            trustPk = copy.trustPk;
        }
        PGPPublicKey.joinPgpSignatureList(copy.keySigs, keySigs, true, true);
        for (int idIdx = 0; idIdx < copy.ids.size(); ++idIdx) {
            TrustPacket existingTrust;
            UserDataPacket copyId = copy.ids.get(idIdx);
            ArrayList<PGPSignature> copyIdSigs = new ArrayList<PGPSignature>(copy.idSigs.get(idIdx));
            TrustPacket copyTrust = copy.idTrusts.get(idIdx);
            int existingIdIndex = -1;
            for (int i = 0; i < ids.size(); ++i) {
                UserDataPacket existingId = (UserDataPacket)ids.get(i);
                if (!existingId.equals(copyId)) continue;
                existingIdIndex = i;
                break;
            }
            if (existingIdIndex == -1) {
                ids.add(copyId);
                idSigs.add(copyIdSigs);
                idTrusts.add(joinTrustPackets ? copyTrust : null);
                continue;
            }
            if (joinTrustPackets && copyTrust != null && ((existingTrust = (TrustPacket)idTrusts.get(existingIdIndex)) == null || Arrays.areEqual((byte[])copyTrust.getLevelAndTrustAmount(), (byte[])existingTrust.getLevelAndTrustAmount()))) {
                idTrusts.set(existingIdIndex, copyTrust);
            }
            List existingIdSigs = (List)idSigs.get(existingIdIndex);
            PGPPublicKey.joinPgpSignatureList(copyIdSigs, existingIdSigs, false, true);
        }
        if (copy.subSigs != null) {
            if (subSigs == null && allowSubkeySigsOnNonSubkey) {
                subSigs = new ArrayList<PGPSignature>(copy.subSigs);
            } else {
                PGPPublicKey.joinPgpSignatureList(copy.subSigs, subSigs, false, subSigs != null);
            }
        }
        PGPPublicKey merged = new PGPPublicKey(key, trustPk, keySigs, ids, idTrusts, idSigs);
        merged.subSigs = subSigs;
        return merged;
    }

    private static void joinPgpSignatureList(List<PGPSignature> source, List<PGPSignature> rlt, boolean needBreak, boolean isNotNull) throws PGPException {
        for (PGPSignature copySubSig : source) {
            boolean found = false;
            for (int i = 0; isNotNull && i < rlt.size(); ++i) {
                PGPSignature existingSubSig = rlt.get(i);
                if (existingSubSig.getVersion() != copySubSig.getVersion() || !PGPSignature.isSignatureEncodingEqual(existingSubSig, copySubSig)) continue;
                found = true;
                existingSubSig = PGPSignature.join(existingSubSig, copySubSig);
                rlt.set(i, existingSubSig);
                break;
            }
            if (found && needBreak) break;
            if (found || !isNotNull) continue;
            rlt.add(copySubSig);
        }
    }
}

