/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPAEADDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import org.bouncycastle.util.Arrays;

public class BcPGPDataEncryptorBuilder
implements PGPDataEncryptorBuilder {
    private SecureRandom random;
    private boolean withIntegrityPacket = true;
    private int encAlgorithm;
    private boolean isV5StyleAEAD = true;
    private int aeadAlgorithm = -1;
    private int chunkSize;

    public BcPGPDataEncryptorBuilder(int encAlgorithm) {
        this.encAlgorithm = encAlgorithm;
        if (encAlgorithm == 0) {
            throw new IllegalArgumentException("null cipher specified");
        }
    }

    public PGPDataEncryptorBuilder setWithIntegrityPacket(boolean withIntegrityPacket) {
        this.withIntegrityPacket = withIntegrityPacket;
        return this;
    }

    public PGPDataEncryptorBuilder setUseV5AEAD() {
        this.isV5StyleAEAD = true;
        return this;
    }

    public PGPDataEncryptorBuilder setUseV6AEAD() {
        this.isV5StyleAEAD = false;
        return this;
    }

    public PGPDataEncryptorBuilder setWithAEAD(int aeadAlgorithm, int chunkSize) {
        if (this.encAlgorithm != 7 && this.encAlgorithm != 8 && this.encAlgorithm != 9 && this.encAlgorithm != 11 && this.encAlgorithm != 12 && this.encAlgorithm != 13) {
            throw new IllegalStateException("AEAD algorithms can only be used with AES and Camellia");
        }
        if (chunkSize < 6) {
            throw new IllegalArgumentException("minimum chunkSize is 6");
        }
        this.aeadAlgorithm = aeadAlgorithm;
        this.chunkSize = chunkSize - 6;
        return this;
    }

    public BcPGPDataEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public int getAlgorithm() {
        return this.encAlgorithm;
    }

    public int getAeadAlgorithm() {
        return this.aeadAlgorithm;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public boolean isV5StyleAEAD() {
        return this.isV5StyleAEAD;
    }

    public SecureRandom getSecureRandom() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return this.random;
    }

    public PGPDataEncryptor build(byte[] keyBytes) throws PGPException {
        if (this.aeadAlgorithm > 0) {
            return new MyAeadDataEncryptor(keyBytes);
        }
        return new MyPGPDataEncryptor(keyBytes);
    }

    private class MyAeadDataEncryptor
    implements PGPAEADDataEncryptor {
        private final boolean isV5StyleAEAD;
        private final AEADBlockCipher c;
        private final byte[] keyBytes;
        private final byte[] iv;

        MyAeadDataEncryptor(byte[] keyBytes) throws PGPException {
            boolean bl = this.isV5StyleAEAD = keyBytes.length == SymmetricKeyUtils.getKeyLengthInOctets(BcPGPDataEncryptorBuilder.this.encAlgorithm);
            if (this.isV5StyleAEAD) {
                this.keyBytes = keyBytes;
                this.iv = new byte[AEADUtils.getIVLength((byte)BcPGPDataEncryptorBuilder.this.aeadAlgorithm)];
                BcPGPDataEncryptorBuilder.this.getSecureRandom().nextBytes(this.iv);
            } else {
                byte[][] keyAndIv = AEADUtils.splitMessageKeyAndIv(keyBytes, BcPGPDataEncryptorBuilder.this.encAlgorithm, BcPGPDataEncryptorBuilder.this.aeadAlgorithm);
                this.keyBytes = keyAndIv[0];
                this.iv = keyAndIv[1];
            }
            this.c = BcAEADUtil.createAEADCipher(BcPGPDataEncryptorBuilder.this.encAlgorithm, BcPGPDataEncryptorBuilder.this.aeadAlgorithm);
        }

        public OutputStream getOutputStream(OutputStream out) {
            try {
                return new BcAEADUtil.PGPAeadOutputStream(this.isV5StyleAEAD, out, this.c, new KeyParameter(this.keyBytes), this.iv, BcPGPDataEncryptorBuilder.this.encAlgorithm, BcPGPDataEncryptorBuilder.this.aeadAlgorithm, BcPGPDataEncryptorBuilder.this.chunkSize);
            }
            catch (Exception e) {
                throw new IllegalStateException("unable to process stream: " + e.getMessage());
            }
        }

        public PGPDigestCalculator getIntegrityCalculator() {
            return null;
        }

        public int getBlockSize() {
            return this.c.getUnderlyingCipher().getBlockSize();
        }

        public int getAEADAlgorithm() {
            return BcPGPDataEncryptorBuilder.this.aeadAlgorithm;
        }

        public int getChunkSize() {
            return BcPGPDataEncryptorBuilder.this.chunkSize;
        }

        public byte[] getIV() {
            return Arrays.clone((byte[])this.iv);
        }
    }

    private class MyPGPDataEncryptor
    implements PGPDataEncryptor {
        private final BufferedBlockCipher c;

        MyPGPDataEncryptor(byte[] keyBytes) throws PGPException {
            BlockCipher engine = BcImplProvider.createBlockCipher(BcPGPDataEncryptorBuilder.this.encAlgorithm);
            try {
                this.c = BcUtil.createStreamCipher(true, engine, BcPGPDataEncryptorBuilder.this.withIntegrityPacket, keyBytes);
            }
            catch (IllegalArgumentException e) {
                throw new PGPException("invalid parameters: " + e.getMessage(), e);
            }
        }

        public OutputStream getOutputStream(OutputStream out) {
            return new CipherOutputStream(out, this.c);
        }

        public PGPDigestCalculator getIntegrityCalculator() {
            if (BcPGPDataEncryptorBuilder.this.withIntegrityPacket) {
                return new SHA1PGPDigestCalculator();
            }
            return null;
        }

        public int getBlockSize() {
            return this.c.getBlockSize();
        }
    }
}

