/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.security.SecureRandom;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPUtil;
import org.bouncycastle.util.Arrays;

public abstract class PBEKeyEncryptionMethodGenerator
implements PGPKeyEncryptionMethodGenerator {
    private char[] passPhrase;
    private PGPDigestCalculator s2kDigestCalculator;
    private S2K s2k;
    private SecureRandom random;
    private int s2kCount;
    private int wrapAlg = -1;

    protected PBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator) {
        this(passPhrase, s2kDigestCalculator, 96);
    }

    protected PBEKeyEncryptionMethodGenerator(char[] passPhrase, S2K.Argon2Params params) {
        this.passPhrase = passPhrase;
        this.s2k = new S2K(params);
    }

    protected PBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator, int s2kCount) {
        this.passPhrase = passPhrase;
        this.s2kDigestCalculator = s2kDigestCalculator;
        if (s2kCount < 0 || s2kCount > 255) {
            throw new IllegalArgumentException("s2kCount value outside of range 0 to 255.");
        }
        this.s2kCount = s2kCount;
    }

    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public PBEKeyEncryptionMethodGenerator setSessionKeyWrapperAlgorithm(int wrapAlg) {
        this.wrapAlg = wrapAlg;
        return this;
    }

    public int getSessionKeyWrapperAlgorithm(int defaultWrapAlg) {
        if (this.wrapAlg < 0) {
            return defaultWrapAlg;
        }
        return this.wrapAlg;
    }

    public byte[] getKey(int encAlgorithm) throws PGPException {
        if (this.s2k == null) {
            byte[] iv = new byte[8];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            this.s2k = new S2K(this.s2kDigestCalculator.getAlgorithm(), iv, this.s2kCount);
        }
        return PGPUtil.makeKeyFromPassPhrase(this.s2kDigestCalculator, encAlgorithm, this.s2k, this.passPhrase);
    }

    public ContainedPacket generate(PGPDataEncryptorBuilder dataEncryptorBuilder, byte[] sessionKey) throws PGPException {
        int kekAlgorithm = this.getSessionKeyWrapperAlgorithm(dataEncryptorBuilder.getAlgorithm());
        if (dataEncryptorBuilder.getAeadAlgorithm() <= 0) {
            if (sessionKey == null) {
                return SymmetricKeyEncSessionPacket.createV4Packet(kekAlgorithm, this.s2k, null);
            }
            byte[] key = this.getKey(kekAlgorithm);
            return SymmetricKeyEncSessionPacket.createV4Packet(kekAlgorithm, this.s2k, this.encryptSessionInfo(kekAlgorithm, key, Arrays.prepend((byte[])sessionKey, (byte)((byte)dataEncryptorBuilder.getAlgorithm()))));
        }
        int aeadAlgorithm = dataEncryptorBuilder.getAeadAlgorithm();
        int version = dataEncryptorBuilder.isV5StyleAEAD() ? 5 : 6;
        byte[] ikm = this.getKey(kekAlgorithm);
        byte[] info = new byte[]{-61, (byte)version, (byte)kekAlgorithm, (byte)aeadAlgorithm};
        if (version == 6) {
            ikm = this.generateV6KEK(kekAlgorithm, ikm, info);
        }
        byte[] iv = new byte[AEADUtils.getIVLength(aeadAlgorithm)];
        this.random.nextBytes(iv);
        int tagLen = AEADUtils.getAuthTagLength(aeadAlgorithm);
        byte[] eskAndTag = this.getEskAndTag(kekAlgorithm, aeadAlgorithm, sessionKey, ikm, iv, info);
        byte[] esk = Arrays.copyOfRange((byte[])eskAndTag, (int)0, (int)(eskAndTag.length - tagLen));
        byte[] tag = Arrays.copyOfRange((byte[])eskAndTag, (int)esk.length, (int)eskAndTag.length);
        if (version == 5) {
            return SymmetricKeyEncSessionPacket.createV5Packet(kekAlgorithm, aeadAlgorithm, iv, this.s2k, esk, tag);
        }
        return SymmetricKeyEncSessionPacket.createV6Packet(kekAlgorithm, aeadAlgorithm, iv, this.s2k, esk, tag);
    }

    protected abstract byte[] encryptSessionInfo(int var1, byte[] var2, byte[] var3) throws PGPException;

    protected abstract byte[] getEskAndTag(int var1, int var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6) throws PGPException;

    protected abstract byte[] generateV6KEK(int var1, byte[] var2, byte[] var3) throws PGPException;
}

