package org.bouncycastle.crypto;

/**
 * Interface describing a Key Derivation Function (KDF).
 *
 * @param <T> the type of the parameters used to initialise the calculator.
 */
public interface KDFCalculator<T extends Parameters>
{
    /**
     * Return the parameters for this KDF calculator.
     *
     * @return the KDF calculator's parameters.
     */
    T getParameters();

    /**
     * Generate out worth of bytes into the out array.
     *
     * @param out the target array for the bytes generated.
     */
    void generateBytes(byte[] out);

    /**
     * Generate len worth of bytes and place them in out starting at
     * the offset outOff.
     *
     * @param out the target array for the bytes generated.
     * @param outOff the offset to start writing the generated bytes at.
     * @param len the number of bytes to generate.
     */
    void generateBytes(byte[] out, int outOff, int len);
}
