/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.tracker;

import boofcv.gui.feature.VisualizeFeatures;
import boofcv.gui.feature.VisualizeShapes;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import georegression.struct.shapes.RectangleLength2D_I32;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class TrackerObjectQuadPanel
extends JPanel
implements MouseListener {
    boolean selectMode = true;
    int numSelected = 0;
    Quadrilateral_F64 quad = new Quadrilateral_F64();
    boolean targetVisible;
    Listener listener;
    BufferedImage bg;

    public TrackerObjectQuadPanel(Listener listener) {
        super(new BorderLayout());
        this.listener = listener;
        if (listener != null) {
            this.addMouseListener(this);
            this.grabFocus();
        }
    }

    public synchronized void setBackGround(BufferedImage image) {
        if (this.bg == null || this.bg.getWidth() != image.getWidth() || this.bg.getHeight() != image.getHeight()) {
            this.bg = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        }
        this.bg.createGraphics().drawImage((Image)image, 0, 0, null);
    }

    public synchronized void enterSelectMode() {
        this.selectMode = true;
        this.numSelected = 0;
        this.repaint();
    }

    public synchronized void setTarget(Quadrilateral_F64 quad, boolean visible) {
        if (quad != null) {
            this.quad.set(quad);
        }
        this.selectMode = false;
        this.targetVisible = visible;
        this.repaint();
    }

    public synchronized void setTarget(RectangleLength2D_I32 rect, boolean visible) {
        if (this.quad != null) {
            UtilPolygons2D_F64.convert((RectangleLength2D_I32)rect, (Quadrilateral_F64)this.quad);
        }
        this.selectMode = false;
        this.targetVisible = visible;
        this.repaint();
    }

    @Override
    protected synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage((Image)this.bg, 0, 0, null);
        g2.setStroke(new BasicStroke(5.0f));
        g2.setColor(Color.gray);
        if (this.selectMode) {
            if (this.numSelected == 1) {
                this.drawCorner(g2, this.quad.a, Color.RED);
            } else if (this.numSelected == 2) {
                this.drawLine(g2, this.quad.a, this.quad.b);
                this.drawCorner(g2, this.quad.a, Color.RED);
                this.drawCorner(g2, this.quad.b, Color.ORANGE);
            } else if (this.numSelected == 3) {
                this.drawLine(g2, this.quad.a, this.quad.b);
                this.drawLine(g2, this.quad.b, this.quad.c);
                this.drawCorner(g2, this.quad.a, Color.RED);
                this.drawCorner(g2, this.quad.b, Color.ORANGE);
                this.drawCorner(g2, this.quad.c, Color.CYAN);
            } else if (this.numSelected == 4) {
                VisualizeShapes.drawQuad(this.quad, g2, true, Color.gray, Color.CYAN);
                this.drawCorner(g2, this.quad.a, Color.RED);
                this.drawCorner(g2, this.quad.b, Color.ORANGE);
                this.drawCorner(g2, this.quad.c, Color.CYAN);
                this.drawCorner(g2, this.quad.d, Color.BLUE);
            }
        } else if (this.targetVisible) {
            VisualizeShapes.drawQuad(this.quad, g2, true, Color.gray, Color.CYAN);
            this.drawCorner(g2, this.quad.a, Color.RED);
            this.drawCorner(g2, this.quad.b, Color.RED);
            this.drawCorner(g2, this.quad.c, Color.RED);
            this.drawCorner(g2, this.quad.d, Color.RED);
        }
    }

    private void drawLine(Graphics2D g2, Point2D_F64 a, Point2D_F64 b) {
        g2.drawLine((int)(a.x + 0.5), (int)(a.y + 0.5), (int)(b.x + 0.5), (int)(b.y + 0.5));
    }

    private void drawCorner(Graphics2D g2, Point2D_F64 a, Color color) {
        VisualizeFeatures.drawPoint(g2, a.x, a.y, 6.0, color, false);
    }

    @Override
    public synchronized void mouseClicked(MouseEvent e) {
        if (!this.selectMode || this.numSelected >= 4) {
            return;
        }
        if (this.numSelected == 0) {
            this.quad.a.set((double)e.getX(), (double)e.getY());
        } else if (this.numSelected == 1) {
            this.quad.b.set((double)e.getX(), (double)e.getY());
        } else if (this.numSelected == 2) {
            this.quad.c.set((double)e.getX(), (double)e.getY());
        } else if (this.numSelected == 3) {
            this.quad.d.set((double)e.getX(), (double)e.getY());
        }
        ++this.numSelected;
        this.repaint();
        if (this.numSelected == 4) {
            this.listener.selectedTarget(this.quad);
            this.selectMode = false;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.selectMode) {
            if (e.getButton() == 2) {
                System.out.println("Entering select mode");
                this.enterSelectMode();
            } else {
                this.listener.togglePause();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public boolean isSelectMode() {
        return this.selectMode;
    }

    public synchronized void setDefaultTarget(Quadrilateral_F64 target) {
        this.quad.set(target);
        this.numSelected = 4;
        this.selectMode = false;
        this.targetVisible = true;
        this.repaint();
    }

    public static interface Listener {
        public void selectedTarget(Quadrilateral_F64 var1);

        public void togglePause();
    }
}

