/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.edge;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU8;
import java.awt.Color;
import java.awt.image.BufferedImage;
import sun.awt.image.IntegerInterleavedRaster;

public class VisualizeEdgeFeatures {
    public static BufferedImage renderOrientation(GrayU8 direction, BufferedImage out) {
        if (out == null) {
            out = new BufferedImage(direction.getWidth(), direction.getHeight(), 1);
        }
        if (out.getRaster() instanceof IntegerInterleavedRaster) {
            int[] colors = new int[]{Color.RED.getRGB(), Color.GREEN.getRGB(), Color.BLUE.getRGB(), Color.BLACK.getRGB()};
            IntegerInterleavedRaster raster = (IntegerInterleavedRaster)out.getRaster();
            int rasterIndex = 0;
            int[] data = raster.getDataStorage();
            int w = direction.getWidth();
            int h = direction.getHeight();
            for (int y = 0; y < h; ++y) {
                int indexSrc = direction.startIndex + y * direction.stride;
                for (int x = 0; x < w; ++x) {
                    data[rasterIndex++] = colors[direction.data[indexSrc++]];
                }
            }
        } else {
            throw new RuntimeException("Raster not supported yet");
        }
        return out;
    }

    public static BufferedImage renderOrientation4(GrayS8 direction, GrayF32 intensity, float threshold, BufferedImage out) {
        if (out == null) {
            out = new BufferedImage(direction.getWidth(), direction.getHeight(), 1);
        }
        if (out.getRaster() instanceof IntegerInterleavedRaster) {
            int[] colors = new int[]{Color.RED.getRGB(), Color.GREEN.getRGB(), Color.BLUE.getRGB(), Color.BLACK.getRGB()};
            int white = Color.WHITE.getRGB();
            IntegerInterleavedRaster raster = (IntegerInterleavedRaster)out.getRaster();
            int rasterIndex = 0;
            int[] data = raster.getDataStorage();
            int w = direction.getWidth();
            int h = direction.getHeight();
            for (int y = 0; y < h; ++y) {
                int indexSrc = direction.startIndex + y * direction.stride;
                int indexInten = intensity.startIndex + y * intensity.stride;
                int x = 0;
                while (x < w) {
                    data[rasterIndex] = intensity.data[indexInten] >= threshold ? colors[direction.data[indexSrc] + 1] : white;
                    ++x;
                    ++indexInten;
                    ++indexSrc;
                    ++rasterIndex;
                }
            }
        } else {
            throw new RuntimeException("Raster not supported yet");
        }
        return out;
    }
}

