/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.d3;

import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.EulerType;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.ejml.data.DenseMatrix64F;

public class Polygon3DSequenceViewer
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener {
    List<Poly> polygons = new ArrayList<Poly>();
    Se3_F64 worldToCamera = new Se3_F64();
    DenseMatrix64F K;
    double stepSize;
    int prevX;
    int prevY;

    public Polygon3DSequenceViewer() {
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public DenseMatrix64F getK() {
        return this.K;
    }

    public void setK(DenseMatrix64F k) {
        this.K = k;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(double stepSize) {
        this.stepSize = stepSize;
    }

    public void init() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Polygon3DSequenceViewer.this.polygons.clear();
            }
        });
    }

    public void add(Color color, Point3D_F64 ... polygon) {
        final Poly p = new Poly(polygon.length, color);
        for (int i = 0; i < polygon.length; ++i) {
            p.pts[i] = polygon[i].copy();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Polygon3DSequenceViewer.this.polygons.add(p);
            }
        });
    }

    public void add(Point3D_F64 ... polygon) {
        final Poly p = new Poly(polygon.length, Color.BLACK);
        for (int i = 0; i < polygon.length; ++i) {
            p.pts[i] = polygon[i].copy();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Polygon3DSequenceViewer.this.polygons.add(p);
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Point3D_F64 p1 = new Point3D_F64();
        Point3D_F64 p2 = new Point3D_F64();
        Point2D_F64 x1 = new Point2D_F64();
        Point2D_F64 x2 = new Point2D_F64();
        for (Poly poly : this.polygons) {
            SePointOps_F64.transform((Se3_F64)this.worldToCamera, (Point3D_F64)poly.pts[0], (Point3D_F64)p1);
            GeometryMath_F64.mult((DenseMatrix64F)this.K, (GeoTuple3D_F64)p1, (GeoTuple2D_F64)x1);
            if (p1.z < 0.0) continue;
            g2.setColor(poly.color);
            boolean skip = false;
            for (int i = 1; i < poly.pts.length; ++i) {
                SePointOps_F64.transform((Se3_F64)this.worldToCamera, (Point3D_F64)poly.pts[i], (Point3D_F64)p2);
                GeometryMath_F64.mult((DenseMatrix64F)this.K, (GeoTuple3D_F64)p2, (GeoTuple2D_F64)x2);
                if (p2.z < 0.0) {
                    skip = true;
                    break;
                }
                g2.drawLine((int)x1.x, (int)x1.y, (int)x2.x, (int)x2.y);
                Point3D_F64 tempP = p1;
                Point2D_F64 tempX = x1;
                p1 = p2;
                p2 = tempP;
                x1 = x2;
                x2 = tempX;
            }
            if (skip) continue;
            SePointOps_F64.transform((Se3_F64)this.worldToCamera, (Point3D_F64)poly.pts[0], (Point3D_F64)p2);
            GeometryMath_F64.mult((DenseMatrix64F)this.K, (GeoTuple3D_F64)p2, (GeoTuple2D_F64)x2);
            g2.drawLine((int)x1.x, (int)x1.y, (int)x2.x, (int)x2.y);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        Vector3D_F64 T = this.worldToCamera.getT();
        if (e.getKeyChar() == 'w') {
            T.z -= this.stepSize;
        } else if (e.getKeyChar() == 's') {
            T.z += this.stepSize;
        } else if (e.getKeyChar() == 'a') {
            T.x += this.stepSize;
        } else if (e.getKeyChar() == 'd') {
            T.x -= this.stepSize;
        } else if (e.getKeyChar() == 'q') {
            T.y -= this.stepSize;
        } else if (e.getKeyChar() == 'e') {
            T.y += this.stepSize;
        } else if (e.getKeyChar() == 'h') {
            this.worldToCamera.reset();
        }
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.grabFocus();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevX = e.getX();
        this.prevY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double rotX = 0.0;
        double rotY = 0.0;
        double rotZ = 0.0;
        Se3_F64 rotTran = new Se3_F64();
        ConvertRotation3D_F64.eulerToMatrix((EulerType)EulerType.XYZ, (double)(rotX += (double)(this.prevY - e.getY()) * 0.01), (double)(rotY += (double)(e.getX() - this.prevX) * 0.01), (double)rotZ, (DenseMatrix64F)rotTran.getR());
        Se3_F64 temp = this.worldToCamera.concat(rotTran, null);
        this.worldToCamera.set(temp);
        this.prevX = e.getX();
        this.prevY = e.getY();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private static class Poly {
        Point3D_F64[] pts;
        Color color;

        public Poly() {
        }

        public Poly(int length, Color color) {
            this.pts = new Point3D_F64[length];
            this.color = color;
        }
    }
}

