/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.alg.geo.ModelObservationResidualN;
import boofcv.struct.geo.Point2D3D;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;

public class PnPResidualReprojection
implements ModelObservationResidualN<Se3_F64, Point2D3D> {
    Se3_F64 motion;
    Point3D_F64 temp = new Point3D_F64();

    @Override
    public void setModel(Se3_F64 model) {
        this.motion = model;
    }

    @Override
    public int computeResiduals(Point2D3D data, double[] residuals, int index) {
        SePointOps_F64.transform((Se3_F64)this.motion, (Point3D_F64)data.location, (Point3D_F64)this.temp);
        double expectedX = this.temp.x / this.temp.z;
        double expectedY = this.temp.y / this.temp.z;
        residuals[index++] = expectedX - data.observation.x;
        residuals[index++] = expectedY - data.observation.y;
        return index;
    }

    @Override
    public int getN() {
        return 2;
    }
}

