/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.tracker;

import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.tracker.DdaFeatureManager;
import boofcv.alg.feature.UtilFeature;
import boofcv.alg.feature.detect.interest.EasyGeneralFeatureDetector;
import boofcv.struct.QueueCorner;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.FastQueue;

public class DdaManagerGeneralPoint<I extends ImageSingleBand, D extends ImageSingleBand, Desc extends TupleDesc>
implements DdaFeatureManager<I, Desc> {
    private EasyGeneralFeatureDetector<I, D> detector;
    private DescribeRegionPoint<I, Desc> describe;
    private double scale;
    private FastQueue<Desc> descriptors;
    private FastQueue<Point2D_F64> locations = new FastQueue(100, Point2D_F64.class, true);

    public DdaManagerGeneralPoint(EasyGeneralFeatureDetector<I, D> detector, DescribeRegionPoint<I, Desc> describe, double scale) {
        this.detector = detector;
        this.describe = describe;
        this.scale = scale;
        this.descriptors = UtilFeature.createQueue(describe, (int)100);
    }

    @Override
    public void detectFeatures(I input, FastQueue<Point2D_F64> locDst, FastQueue<Desc> featDst) {
        this.detector.detect(input, null);
        this.describe.setImage(input);
        QueueCorner found = this.detector.getMaximums();
        this.descriptors.reset();
        this.locations.reset();
        for (int i = 0; i < found.size; ++i) {
            Point2D_I16 p = (Point2D_I16)found.get(i);
            TupleDesc desc = (TupleDesc)this.descriptors.grow();
            if (this.describe.process((double)p.x, (double)p.y, 0.0, this.scale, desc)) {
                Point2D_F64 loc = (Point2D_F64)this.locations.grow();
                loc.set((double)p.x, (double)p.y);
                this.describe.process(loc.x, loc.y, 0.0, this.scale, desc);
                featDst.add((Object)desc);
                locDst.add((Object)loc);
                continue;
            }
            this.descriptors.removeTail();
        }
    }

    public Desc createDescription() {
        return (Desc)this.describe.createDescription();
    }

    public Class<Desc> getDescriptionType() {
        return this.describe.getDescriptionType();
    }
}

