/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.RadialDistortionEstimateLinear;
import boofcv.alg.geo.calibration.Zhang99CalibrationMatrixFromHomographies;
import boofcv.alg.geo.calibration.Zhang99ComputeTargetHomography;
import boofcv.alg.geo.calibration.Zhang99DecomposeHomography;
import boofcv.alg.geo.calibration.Zhang99OptimizationFunction;
import boofcv.alg.geo.calibration.Zhang99OptimizationJacobian;
import boofcv.alg.geo.calibration.Zhang99ParamAll;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.DenseMatrix64F;

public class CalibrationPlanarGridZhang99 {
    private Zhang99ComputeTargetHomography computeHomography;
    private Zhang99CalibrationMatrixFromHomographies computeK;
    private RadialDistortionEstimateLinear computeRadial;
    private Zhang99DecomposeHomography decomposeH = new Zhang99DecomposeHomography();
    private Zhang99ParamAll optimized;
    private UnconstrainedLeastSquares optimizer;
    private Listener listener;
    private List<Point2D_F64> layout;

    public CalibrationPlanarGridZhang99(List<Point2D_F64> layout, boolean assumeZeroSkew, int numRadialParam, boolean includeTangential) {
        this.layout = layout;
        this.computeHomography = new Zhang99ComputeTargetHomography(layout);
        this.computeK = new Zhang99CalibrationMatrixFromHomographies(assumeZeroSkew);
        this.computeRadial = new RadialDistortionEstimateLinear(layout, numRadialParam);
        this.optimized = new Zhang99ParamAll(assumeZeroSkew, numRadialParam, includeTangential);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public boolean process(List<CalibrationObservation> observations) {
        this.optimized.setNumberOfViews(observations.size());
        Zhang99ParamAll initial = this.initialParam(observations);
        if (initial == null) {
            return false;
        }
        this.status("Non-linear refinement");
        return this.optimizedParam(observations, this.layout, initial, this.optimized, this.optimizer);
    }

    protected Zhang99ParamAll initialParam(List<CalibrationObservation> observations) {
        this.status("Estimating Homographies");
        ArrayList<DenseMatrix64F> homographies = new ArrayList<DenseMatrix64F>();
        ArrayList<Se3_F64> motions = new ArrayList<Se3_F64>();
        for (CalibrationObservation calibrationObservation : observations) {
            if (!this.computeHomography.computeHomography(calibrationObservation)) {
                return null;
            }
            DenseMatrix64F H = this.computeHomography.getHomography();
            homographies.add(H);
        }
        this.status("Estimating Calibration Matrix");
        this.computeK.process(homographies);
        DenseMatrix64F K = this.computeK.getCalibrationMatrix();
        this.decomposeH.setCalibrationMatrix(K);
        for (DenseMatrix64F H : homographies) {
            motions.add(this.decomposeH.decompose(H));
        }
        this.status("Estimating Radial Distortion");
        this.computeRadial.process(K, homographies, observations);
        double[] dArray = this.computeRadial.getParameters();
        return CalibrationPlanarGridZhang99.convertIntoZhangParam(motions, K, this.optimized.assumeZeroSkew, dArray, this.optimized.includeTangential);
    }

    private void status(String message) {
        if (this.listener != null && !this.listener.zhangUpdate(message)) {
            throw new RuntimeException("User requested termination of calibration");
        }
    }

    public boolean optimizedParam(List<CalibrationObservation> observations, List<Point2D_F64> grid, Zhang99ParamAll initial, Zhang99ParamAll found, UnconstrainedLeastSquares optimizer) {
        if (optimizer == null) {
            optimizer = FactoryOptimization.leastSquaresLM((double)0.001, (boolean)true);
        }
        double[] model = new double[initial.numParameters()];
        initial.convertToParam(model);
        Zhang99OptimizationFunction func = new Zhang99OptimizationFunction(initial.createNew(), grid, observations);
        Zhang99OptimizationJacobian jacobian = new Zhang99OptimizationJacobian(initial.assumeZeroSkew, initial.radial.length, initial.includeTangential, observations, grid);
        optimizer.setFunction((FunctionNtoM)func, (FunctionNtoMxN)jacobian);
        optimizer.initialize(model, 1.0E-10, 1.0E-25 * (double)observations.size());
        for (int i = 0; i < 500 && !optimizer.iterate(); ++i) {
            if (i % 25 != 0) continue;
            this.status("Progress " + (double)(100 * i) / 500.0 + "%");
        }
        double[] param = optimizer.getParameters();
        found.setFromParam(param);
        return true;
    }

    public static Zhang99ParamAll convertIntoZhangParam(List<Se3_F64> motions, DenseMatrix64F K, boolean assumeZeroSkew, double[] distort, boolean includeTangential) {
        Zhang99ParamAll ret = new Zhang99ParamAll();
        ret.assumeZeroSkew = assumeZeroSkew;
        ret.a = K.get(0, 0);
        ret.b = K.get(1, 1);
        ret.c = K.get(0, 1);
        ret.x0 = K.get(0, 2);
        ret.y0 = K.get(1, 2);
        ret.radial = distort;
        ret.includeTangential = includeTangential;
        ret.views = new Zhang99ParamAll.View[motions.size()];
        for (int i = 0; i < ret.views.length; ++i) {
            Se3_F64 m = motions.get(i);
            Zhang99ParamAll.View v = new Zhang99ParamAll.View();
            v.T = m.getT();
            ConvertRotation3D_F64.matrixToRodrigues((DenseMatrix64F)m.getR(), (Rodrigues_F64)v.rotation);
            ret.views[i] = v;
        }
        return ret;
    }

    public static void applyDistortion(Point2D_F64 normPt, double[] radial, double t1, double t2) {
        double r2;
        double x = normPt.x;
        double y = normPt.y;
        double a = 0.0;
        double r2i = r2 = x * x + y * y;
        for (int i = 0; i < radial.length; ++i) {
            a += radial[i] * r2i;
            r2i *= r2;
        }
        normPt.x = x + x * a + 2.0 * t1 * x * y + t2 * (r2 + 2.0 * x * x);
        normPt.y = y + y * a + t1 * (r2 + 2.0 * y * y) + 2.0 * t2 * x * y;
    }

    public void setOptimizer(UnconstrainedLeastSquares optimizer) {
        this.optimizer = optimizer;
    }

    public Zhang99ParamAll getOptimized() {
        return this.optimized;
    }

    public static int totalPoints(List<CalibrationObservation> observations) {
        int total = 0;
        for (int i = 0; i < observations.size(); ++i) {
            total += observations.get(i).size();
        }
        return total;
    }

    public static interface Listener {
        public boolean zhangUpdate(String var1);
    }
}

