/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.calibration;

import boofcv.abst.geo.calibration.CalibrateMonoPlanar;
import boofcv.abst.geo.calibration.CalibrationDetector;
import boofcv.alg.geo.calibration.Zhang99ParamAll;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.image.GrayF32;
import georegression.fitting.se.FitSpecialEuclideanOps_F64;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DenseMatrix64F;

public class CalibrateStereoPlanar {
    List<Se3_F64> viewLeft = new ArrayList<Se3_F64>();
    List<Se3_F64> viewRight = new ArrayList<Se3_F64>();
    CalibrateMonoPlanar calibLeft;
    CalibrateMonoPlanar calibRight;
    List<Point2D_F64> layout;

    public CalibrateStereoPlanar(CalibrationDetector detector) {
        this.calibLeft = new CalibrateMonoPlanar(detector);
        this.calibRight = new CalibrateMonoPlanar(detector);
        this.layout = detector.getLayout();
    }

    public void reset() {
        this.viewLeft.clear();
        this.viewRight.clear();
        this.calibLeft.reset();
        this.calibRight.reset();
    }

    public void configure(boolean assumeZeroSkew, int numRadialParam, boolean includeTangential) {
        this.calibLeft.configure(assumeZeroSkew, numRadialParam, includeTangential);
        this.calibRight.configure(assumeZeroSkew, numRadialParam, includeTangential);
    }

    public boolean addPair(GrayF32 left, GrayF32 right) {
        if (!this.calibLeft.addImage(left)) {
            return false;
        }
        if (!this.calibRight.addImage(right)) {
            this.calibLeft.removeLatestImage();
            return false;
        }
        return true;
    }

    public StereoParameters process() {
        IntrinsicParameters leftParam = this.calibrateMono(this.calibLeft, this.viewLeft);
        IntrinsicParameters rightParam = this.calibrateMono(this.calibRight, this.viewRight);
        Se3_F64 rightToLeft = this.computeRightToLeft();
        return new StereoParameters(leftParam, rightParam, rightToLeft);
    }

    private IntrinsicParameters calibrateMono(CalibrateMonoPlanar calib, List<Se3_F64> location) {
        IntrinsicParameters intrinsic = calib.process();
        Zhang99ParamAll zhangParam = calib.getZhangParam();
        for (Zhang99ParamAll.View v : zhangParam.views) {
            Se3_F64 pose = new Se3_F64();
            ConvertRotation3D_F64.rodriguesToMatrix((Rodrigues_F64)v.rotation, (DenseMatrix64F)pose.getR());
            pose.getT().set(v.T);
            location.add(pose);
        }
        return intrinsic;
    }

    private Se3_F64 computeRightToLeft() {
        List<Point2D_F64> points2D = this.layout;
        ArrayList<Point3D_F64> points3D = new ArrayList<Point3D_F64>();
        for (Point2D_F64 p : points2D) {
            points3D.add(new Point3D_F64(p.x, p.y, 0.0));
        }
        ArrayList<Point3D_F64> left = new ArrayList<Point3D_F64>();
        ArrayList<Point3D_F64> right = new ArrayList<Point3D_F64>();
        for (int i = 0; i < this.viewLeft.size(); ++i) {
            Se3_F64 worldToLeft = this.viewLeft.get(i);
            Se3_F64 worldToRight = this.viewRight.get(i);
            for (Point3D_F64 p : points3D) {
                Point3D_F64 l = SePointOps_F64.transform((Se3_F64)worldToLeft, (Point3D_F64)p, null);
                Point3D_F64 r = SePointOps_F64.transform((Se3_F64)worldToRight, (Point3D_F64)p, null);
                left.add(l);
                right.add(r);
            }
        }
        return FitSpecialEuclideanOps_F64.fitPoints3D(right, left);
    }

    public CalibrateMonoPlanar getCalibLeft() {
        return this.calibLeft;
    }

    public CalibrateMonoPlanar getCalibRight() {
        return this.calibRight;
    }

    public void printStatistics() {
        System.out.println("********** LEFT ************");
        this.calibLeft.printStatistics();
        System.out.println("********** RIGHT ************");
        this.calibRight.printStatistics();
    }
}

