/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.grid;

import boofcv.struct.image.ImageFloat32;

public class IntensityHistogram {
    public int[] histogram;
    public int total;
    public double maxValue;
    public double divisor;

    public IntensityHistogram(int numBins, double maxValue) {
        this.histogram = new int[numBins];
        this.maxValue = maxValue;
        this.divisor = maxValue / (double)numBins;
    }

    public void reset() {
        for (int i = 0; i < this.histogram.length; ++i) {
            this.histogram[i] = 0;
        }
        this.total = 0;
    }

    public void add(double value) {
        int index;
        int n = index = (int)(value / this.divisor);
        this.histogram[n] = this.histogram[n] + 1;
        ++this.total;
    }

    public void add(ImageFloat32 image) {
        for (int y = 0; y < image.height; ++y) {
            int index;
            int end = index + image.width;
            for (index = image.startIndex + image.stride * y; index < end; ++index) {
                int n = (int)((double)image.data[index] / this.divisor);
                this.histogram[n] = this.histogram[n] + 1;
            }
        }
        this.total += image.width * image.height;
    }

    public void downSample(IntensityHistogram h) {
        for (int i = 0; i < h.histogram.length; ++i) {
            int index;
            int n = index = (int)(((double)i * h.divisor + h.divisor / 2.0) / this.divisor);
            this.histogram[n] = this.histogram[n] + h.histogram[i];
        }
        this.total = h.total;
    }

    public int getTotal() {
        return this.total;
    }
}

