/*
 * Decompiled with CFR 0.152.
 */
package boofcv.simulation;

import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.distort.NarrowPixelToSphere_F64;
import boofcv.alg.distort.SphereToNarrowPixel_F64;
import boofcv.alg.distort.brown.LensDistortionBrown;
import boofcv.alg.distort.pinhole.LensDistortionPinhole;
import boofcv.alg.distort.universal.LensDistortionUniversalOmni;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.calib.CameraUniversalOmni;
import boofcv.struct.distort.Point2Transform3_F64;
import boofcv.struct.distort.Point3Transform2_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.geometry.GeometryMath_F64;
import georegression.geometry.UtilShape3D_F64;
import georegression.metric.Intersection3D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.line.LineParametric3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.struct.shapes.Rectangle2D_I32;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrixRMaj;

public class SimulatePlanarWorld {
    GrayF32 output = new GrayF32(1, 1);
    GrayF32 depthMap = new GrayF32(1, 1);
    List<SurfaceRect> scene = new ArrayList<SurfaceRect>();
    Point2Transform3_F64 pixelTo3;
    Point3Transform2_F64 sphereToPixel;
    Se3_F64 worldToCamera = new Se3_F64();
    Point3D_F64 p3 = new Point3D_F64();
    float[] pointing = new float[0];
    float background = 0.0f;
    Point2D_F64 pixel = new Point2D_F64();
    LineParametric3D_F64 ray = new LineParametric3D_F64();
    RenderPixel renderPixel = new RenderPixel();
    public int renderSampling = 2;

    public void enableHighAccuracy() {
        this.renderSampling = 4;
    }

    public void setCamera(CameraUniversalOmni model) {
        LensDistortionUniversalOmni factory = new LensDistortionUniversalOmni(model);
        this.pixelTo3 = factory.undistortPtoS_F64();
        this.sphereToPixel = factory.distortStoP_F64();
        this.computeProjectionTable(model.width, model.height);
    }

    public void setCamera(CameraPinhole model) {
        LensDistortionPinhole factory = new LensDistortionPinhole(model);
        this.setCamera((LensDistortionNarrowFOV)factory, model.width, model.height);
    }

    public void setCamera(CameraPinholeBrown model) {
        LensDistortionBrown factory = new LensDistortionBrown(model);
        this.setCamera((LensDistortionNarrowFOV)factory, model.width, model.height);
    }

    public void setCamera(LensDistortionNarrowFOV model, int width, int height) {
        this.pixelTo3 = new NarrowPixelToSphere_F64(model.undistort_F64(true, false));
        this.sphereToPixel = new SphereToNarrowPixel_F64(model.distort_F64(false, true));
        this.computeProjectionTable(width, height);
    }

    public void setWorldToCamera(Se3_F64 worldToCamera) {
        this.worldToCamera.setTo(worldToCamera);
    }

    void computeProjectionTable(int width, int height) {
        this.output.reshape(width, height);
        this.depthMap.reshape(width, height);
        ImageMiscOps.fill((GrayF32)this.depthMap, (float)-1.0f);
        int samplesPerPixel = this.renderSampling * this.renderSampling;
        int pointingPixelStride = samplesPerPixel * 3;
        int pointingStride = this.output.width * pointingPixelStride;
        this.pointing = new float[height * pointingStride];
        double offsetSample = 0.5 / (double)this.renderSampling;
        for (int y = 0; y < this.output.height; ++y) {
            block1: for (int x = 0; x < this.output.width; ++x) {
                int pointingIndex = y * pointingStride + x * pointingPixelStride;
                for (int sampleIdx = 0; sampleIdx < samplesPerPixel; ++sampleIdx) {
                    int sampleY = sampleIdx / this.renderSampling;
                    int sampleX = sampleIdx % this.renderSampling;
                    double subY = (double)sampleY / (double)this.renderSampling;
                    double subX = (double)sampleX / (double)this.renderSampling;
                    this.pixelTo3.compute(offsetSample + (double)x + subX, offsetSample + (double)y + subY, this.p3);
                    if (UtilEjml.isUncountable((double)this.p3.x)) {
                        this.depthMap.unsafe_set(x, y, Float.NaN);
                        continue block1;
                    }
                    this.pointing[pointingIndex++] = (float)this.p3.x;
                    this.pointing[pointingIndex++] = (float)this.p3.y;
                    this.pointing[pointingIndex++] = (float)this.p3.z;
                }
            }
        }
    }

    public void addSurface(Se3_F64 rectToWorld, double widthWorld, GrayF32 texture) {
        SurfaceRect s = new SurfaceRect();
        s.texture.setTo((ImageGray)texture);
        s.width3D = widthWorld;
        s.rectToWorld = rectToWorld;
        this.scene.add(s);
    }

    public void resetScene() {
        this.scene.clear();
    }

    public GrayF32 render() {
        ImageMiscOps.fill((GrayF32)this.output, (float)this.background);
        ImageMiscOps.fill((GrayF32)this.depthMap, (float)Float.MAX_VALUE);
        for (int i = 0; i < this.scene.size(); ++i) {
            this.scene.get(i).rectInCamera();
        }
        if (BoofConcurrency.USE_CONCURRENT && this.output.width * this.output.height > 10000) {
            this.renderMultiThread();
        } else {
            this.renderSingleThread(0, this.output.height, this.renderPixel, this.ray);
        }
        return this.getOutput();
    }

    private void renderSingleThread(int y0, int y1, RenderPixel renderPixel, LineParametric3D_F64 ray) {
        int samplesPerPixel = this.renderSampling * this.renderSampling;
        int pointingPixelStride = samplesPerPixel * 3;
        int pointingStride = this.output.width * pointingPixelStride;
        for (int pixelY = y0; pixelY < y1; ++pixelY) {
            int depthIdx = pixelY * this.depthMap.stride;
            for (int pixelX = 0; pixelX < this.output.width; ++pixelX) {
                if (Float.isNaN(this.depthMap.data[depthIdx++])) continue;
                for (int i = 0; i < this.scene.size(); ++i) {
                    SurfaceRect r = this.scene.get(i);
                    if (!r.visible) continue;
                    float sumValue = 0.0f;
                    float sumDepth = 0.0f;
                    int pointingIndex = pixelY * pointingStride + pixelX * pointingPixelStride;
                    for (int sampleIdx = 0; sampleIdx < samplesPerPixel; ++sampleIdx) {
                        ray.slope.x = this.pointing[pointingIndex++];
                        ray.slope.y = this.pointing[pointingIndex++];
                        ray.slope.z = this.pointing[pointingIndex++];
                        if (pixelX < r.pixelRect.x0 || pixelX >= r.pixelRect.x1 || pixelY < r.pixelRect.y0 || pixelY >= r.pixelRect.y1) continue;
                        if (renderPixel.render(ray, r, this.depthMap.unsafe_get(pixelX, pixelY))) {
                            sumValue += renderPixel.value;
                            sumDepth += renderPixel.depth;
                            continue;
                        }
                        sumDepth = 0.0f;
                        break;
                    }
                    if (!(sumDepth > 0.0f)) continue;
                    this.output.unsafe_set(pixelX, pixelY, sumValue / (float)samplesPerPixel);
                    this.depthMap.unsafe_set(pixelX, pixelY, sumDepth / (float)samplesPerPixel);
                }
            }
        }
    }

    private void renderMultiThread() {
        BoofConcurrency.loopBlocks((int)0, (int)this.output.height, (y0, y1) -> {
            RenderPixel renderPixel = new RenderPixel();
            LineParametric3D_F64 ray = new LineParametric3D_F64();
            this.renderSingleThread(y0, y1, renderPixel, ray);
        });
    }

    public SurfaceRect getImageRect(int which) {
        return this.scene.get(which);
    }

    public void setBackground(float background) {
        this.background = background;
    }

    public void computePixel(int which, double x, double y, Point2D_F64 output) {
        SurfaceRect r = this.scene.get(which);
        Point3D_F64 p3 = new Point3D_F64(-x, -y, 0.0);
        SePointOps_F64.transform((Se3_F64)r.rectToCamera, (Point3D_F64)p3, (Point3D_F64)p3);
        p3.scale(1.0 / p3.norm());
        this.sphereToPixel.compute(p3.x, p3.y, p3.z, output);
    }

    public GrayF32 getOutput() {
        return this.output;
    }

    public GrayF32 getDepthMap() {
        return this.depthMap;
    }

    static class RenderPixel {
        public float value;
        public float depth;
        Vector3D_F64 _u = new Vector3D_F64();
        Vector3D_F64 _v = new Vector3D_F64();
        Vector3D_F64 _n = new Vector3D_F64();
        Vector3D_F64 _w0 = new Vector3D_F64();
        Point3D_F64 p3 = new Point3D_F64();

        RenderPixel() {
        }

        public boolean render(LineParametric3D_F64 ray, SurfaceRect r, float currentDepth) {
            if (1 != Intersection3D_F64.intersectConvex(r.rect3D, (LineParametric3D_F64)ray, (Point3D_F64)this.p3, (Vector3D_F64)this._u, (Vector3D_F64)this._v, (Vector3D_F64)this._n, (Vector3D_F64)this._w0)) {
                return false;
            }
            this.depth = (float)this.p3.z;
            if (this.depth <= 0.0f || this.depth >= currentDepth) {
                return false;
            }
            SePointOps_F64.transformReverse((Se3_F64)r.rectToCamera, (Point3D_F64)this.p3, (Point3D_F64)this.p3);
            double surfaceX = (-this.p3.x / r.width3D + 0.5) * (double)r.texture.width;
            double surfaceY = (this.p3.y / r.height3D + 0.5) * (double)r.texture.height;
            surfaceX += 0.5;
            surfaceY += 0.5;
            if (surfaceX >= 0.0 && surfaceX < (double)r.texture.width && surfaceY >= 0.0 && surfaceY < (double)r.texture.height) {
                this.value = r.texture.unsafe_get((int)surfaceX, (int)surfaceY);
                return true;
            }
            return false;
        }
    }

    public class SurfaceRect {
        Se3_F64 rectToWorld;
        Se3_F64 rectToCamera = new Se3_F64();
        Vector3D_F64 normal = new Vector3D_F64();
        public final GrayF32 texture = new GrayF32(1, 1);
        public double width3D;
        public double height3D;
        final DogArray<Point3D_F64> rect3D = new DogArray(Point3D_F64::new);
        final Polygon2D_F64 rect2D = new Polygon2D_F64();
        final Rectangle2D_I32 pixelRect = new Rectangle2D_I32();
        public boolean visible;

        public void rectInCamera() {
            this.rectToWorld.concat(SimulatePlanarWorld.this.worldToCamera, this.rectToCamera);
            this.normal.setTo(0.0, 0.0, 1.0);
            GeometryMath_F64.mult((DMatrixRMaj)this.rectToCamera.R, (GeoTuple3D_F64)this.normal, (GeoTuple3D_F64)this.normal);
            boolean bl = this.visible = this.normal.z < 0.0;
            if (!this.visible) {
                this.pixelRect.y1 = 0;
                this.pixelRect.x1 = 0;
                this.pixelRect.y0 = 0;
                this.pixelRect.x0 = 0;
                return;
            }
            double imageRatio = (double)this.texture.height / (double)this.texture.width;
            this.height3D = this.width3D * imageRatio;
            this.rect2D.vertexes.resize(4);
            this.rect2D.set(0, -this.width3D / 2.0, -this.height3D / 2.0);
            this.rect2D.set(1, -this.width3D / 2.0, this.height3D / 2.0);
            this.rect2D.set(2, this.width3D / 2.0, this.height3D / 2.0);
            this.rect2D.set(3, this.width3D / 2.0, -this.height3D / 2.0);
            UtilShape3D_F64.polygon2Dto3D((Polygon2D_F64)this.rect2D, (Se3_F64)this.rectToCamera, this.rect3D);
            this.pixelRect.setTo(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
            int i = 0;
            int j = 3;
            while (i < 4) {
                Point3D_F64 a = (Point3D_F64)this.rect3D.get(j);
                Point3D_F64 b = (Point3D_F64)this.rect3D.get(i);
                for (int k = 0; k < 50; ++k) {
                    double w = (double)k / 50.0;
                    SimulatePlanarWorld.this.p3.x = a.x * (1.0 - w) + b.x * w;
                    SimulatePlanarWorld.this.p3.y = a.y * (1.0 - w) + b.y * w;
                    SimulatePlanarWorld.this.p3.z = a.z * (1.0 - w) + b.z * w;
                    SimulatePlanarWorld.this.p3.divideIP(SimulatePlanarWorld.this.p3.norm());
                    SimulatePlanarWorld.this.sphereToPixel.compute(SimulatePlanarWorld.this.p3.x, SimulatePlanarWorld.this.p3.y, SimulatePlanarWorld.this.p3.z, SimulatePlanarWorld.this.pixel);
                    int x = (int)Math.round(SimulatePlanarWorld.this.pixel.x);
                    int y = (int)Math.round(SimulatePlanarWorld.this.pixel.y);
                    this.pixelRect.x0 = Math.min(this.pixelRect.x0, x);
                    this.pixelRect.y0 = Math.min(this.pixelRect.y0, y);
                    this.pixelRect.x1 = Math.max(this.pixelRect.x1, x + 1);
                    this.pixelRect.y1 = Math.max(this.pixelRect.y1, y + 1);
                }
                j = i++;
            }
            this.pixelRect.x0 -= 2;
            this.pixelRect.x1 += 2;
            this.pixelRect.y0 -= 2;
            this.pixelRect.y1 += 2;
        }

        public Polygon2D_F64 computeImageBoundingRect() {
            Polygon2D_F64 rect = new Polygon2D_F64(4);
            UtilShape3D_F64.polygon2Dto3D((Polygon2D_F64)this.rect2D, (Se3_F64)this.rectToCamera, this.rect3D);
            for (int i = 0; i < rect.size(); ++i) {
                Point3D_F64 p = (Point3D_F64)this.rect3D.get(i);
                SimulatePlanarWorld.this.sphereToPixel.compute(p.x, p.y, p.z, rect.get(i));
            }
            return rect;
        }

        public Se3_F64 getRectToWorld() {
            return this.rectToWorld;
        }

        public Se3_F64 getRectToCamera() {
            return this.rectToCamera;
        }

        public Vector3D_F64 getNormal() {
            return this.normal;
        }

        public DogArray<Point3D_F64> getRect3D() {
            return this.rect3D;
        }

        public Polygon2D_F64 getRect2D() {
            return this.rect2D;
        }

        public Rectangle2D_I32 getPixelRect() {
            return this.pixelRect;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }
}

